#include <stdio.h>
#include <string.h>

/* output buffer size - this is space efficient */
#define OBUFSIZE 16384

void main()
{
  unsigned int noteof, inlen, i, mark, totlen, readgot;
  unsigned char dbuf[OBUFSIZE];

  while (!feof(stdin)) {
    mark = 0, totlen = 0;
    inlen = fgetc(stdin);
    if (inlen == 0xa8) {
      noteof = fgetc(stdin);    /* len */
      while (noteof--)
        inlen = fgetc(stdin);
      inlen = fgetc(stdin);
    }
    if (inlen != 0xc8) {
      inlen = ((inlen & 0x0f) << 2) | 0x82;
      fputc(inlen, stdout);     /* this is for the CTB */
      mark = ftell(stdout);
      for (i = 0; i < 4; i++)
        fputc(0, stdout);
    } else
      fputc(0xa3, stdout);      /* compression uses internal EOT */

    inlen = 0;
    noteof = 1;
    while (!feof(stdin) && noteof) {

      if (!inlen && noteof) {
        noteof = 0;
        inlen = 0xff & fgetc(stdin);
        if (inlen >= 0xc0) {
          if (inlen >= 0xe0) {
            if (inlen == 0xff) {
              for (inlen = 0, i = 0; i < 4; i++)
                inlen = (inlen << 8) + fgetc(stdin);
            } else {
              noteof = 1;
              inlen = 1 << (inlen & 31);
            }
          } else {
            inlen = ((inlen & 31) << 8) + 192;
            inlen += 0xff & fgetc(stdin);
          }
        }
      }
      while (inlen) {
        readgot = fread(dbuf, 1, inlen > OBUFSIZE ? OBUFSIZE : inlen, stdin);
        if (readgot <= 0)
          break;
        fwrite(dbuf, 1, readgot, stdout);
        inlen -= readgot;
        totlen += readgot;
      }
    }
    inlen = ftell(stdout);
    if (!mark || fseek(stdout, mark, SEEK_SET))
      continue;
    fputc(totlen >> 24, stdout), fputc(totlen >> 16, stdout);
    fputc(totlen >> 8, stdout), fputc(totlen, stdout);
    fseek(stdout, inlen, SEEK_SET);
  }
}
