// -*- C++ -*-

// Copyright (C) 2005 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

// Copyright (C) 2004 Ami Tavory and Vladimir Dreizin, IBM-HRL.

// Permission to use, copy, modify, sell, and distribute this software
// is hereby granted without fee, provided that the above copyright
// notice appears in all copies, and that both that copyright notice and
// this permission notice appear in supporting documentation. None of
// the above authors, nor IBM Haifa Research Laboratories, make any
// representation about the suitability of this software for any
// purpose. It is provided "as is" without express or implied warranty.

/**
 * @file tree_split_example.cpp
 * A basic example showing how to split tree-based container objects.
 */

// For rb_tree_assoc_cntnr.
#include <ext/pb_assoc/assoc_cntnr.hpp>
// For assert
#include <cassert>

int
main()
{
  /*
   * A red-black tree table mapping ints to chars.
   */
  typedef pb_assoc::tree_assoc_cntnr< int, char> map_t;

  // A map_t object.
  map_t r;

  // Inserts some entries into r.

  for (int i = 0; i < 100; ++ i)
    r.insert(std::make_pair(i, 'a'));

  // Now split r into a different map_t object.

  // larger_r will hold the larger values following the split.
  map_t larger_r;

  // Split all elements larger than 1000 into larger_r. This is exception free.
  r.split(1000, larger_r);

  /*
   * Since there were no elements larger than 1000, r
   *	should be unchanged.
   **/

  assert(r.size() == 100);
  assert(r.begin()->first == 0);

  // Now perform a split which actually changes the content of r.

  // Split all elements larger than 3 into larger_r.
  r.split(3, larger_r);

  assert(r.size() == 4);
  assert(larger_r.begin()->first == 4);
}

