#!/bin/sh
# ensure that mv removes a in this case: touch a; ln a b; mv a b

# Copyright (C) 2003-2012 Free Software Foundation, Inc.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. "${srcdir=.}/tests/init.sh"; path_prepend_ ./src
print_ver_ mv
touch a || framework_failure_
ln a b || framework_failure_


mv a b || fail=1

# In coreutils-5.0 and earlier, a would not be removed.
test -r a && fail=1
test -r b || fail=1

# Make sure it works also with --backup.
ln b a
mv --backup=simple a b || fail=1
test -r a && fail=1
test -r b || fail=1
test -r b~ || fail=1

Exit $fail
