/****************************************************************************
 *                                                                          *
 *      dq.c                                                                *
 *      Copyright 1987, 1988, 1989, Pittsburgh Supercomputing Center        *
 *                      All Rights Reserved                                 *
 *                      Author Phil Andrews                                 *
 *                                                                          *
 ****************************************************************************/
/* the diaquest controller module */
#include <stdio.h>
#include <ctype.h>
#include "defs.h"
#define max_str 128
#define WAIT_SECS 600		/* time to wait for command reply */
#define good_reply "COMMAND SENT TO VTR AND ACKNOWLEDGED"
#define bad_reply "COMMAND SENT TO VTR AND NOT ACKNOWLEDGED"
#define ugly_reply "COMMAND SENT TO VTR -- ERROR"

#define ctrl_m	'\015'	/* do <CR> */
static int deb;			/* debugging ? */
static char rep_str[max_str];	/* the reply string from the diaquest */
static char open_name[max_str];	/* the device name for the diaquest */

#ifdef VMS
#include rms			/* RMS I/O stuff */
int rms_status, LIB$SIGNAL();
#define do_rms(rms_fun, rms_arg) { rms_status = rms_fun(rms_arg);\
	if(rms_status != RMS$_NORMAL) {printf("\nerror in rms_fun");\
		LIB$SIGNAL(rms_status);} }
/* rms blocks for the diaquest */
struct FAB infbl;	/* input file block */
struct FAB outfbl;	/* output file block */
struct RAB inrbl;	/* input record block */
struct RAB outrbl;	/* output record block */
static char ctr_dev[max_str] = "CSA0:";/* device to talk to diaquest */

#else
/* Defines relevant to Unix follow */

#include <ctype.h>

#ifdef ardent
#define SYSV
#endif

#ifdef sgi
#define SYSV
#endif

#ifdef SYSV
#include <termio.h>
#else
#include <sgtty.h>
#endif

static char ctr_dev[max_str] = "/dev/tty0";/* device to talk to diaquest */
FILE *ofile, *ifile;

#endif

static struct one_opt *popt;	/* the command line options, in only */
/* set up for diaquest */
dq_setup()
{
#ifdef VMS
	infbl = cc$rms_fab;
	outfbl = cc$rms_fab;
	inrbl = cc$rms_rab;
	outrbl = cc$rms_rab;
	inrbl.rab$l_fab = &infbl;	/* connect file and record */
	outrbl.rab$l_fab = &outfbl;	/* connect file and record */

	open_file("foo.in", ctr_dev, open_name, &infbl,  0);
	do_rms(sys$connect, &inrbl);
	open_file("foo.out", ctr_dev, open_name, &outfbl,  1);
	do_rms(sys$connect, &outrbl);

	inrbl.rab$l_ubf = rep_str;
	inrbl.rab$w_usz = sizeof rep_str;
	inrbl.rab$l_rop = RAB$M_ASY;	/* asynch get */
#else
fprintf(stderr,"About to open port <%s>\n",ctr_dev);
	open_port(ctr_dev);
	fprintf(stderr, "opened port\n");
#endif
	tell_diaquest("setin", popt[(int) start].val.i, 1, 0);
	sleep(4);	/* wait a little */
	return(1);
}
/* make an edit */
dq_edit()
{
char buffer[max_str];
static int edits_done = 0;
extern void vcxxsync();

#ifdef VMS
	/* first make sure the image is synched */
	vcxxsync();
#endif

	if (popt[(int) copies].val.i > 1) sprintf(buffer, "edit %dfp", 
	    popt[(int) copies].val.i);
	else sprintf(buffer, "editfp");

	tell_diaquest(buffer, 0, 0, 1);
	++edits_done;
	fprintf(stderr, "[%d", edits_done);
	if (popt[(int) copies].val.i > 1) fprintf(stderr, ",%d", 
	    popt[(int) copies].val.i);
	fprintf(stderr, "]");
	return(1);
}

/* send a command to the diaquest */
tell_diaquest(in_str, cmd_int, time, wait)
char *in_str;
int cmd_int, time, wait;
{
int out_len, hrs, min, secs, frames, temp, i;
char tell_str[max_str], c;
	if (cmd_int) {
	    if (time) {
		temp = (30 * 60 * 60);
		hrs = cmd_int / temp;
		cmd_int -= hrs * temp;
		temp = temp / 60;
		min = cmd_int / temp;
		cmd_int -= min * temp;
		temp = temp / 60;
		secs = cmd_int / temp;
		frames = cmd_int - secs * temp;
		sprintf(tell_str, "%s %02d:%02d:%02d:%02d%c", in_str, hrs, min, 
		secs, frames, ctrl_m);
	    } else { 
		if (cmd_int > 1) 
		    sprintf(tell_str, "%s %d%c", in_str, cmd_int, ctrl_m);
		else sprintf(tell_str, "%s%c", in_str, ctrl_m);
	    }
	} else 	    sprintf(tell_str, "%s%c", in_str, ctrl_m);

#ifdef VMS
	outrbl.rab$l_rbf = tell_str;
	outrbl.rab$w_rsz = strlen(tell_str);
	do_rms(SYS$PUT, &outrbl);
#else
	send_out(tell_str);
#endif
	*rep_str = 0;
	sleep(2);
#ifdef VMS
	do_rms(SYS$FLUSH, &outrbl);
#endif
/* now wait for the response */

#ifdef VMS
	while (wait) {	
	    inrbl.rab$w_rsz = 0;
	    rms_status = SYS$GET(&inrbl);
	    for (i=0; (i<WAIT_SECS) &&(!inrbl.rab$w_rsz); ++i) sleep(1);
	    if (!inrbl.rab$w_rsz) {
		fprintf(stderr, "timed out\n");
		break;
	    } 
	    else  if (*rep_str == '$') {
/*		fprintf(stderr, "end of reply\n"); */
		break; 
	    }
	    else if ( (rms_status != RMS$_NORMAL) &&
	    	(rms_status != RMS$_PENDING) ) {
		LIB$SIGNAL(rms_status);
		break;
	    }
	    else {
		rep_str[inrbl.rab$w_rsz] = 0;
/*		fprintf(stderr, "[%s]\n", rep_str); */
		if (!strncmp(good_reply, rep_str, strlen(good_reply)))
		    break;	/* O.K. */
		else if (!strncmp(bad_reply, rep_str, strlen(bad_reply)))
		    break;	/* not there ? */
		else if (!strncmp(ugly_reply, rep_str, strlen(ugly_reply)))
			break;	/* error ? */
		else if ((*rep_str >= '0') && (*rep_str <='9'))
		     /* O.K. */ break;
	    }
	}
#endif
	return(1);
}


/* close up */
dq_end()
{
char buf[20];
strcpy(buf, "standbyoff");
tell_diaquest(buf,0,0,0);  
#ifdef VMS
	if (inrbl.rab$w_rsz) do_rms(SYS$CLOSE, &infbl);
	do_rms(SYS$CLOSE, &outfbl);
#endif
	return(1);
}

/* this is called at startup to initialise function pointers */
void dq_ctrl(ctrl, opt)
int (*ctrl[])();	       /* [Delim_Size] controller functions, out only */
struct one_opt opt[];          /* [opt_size] command line options, in only */
{
	/* the controller delimiter functions */
	ctrl[(int) B_Mf] 	= dq_setup;
	ctrl[(int) E_Pic]	= dq_edit;
	ctrl[(int) E_Mf]	= dq_end;

	/* store the options pointer */
	popt = opt;

	deb = opt[(int) debug].set;	/* do we want to debug ? */
	if ( opt[(int) diaquest].set )
		strncpy(ctr_dev, opt[(int) diaquest].val.str, max_str);
	ctr_dev[max_str - 1] = '\0';	/* for safety */
	return;
}
/* UNIX I/O */
#ifndef VMS

void setuptty(thisfile)
FILE *thisfile;
/* This routine resets terminal characteristics appropriately */
{
	int retval= 0;

#ifdef SYSV
	struct termio argstruct;

	retval= ioctl(fileno(thisfile), TCGETA, &argstruct);
	if (retval != -1) {
		argstruct.c_cflag= B1200 | CLOCAL | CREAD | CS8 ;
                argstruct.c_lflag &= ~(ECHO | ECHOE | ECHOK | ECHONL);
		retval= ioctl(fileno(thisfile), TCSETA, &argstruct);
		};
#else
	struct sgttyb argstruct;

	retval= ioctl(fileno(thisfile), TIOCGETP, &argstruct);
	if (retval != -1) {
		argstruct.sg_ispeed= B1200;
		argstruct.sg_ospeed= B1200;
		ioctl(fileno(thisfile), TIOCSETP, &argstruct);
		}
#endif

	if (retval == -1) {
		fprintf(stderr,"Error setting terminal characteristics\n");
		exit(2);
		};
}


/* open the port */
open_port(port_name)
char *port_name;
{
        if (!(ofile=fopen(port_name,"w"))) {
	    fprintf(stderr, "couldn't open %s for output !\n", port_name);
	    return(0);
	}

        if (!(ifile=fopen(port_name,"r"))) {
	    fprintf(stderr, "couldn't open %s for input!\n", port_name);
	    return(0);
	}

	setuptty(ifile);
	setuptty(ofile);

	return(1);
}
/* send the string to the diaquest */
send_out(send_str)
char *send_str;
{
char inchar= 0;

	fprintf(stderr,"sending <%s>\n",send_str);

	fprintf(ofile,"%s",send_str);

	fprintf(stderr,"recieved <");
	while (inchar != '$') {
		inchar= fgetc(ifile);
		if (isprint(inchar)) putc(inchar,stderr);
		else fprintf(stderr,"\\%d",(int)inchar);
	}
	fprintf(stderr,">\n");

	return(1);
}

#endif

