 /*
  * Khoros: $Id: vgbox.h,v 1.2 1991/07/15 06:04:26 khoros Exp $
  */

 /*
  * $Log: vgbox.h,v $
 * Revision 1.2  1991/07/15  06:04:26  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgbox.h
 >>>>            Author: Jean-Pierre GUERIN  (CEA) 
 >>>> Date Last Updated: Fri Apr 12 09:17:58 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _vgbox_h_
#define _vgbox_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    vgbox Argument Structure
*
****************************************************************/

typedef struct _vgbox  {

/*
 *  resulting output image (Required outfile)
 */
char	*o_file;	/* resulting output image FILENAME */
int	 o_flag;	/* resulting output image FLAG */

/*
 *  Number of Rows    (Height in pixels) of the CCD sensor (Optional integer)
 */
int	 r_int; 	/* Number of Rows    (Height in pixels) of the CCD sensor INT */
int	 r_flag;	/* Number of Rows    (Height in pixels) of the CCD sensor FLAG */

/*
 *  Number of Columns (Width  in pixels) of the CCD sensor (Optional integer)
 */
int	 c_int; 	/* Number of Columns (Width  in pixels) of the CCD sensor INT */
int	 c_flag;	/* Number of Columns (Width  in pixels) of the CCD sensor FLAG */

/*
 *  Pixel (vertical)   Height (Optional float)
 */
float	 px_h_float;	/* Pixel (vertical)   Height FLOAT */
int	 px_h_flag;   	/* Pixel (vertical)   Height FLAG */

/*
 *  Pixel (horizontal) Width (Optional float)
 */
float	 px_w_float;	/* Pixel (horizontal) Width FLOAT */
int	 px_w_flag;   	/* Pixel (horizontal) Width FLAG */

/*
 *  Pixel offset from the top  of the CCD grid (Optional float)
 */
float	 px_y_off_float;	/* Pixel offset from the top  of the CCD grid FLOAT */
int	 px_y_off_flag;   	/* Pixel offset from the top  of the CCD grid FLAG */

/*
 *  Pixel offset from the left of the CCD grid (Optional float)
 */
float	 px_x_off_float;	/* Pixel offset from the left of the CCD grid FLOAT */
int	 px_x_off_flag;   	/* Pixel offset from the left of the CCD grid FLAG */

/*
 *  Height of the rectangular box (Optional float)
 */
float	 h_float;	/* Height of the rectangular box FLOAT */
int	 h_flag;   	/* Height of the rectangular box FLAG */

/*
 *  Width  of the rectangular box (Optional float)
 */
float	 w_float;	/* Width  of the rectangular box FLOAT */
int	 w_flag;   	/* Width  of the rectangular box FLAG */

/*
 *  Downward offset of the box (0 is CCD center = box center) (Optional float)
 */
float	 im_y_off_float;	/* Downward offset of the box (0 is CCD center = box center) FLOAT */
int	 im_y_off_flag;   	/* Downward offset of the box (0 is CCD center = box center) FLAG */

/*
 *  Right  offset of the box (0 is CCD center = box center) (Optional float)
 */
float	 im_x_off_float;	/* Right  offset of the box (0 is CCD center = box center) FLOAT */
int	 im_x_off_flag;   	/* Right  offset of the box (0 is CCD center = box center) FLAG */

/*
 *  Box rotation (clockwise, degres) (center = box center) (Optional float)
 */
float	 angle_float;	/* Box rotation (clockwise, degres) (center = box center) FLOAT */
int	 angle_flag;   	/* Box rotation (clockwise, degres) (center = box center) FLAG */

/*
 *  Grey level of the background pixels outside of the box (Optional integer)
 */
int	 g_o_int; 	/* Grey level of the background pixels outside of the box INT */
int	 g_o_flag;	/* Grey level of the background pixels outside of the box FLAG */

/*
 *  Grey level of pixels inside the box (Optional integer)
 */
int	 g_i_int; 	/* Grey level of pixels inside the box INT */
int	 g_i_flag;	/* Grey level of pixels inside the box FLAG */

}  vgbox_struct;

vgbox_struct *vgbox;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/* -include_macros_end */

#endif
