#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Clip (X, Y, N, K, XC, YC, NC)


*************************************************************
*                                                           *
*  Subroutine Continuous_Curve_Clipping                     *
*                                                           *
*    This routine is used to clip the object stored in      *
*    the X & Y array, according to the described window.    *
*    The clipped object is then passed back in the XC &     *
*    YC array.                                              *
*                                                           *
*    The algorithm used is known as the Cohen-Sutherland    *
*    Algorithm. The routine uses a set of bit flags to      *
*    tell if a point is above, below, to the right, or      *
*    to the left of the window. With the following bit      *
*    positioning:                                           *
*                                                           *
*                            1000                           *
*                     -------------------                   *
*                     |  Window:        |                   *
*                     |                 |                   *
*              0001   |      0000       |  0010             *
*                     |                 |                   *
*                     |                 |                   *
*                     -------------------                   *
*                            0100                           *
*                                                           *
*    The routine uses a loop to evaluate and clip each      *
*    set of points, as well as an inner while loop to       *
*    keep clipping the points until they both reside        *
*    inside the window. The points are then stored in       *
*    the XC & YC array. If neither point resides or         *
*    vectors through the window, they are ignored (not      *
*    stored into the graphing arrays).                      *
*                                                           *
*************************************************************


        Integer         max, num, maxC
        Common /Object/ max, num, maxC
        Save   /Object/

        Real            WXmax, WXmin, WYmax, WYmin
        Common /windw/  WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Real    X(max,num), Y(max,num), XC(maxC,num), YC(maxC,num)
        Integer N, K, NC, outcd1, outcd2, tempI
        Logical accept, done, andzro

        Real    tempR, X1, Y1, X2, Y2
        Integer I

*       (* Initialize the number of clipped points to zero. *)
        NC = 0

*       (* Use a loop to evaluate and clip each set of points 
*          or lines. *)
        DO 100 I = 1, N-1
 
*         (* Assign points 1 & 2 for evaluation. *)
          X1 = X(I,K)
          Y1 = Y(I,K)
          X2 = X(I+1,K)
          Y2 = Y(I+1,K)
 
*         (* Initialize done to false. *)
          done = .FALSE.
  200     IF (.NOT.(done)) THEN 

*           (* Compute the outcds for points 1 & 2, (P1 & P2).
*              This gives the configuration for each point, telling
*              us where the point is located with respect to the
*              window. *)
            Call compte(X1, Y1, outcd1)
            Call compte(X2, Y2, outcd2)

*           (* Check to see if both points are outside the window.
*              If neither point lies within the window then we get
*              the next set of points and try again. *)
            IF (.NOT.(andzro(outcd1, outcd2))) THEN
              accept = .FALSE.
              done = .TRUE.
            ELSE
*             (* If both points are within the window, then we are
*                finished. *)
              IF ((outcd1 .EQ. 0000) .AND. (outcd2 .EQ. 0000)) THEN
                accept = .TRUE.
                done = .TRUE.
              ELSE
*               (* If both points are within the window, then P2 can't
*                  be. Swap P1 with P2, and clip the new P1 until it
*                  is also inside the window. *)
                IF (outcd1 .EQ. 0000) THEN
*                 (* Swap X1 & X2 *)
                  tempR = X1
                  X1 = X2
                  X2 = tempR

*                 (* Swap Y1 & Y2 *)
                  tempR = Y1
                  Y1 = Y2
                  Y2 = tempR

*                 (* Swap outcd1 & outcd2. *)
                  tempI = outcd1
                  outcd1 = outcd2
                  outcd2 = tempI
                ENDIF

*               (* Computes P1's new position within the window.
*                  The algorithm continues until P1 and P2 are both
*                  inside the window. *)
                IF (outcd1 .GE. 1000) THEN
                  X1 = X1 + ((X1 - X2)/(Y1 - Y2))*(WYmax - Y1)
                  Y1 = WYmax
                ELSEIF (outcd1 .GE. 0100) THEN
                  X1 = X1 + ((X1 - X2)/(Y1 - Y2))*(WYmin - Y1)
                  Y1 = WYmin
                ELSEIF (outcd1 .GE. 0010) THEN
                  Y1 = Y1 + ((Y1 - Y2)/(X1 - X2))*(WXmax - X1)
                  X1 = WXmax
                ELSEIF (outcd1 .GE. 0001) THEN
                  Y1 = Y1 + ((Y1 - Y2)/(X1 - X2))*(WXmin - X1)
                  X1 = WXmin
                ENDIF
              ENDIF
            ENDIF

*         (* Check to see if we are done. *)
          GOTO 200
          ENDIF

*         (* If the points are inside the window, then store P1 & P2
*            in the 'clipped' arrays, XC & YC. P1 & P2 are stored as 
*            line segments. The lines are no longer a series of con-
*            nected lines, but rather a series of line segments, that 
*            may or may not be connected. *)
          IF (accept) THEN
            XC(NC+1,K) = X1
            YC(NC+1,K) = Y1
            XC(NC +2,K) = X2
            YC(NC +2,K) = Y2
            NC = NC +2
          ENDIF

  100   CONTINUE

        RETURN
        END
