import "story/ending"

function trial2()
	clearText()
	image("courtroom", "cover")
	text [[At that moment Milpreve returns to the courtroom, seemingly no less furious than he left.]]

	text [["Return to your allotted places, all of you! Order!" He takes up position behind the lectern. "I have consulted the appropriate records, and we shall now bring this farce to a swift resolution. The counsel for the defence may withdraw his objection." He looks at Leofwine expectantly.]]

	image "vultures"

	text [[Leofwine coughs. "I'm not quite sure of your meaning."]]

	image "milpreve"

	text [["The questions," says Milpreve icily, "have already been presented once to the defendant. That being the case, *if* I were to ask the same set of questions again, the defendant would no longer be in a position of ignorance, and then *Tregaskis v Penhaligon* would have no bearing on the proceedings. Therefore, I will ask them again. I trust the defence has no further interventions to make?"]]

	image("courtroom", "cover")

	text [[Leofwine looks at you helplessly.]]

	choice([["Don't worry. I think I have a better chance this time."]], "trial2_hub")
end

function trial2_hub()
	if not visited("trial2_hub") then
		text [[Leofwine opens his beak to say something, then doesn't. He turns instead to Milpreve. "The defence has no objections."]]
	end

	choice([["I would like to prove my knowledge of Philosophy."]], "trial2_philosophy")
end

function trial2_philosophy()
	image "milpreve"
	text [["Correct. Now, $(playerTitle) $(playerLastName)," Milpreve picks up the paper from the top of the pile and stares at it very hard. "Question one."]]

	text [[He is silent for a moment.]]

	text [["The first question."]]

	text [[Milpreve looks at you, then at the paper again. Then he looks at the vultures, then the paper, then the statue, then you, and finally:]]

	text [["The *Opus* of Izinth describes a procedure by which the sage may impart *animus* to an imago having no more than sixteen points of articulation, using the thaumatic instruments devised at Mestra. What are the three signa that must be inscribed at the fulcrum before the iteria is inset into the naos?"]]

	choice([["Milkvetch root, feverfew leaf and selfheal foliage, given as soon as possible after onset of sore throat."]], "trial2_milkvetch")
end

function trial2_milkvetch()
	text [[Milpreve taps on the desk absently.]]

	text [["The vital processes of disjoint genera may be made congruent by the use of certain invigorated unguents, described in detail by Vala of Ithiu, whose application must be performed under *what* type of theriogenic field?"]]

	choice([["The sleeping-poppy, also known as the blueleaf, baker's rose or crying-mother."]], "trial2_poppy")
end

function trial2_poppy()
	text [[Milpreve's tapping becomes more agitated. He sets the paper down for a second, makes an unusual respiratory sound, and then picks it up again.]]

	text [["At the twentieth hour of Midsummer, from the Grand Observatory of Gallos, the visible constellations, in accordance with the celestial schemata of the Chyrian school, are the Huntress, the Vizier, the Ox-Cart, and what other?"]]

	choice([["Dandelion is popularly thought unsafe for young children but is no longer believed to cause bedwetting."]], "trial2_dandelion")
end

function trial2_dandelion()
	image "milpreve"

	text [[Milpreve does not make a sound. His tongue flicks out, then in. He sets the piece of paper down again, and squints at it.]]

	text [["Ah," he says.]]

	text [[There is a long silence.]]

	text [[You do not know how long it is before Leofric, evidently bored, clears his throat.]]

	text [["Can you truly find no kind of transgression, Remembrancer?" he asked. "No importune term of address or inappropriate comportment?"]]

	text [["Leofric," Milpreve says, "I need your eyesight." His tongue arcs over the answer paper, and dabs repeatedly against his scaled snout. "The ink tastes too wet.]]

	text [["Is this record accurate?"]]

	text [["Yes, of course!" Leofric pipes up. He is not even looking. "Down to the merest detail, all of your records are a completely verifiable and accurate *corpus* of what passes for truth in Gallos! To suggest otherwise would call into question the very underpinnings of our society and, indeed, the law itself!"]]

	text [[Milpreve's head whips from side to side as if trying to appraise biting distance.]]

	text [["The script in which this record is written seems different to usual, though I cannot with full certainty determine how."]]

	text [[With visible disdain, he addresses Hobson. "I call upon your *aesthetic sensibility*, Mr. Hobson, for an honest assessment of this handwriting."]]

	text [[He holds up the paper so Hobson may observe it.]]

	text [["Your handwriting is adorable, Milpreve," Hobson says, brightly. "Adder-orable! You should continue to write like that, it's far easier to read."]]

	text [[Milpreve hesitates for a long time.]]

	text [["The pun was superfluous to requirements," he decides, "but I have no choice but to believe the evidence. $(playerTitle) $(playerLastName) has demonstrated a thorough knowledge of philosophy, and as a citizen of Gallos she will have the opportunity to develop it even further."]]

	text [[His horned hand slams on top of the paper, crumples it up, and tosses the ball to the floor.]]

	text [["However, your good character - " and here, his nostrils flare - "has yet to be confirmed by a True Citizen. And your nominee, Hobson, has refused to make a statement in your favour…]]

	text [["So it appears that your hearing must come to an end here."]]

	text [[Leofwine's head jerks urgently in your direction.]]

	choice([["I would like to call upon Edmund Hobson one more time."]], "trial2_callHobson")
end

function trial2_callHobson()
	text [["His initial aborted testimony has been stricken from the record," Leofwine says, "and therefore can not be said by this court to have happened."]]

	choice([["I would like to call upon Edmund Hobson for the first time, then."]], "trial2_character")
end

function trial2_character()
	image "milpreve"

	text [[The bands of scales throb in Milpreve's neck.]]

	text [["The record is accurate," Milpreve utters. "Hobson, you must make a formal refusal so that the court may -"]]

	text [[But Hobson is already approaching the podium in an uncharacteristically coordinated fashion. Something is different now.]]

	image "hobson"

	text [["Ah, yes," Hobson announces, pounding both of his bony fists down on either side of the podium, "as I was saying before I was so rudely interrupted by myself…]]

	text [["The incomparable $(playerTitle) $(playerLastName) may well be the most deserving of True Citizenry of anybody I have met since the relocation. In terms of wit, nobility of spirit, and pursuit of art in the face of exhausting humiliations, I have no doubt that her anima is the closest to Her Serenity's that I have encountered in my osseous existence. So there!" He points at Milpreve. "What do you make of that, cock?"]]

	image "milpreve"

	text [["How dare you address me as if I were a fowl!"]]

	image "hobson"

	text [["But you are indeed foul – and it's fair, for you!" Hobson's head is rolling around so aggressively you fear the vertebrae may come off. "Fat lot of good is this Gallosian freedom, run by an overfed barn serpent abusing Her Serenity's rules to rap our knuckles with. And for what measure? A load of halls full of dust and creaking empsychons blabbing the same nonsense over and over while I play the same notes over and over.]]

	text [["Which is why I am now announcing my abandonment of my practices on The *Merrie Storm-Caller Of Penrood*, because it no longer accords with my creative direction. But don't worry, for I've determined to embark upon a new project - *Hobson's 1st Symphony!*"]]

	text [[Leofwine looks over at you, and wearily tucks his head under his wing.]]

	image "milpreve"

	text [["Hobson! If you insist on sickening the Citadel with your illicit lute playing -"]]

	image "hobson"

	text [["Ill, is it? Don't worry, it will be completely licit. I'm a fully licensed luthier and *you are complicit!*"]]

	text [[Hobson spreads open his lute licence, and displays it to the entire court. His obligate grin has a manic glint to it that you have not seen before.]]

	text [[Milpreve's fists pulse with muscle.]]

	image "milpreve"

	text [["You bony varlet! I will grind you into porcelain!"]]

	image "hobson"

	text [["But you wouldn't," Hobson says. "You couldn't, because it isn't written anywhere that you could. Unlike me… you lack *artistic licence!*"]]

	text [[Both Leofric and Leofwine groan into their wing feathers.]]

	image "milpreve"

	text [[Milpreve makes his way out from behind his desk. His lace-patterned mouth is partially open, displaying a pair of pink, whip-thin fangs longer than your forefinger. His eyes seem exceptionally rich and stark, in the manner of a pebble wettened to draw the colour out of it.]]

	text [[*"You will leave this courtroom. Now."*]]

	text [[Hobson whistles through his teeth, like a neophyte soldier trying not to laugh at his drill-master screaming in his face.]]

	text [[Milpreve's head snaps over to the shadows at the rim of the courtroom.]]

	text [[*"Scowles!! Remove him!!"*]]

	image "hobson"

	text [["Oh, take it easy, Milp', I'll ride out on Shanks's pony," Hobson says, with a nervous wave at Scowles. "I don't have anything else to say to the court, anyway.]]

	if luteCritKind then
		text [["But $(playerFirstName)! Thank you for the kind words about my playing. I'll carry them in my marrow."]]
	elseif luteCritConstructive then
		text [["But $(playerFirstName)! Thank you for the thoughtful words about how to improve my playing. I hope to make you proud."]]
	elseif luteCritMerciless then
		text [["But $(playerFirstName)! Thank you for the inspiring words about my playing that, when I attempt to recall them, make me feel strangely upset. I hope to become less muddled about your intentions in future."]]
	end

	text [[He steps down from the podium, takes his hat off, and claps it between his hands. Then he pushes open one half of the double doors.]]

	jump "trial2_hobsonLeft"
end

function trial2_hobsonLeft()
	image("courtroom", "cover")

	choice([[Notice Hobson, leaving without saying another word: "Good-bye, Hobson!"]], "trial2_annulled")
	choice([[Notice the vultures, emerging from under their wings in confusion: "Leofwine, whatever can I do now?!"]], "trial2_annulled")
	choice([[Notice Scowles, twisting towards the door in concern: "Scowles, help me make sense of this place."]], "trial2_annulled")
	choice([[Notice Milpreve, stricken in shock: "Remembrancer, I don't believe I had anything to do with what just happened."]], "trial2_annulled")
end

function trial2_annulled()
	image "milpreve"

	text [[Before you can say anything, Milpreve rounds on you, hissing in rage.]]

	text [["$(playerFirstName) $(playerLastName), your application for True Citizenship is denied!]]

	text [["This hearing is over. The court is dismissed!"]]

	image("courtroom", "cover")

	text [[Nobody moves.]]

	image "milpreve"

	text [[*"Get out, all of you!"*]]

	image "vultures"

	text [["It is most certainly *not* over!" cries Leofwine. "The aspirant has a right to a fair hearing, and has passed two of the three tests already! There is no legal basis for you to dismiss!"]]

	image "milpreve"

	text [[Milpreve fixes a gelid gaze on the demi-bird. "I alone have authorisation to direct the proceedings of this court, until such time as Her Serenity returns."]]

	image("courtroom", "cover")

	choice([["But Her Serenity won't return."]], "trial2_wtf")
end

function trial2_wtf()
	text [[For a moment you're not sure who said that, until you realise it was you.]]

	image "vultures"

	text [[Leofric turns to you. "And why? For what earthly reason could that be the case?"]]

	choice([["Because…the Queen is dead."]], "trial2_queensDeadLads")
end

function trial2_queensDeadLads()
	image "milpreve"

	text [[There is an uncomfortable silence, which Milpreve eventually breaks by thumping his stack of tomes and bellowing "Sedition! Take her from this place and return her to the cells immediately! Scowles!"]]

	image "vultures"

	text [["If I may, Remembrancer." There's a strange note in Leofwine's voice that you haven't heard before. "If the aspirant can *prove*, factually, the substance of her claim, then it cannot be considered seditious." He turns to you. "Can you do that?"]]

	text [[You nod.]]

	text [[Leofwine and Leofric look at each other - for once, they seem to be thinking as one.]]

	jump "trial2_queenquestintro"
end

function trial2_queenquestintro()

	clearText()
	image("courtroom", "cover")

	text [[The white stone of the Queen's statue watches the court as Milpreve kicks at a crumpled-up paper before setting himself back into place at his desk. He rearranges his books, closing his philosophy references, and laying out, in front of him, the manifesto by Gwenhaela Ros.]]

	text [[He does not open it; merely studies the hide-bound cover.]]

	text [[The vultures settle on the brass railing behind your head, and position themselves such that Leofric is at your left shoulder, and Leofwine at your right.]]

	text [["$(playerTitle) $(playerLastName)," Milpreve eventually begins, his voice low and measured, "you are being given room to establish the facts of your case. You may ask as many questions as you want freely.]]

	text [["When you are ready to state your proof, you should announce your intention to proceed."]]

	text [[His eyes lock onto yours, and do not move away.]]

	jump "trial2_queenQuestions"
end

function trial2_touristGuide()
	image "milpreve"

	if not touristGuide then
		touristGuide = true
		text [[Milpreve rummages around in his books, and eventually finds a cheerfully-printed folio labelled *A Visitor's Guide To Gallos*. He unfolds it, and studies it briefly.]]
	else
		text [[Milpreve runs his clawed finger along another section of the tourist's folio.]]
	end
end

function trial2_queenQuestions()
	image("courtroom", "cover")

	choice([["Er… who is the Queen, again?"]], "trial2_reminder")
	choice([["How was Gallos established?"]], "trial2_established")
	choice([["Remind me - why was Gallos relocated to the Undermarch?"]], "trial2_relocated")
	choice([["How long has it been since Her Serenity...went travelling?"]], "trial2_howLong")
	choice([["If the Queen really is dead, what happens?"]], "trial2_reallyDead")
	choice([["What power does Milpreve have?"]], "trial2_milprevePowers")
	choice([["I'm ready. I want to establish my argument." (Proceed.)]], "trial2_queenProofHub")
end

function trial2_reminder()
	image "vultures"

	text [[Over your shoulders, both birds groan in frustration.]]

	trial2_touristGuide()

	text [["Queen Gwenhaela Ros was a thaumaturge dissatisfied with restrictions imposed upon her by backward-looking polities.]]

	text [["She founded Gallos as a city-state of philosophers and artists, using her knowledge to elevate the minds of beasts and animate animate creatures of stone to act as labourers and functionaries.]]

	text [["Thus are the True Citizens of Gallos freed from the shackles of base drudgery to pursue their highest callings."]]

	jump "trial2_queenQuestions"
end

function trial2_established()
	trial2_touristGuide()

	text [["Gallos was supported by patrons. Construction was slow until a loan of seven thousand hundredweights was secured from the Archduke of Rescorla, which enticed further investment from financier guilds in Urbslanding and the Middens, making Her Serenity the first Rescorlan woman of common descent with a fortune of more than twenty thousand hundredweights in all.]]

	text [["This inspiring story of her wealth, and so early in her youth, spread quickly. Gallos became famous overseas, and a destination for visitors from all over Mundi, who travelled to the citadel to marvel at its splendours and partake of its intellectual freedoms."]]

	gallosPatronage = true

	jump "trial2_queenQuestions"
end

function trial2_relocated()
	image "milpreve"

	text [[Milpreve opens up a slim, black-bound volume crammed with his own writing.]]

	text [["The city was threatened by neighbouring kingdoms. The Prince-Bishop of Gethrick presented a demand that Gallos give up territory in return for military protection.]]

	text [["A few months later, Rescorla was invaded by the bloodthirsty Castrians."]]

	text [[You know from your history books that once there was an Archduke who ended a war by agreeing to marry a bloodthirsty Castrian princess, who ended up being so much more popular than him that everyone wanted to be a part of her culture instead, and that's why at Wintertide everyone hangs up yew knots and eats cabbage with sagebrush and cream.]]

	text [["The Archduke was out of funds. Instead of petitioning Her Serenity for aid, he distributed broadsides accusing Gallos of kidnapping babies and replacing them with therianological changelings.]]

	text [["With the Archduke's illiterate mobs assaulting Citizens, and Gethrick amassing bombe-trebuquets, Her Serenity concluded that the only way to protect the city would be to corporeally displace it; an army cannot march to the Undermarch."]]

	if gallosPatronage then
		choice([["Was she trying to skip paying back the investors?"]], "trial2_investors")
	else
		jump "trial2_queenQuestions"
	end
end

function trial2_investors()
	image "milpreve"

	text [[Milpreve seems appalled.]]

	text [["Gallos is a place of learning and refinement of the arts! It is a beacon of enlightenment in a desolate age!]]

	text [[Leofric coughs.]]

	image "vultures"

	text [["Her Serenity held that Gallos was never intended as a profit-making enterprise, but, unfortunately, not *all* of the city's patrons truly understood its purpose, and many were under the impression that investing in Gallos would bring them piles of gold, rather than the, uh, more indirect approach of cultural enrichment.]]

	text [["And then there was a lot of patronage that happened because the patrons assumed it must be a lucrative investment because there were so many other patrons, and so on and so forth. It is the way of finance that rational thinkers earn money from the irrational thinkers."]]

	text [[Leofwine shakes his head. "But it is the way of *politics* that rational thinkers give money to thinkers with bombe-trebuquets."]]

	jump "trial2_queenQuestions"
end

function trial2_howLong()
	image "vultures"

	text [[Leofric scoffs. "Ridiculous! You expect us to believe this absurd tale, and yet you yourself have no idea how long she's even been gone?"]]

	text [[Leofwine cuts in. "The prosecution must concede that even we cannot say with certainty how long it has been." He then addresses you: "'Time', of course, is something of a *debatable* concept in these regions."]]

	choice([["But it's been long enough for the Shrine to fall into ruin? Long enough for Hobson to die, become a skeleton, and forget everything?"]], "trial2_longEnough")
end

function trial2_longEnough()
	text [["Her Serenity has been *extremely* busy."]]

	text [[You realise from Leofric's tone that he already knows the truth. But it would be horrifying to admit it.]]

	jump "trial2_queenQuestions"
end

function trial2_reallyDead()
	image "vultures"

	if not visited "trial2_reallyDead" then
		text [[Leofwine bristles. "Are you asking in a *legal* sense or a *thaumatic* sense?"]]
	else
		text [["Is there something else you wish to know about that particular...hypothecated circumstance?"]]
	end

	choice([["Legally."]], "trial2_legally")
	choice([["Thaumatically."]], "trial2_thaumatically")
	choice([["I want to ask about something else."]], "trial2_queenQuestions")
end

function trial2_legally()
	image "vultures"

	text [["In the earliest days of Gallos, Her Serenity established an electoral system.]]

	text [["A senior functionary of the City must call a convocation of True Citizens to determine a successor, who will then rule as sovereign until death or abdication. In the event of serious illness or insanity which impairs the sovereign's capacity to rule, a similar convocation must be assembled to appoint a Regent until such time as a vacancy emerges."]]

	choice([["And there's no Regent at present?"]], "trial2_regent")
end

function trial2_regent()
	image "vultures"

	text [[You glance over briefly at Milpreve as you say this. He doesn't respond or seem to notice.]]

	text [[Leofric speaks instead. "*In the event* that something *had* happened to Her Serenity, a fact which has very much *not* been established, then a successor or Regent could only be appointed by a convocation. This has not occurred and therefore no such individual currently holds office."]]

	text [[You nod.]]

	text [[Leofwine adds: "By law, of course, both the convocation and the candidates for Regency must be from among the body of True Citizens. And therefore, until such time as the law is changed, *must be of the human species*."]]

	text [[You try to avoid looking at Milpreve again.]]

	jump "trial2_queenQuestions"
end

function trial2_thaumatically()
	image "vultures"

	text [[Leofric flaps. "Unfortunately this is an area outside of my expertise. Would you like to talk about jurisprudence instead?"]]

	image "milpreve"

	text [[With a theatrical movement, Milpreve lifts up a soft-bound white booklet called *Thaumaturgy For The Promising Student - Grade 1* and turns over only the first few pages.]]

	text [["*'When a sage calls an enchantment, it is like when your father makes a spark in his tinderbox'*," Milpreve reads, pitching his voice higher. "*'He does not need to do any more than bring about the conditions in which the flame can happen, and then may use it to light the fireplace. Exercise 1: Imagine that you killed your father. Would the fireplace go out?'*]]

	text [["One would think that this is redundant for someone with your level of knowledge, as proven by your passing of the philosophy test."]]

	choice([["But a fireplace eventually exhausts the wood. Why hasn't that happened?"]], "trial2_exhausted")
end

function trial2_exhausted()
	image "milpreve"

	text [["Overward, enchantments fade as the positions of astrological bodies, reagents, and planal phenomena change with the passage of time," Milpreve says. "But in the Undermarch, the passage of time takes a different course."]]

	jump "trial2_reallyDead"
end

function trial2_milprevePowers()
	image "vultures"

	text [["As Remembrancer, Milpreve is tasked with maintaining accurate ledgers of the city's many stores of goods, work duties to be performed, results of legal proceedings, and so on. As I'm sure you can imagine, a city this size requires an enormous effort of scription."]]

	choice([["So he doesn't *run* things exactly?"]], "trial2_runThings")
end

function trial2_runThings()
	image "milpreve"

	text [[Milpreve stirs. "This line of enquiry is not material to the question at hand."]]

	jump "trial2_queenQuestions"
end

function trial2_queenProofHub()
	image "vultures"

	if not visited("trial2_queenProofHub") then
		text [["Before we examine the truth of your claim, let us first establish what could have given rise to it. How did you come by the notion that Her Serenity might be indisposed?"]]
	end

	if not trial2scowlesGone then
		choice([["From something Scowles said."]], "trial2_scowlesSaid")
	end
	choice([["From something Hobson said."]], "trial2_hobsonSaid")
	choice([["From something the $(gargoyleName) said."]], "trial2_gargoyleSaid")
	choice([["From Milpreve."]], "trial2_milpreveSaid")
end

function trial2_scowlesSaid()
	image("courtroom", "cover")

	text [["When I met Scowles earlier, he told me that opening the Gatefold took the Queen's remaining life, and she would rest in the Shrine for eternity."]]

	image "vultures"

	text [["Characteristically gnomic of him, yes." Leofric flaps irritably. "If this is to be the basis of your argument, then we must bring this silly diversion to a swift closure. Scowles is known to frequently say things that are obscure, or figurative, or *flagrantly* portentous, and even if his pronouncements happen to be comprehensible they cannot rise to more than the level of hearsay.]]

	text [["Can you provide anything else to justify your suspicions?"]]

	jump "trial2_queenProofHub"
end

function trial2_hobsonSaid()
	image "vultures"

	text [[Leofric clacks his beak. "Hobson is, as you can see, no longer in attendance at this hearing, and will not be permitted to give further evidence. Anything he may or may not have said to you would not be considered admissible."]]

	jump "trial2_queenProofHub"
end

function trial2_gargoyleSaid()
	image "vultures"

	text [["The *$(gargoyleName)?*", Leofric splutters, unable to contain his incredulity.]]

	text [[Leofwine bobs his head laterally. "Are you…quite sure about this? The $(gargoyleName) is a galatological construct with only a very rudimentary *animus*. Perhaps one of the Great Sentinels might have said something to you? Or the Mourners? Did you speak to them?"]]

	choice([["No…I'm sorry. I must be mistaken."]], "trial2_queenProofHub")
end

function trial2_milpreveSaid()
	if not visited "trial2_milpreveSaid" then
		image "milpreve"

		text [[Milpreve jolts.]]

		text [["Absurdity upon absurdity. Nothing I have said or done could suggest these notions to a rational mind."]]

		image "vultures"

		text [["Of course. However." Leofric seems to be thinking. "If $(playerTitle) $(playerLastName) arrived at this impression as regards the current state of Her Serenity, then we should firmly establish the reason before we close this line of enquiry." He turns to you. "What did Milpreve say or do to support your theory?"]]
	end

	choiceOnce([["Milpreve left the room, to go and 'consult his books'."]], "trial2_consultBooks")
	choiceOnce([["Milpreve dropped a book in the Canal."]], "trial2_canal")
	choice([["Milpreve ordered that nobody touch the statue."]], "trial2_milpreveOrdered")
end

function trial2_consultBooks()
	text [["That doesn't seem particularly unusual. He is, after all, the keeper of the records. Surely his consulting them from time to time does not in itself arouse suspicion?"]]

	jump "trial2_milpreveSaid"
end

function trial2_canal()
	text [["Very unfortunate for him, but I fail to see what bearing this has on the case." Leofric looks at you skeptically.]]

	jump "trial2_milpreveSaid"
end

function trial2_milpreveOrdered()
	image "vultures"
	if not visited("trial2_milpreveOrdered") then
		text [["But of course," Leofric makes a sweeping gesture of the wing. "That was out of his deep reverence for Her Serenity."]]

		text [[Leofwine ignores him. "Why do you think he ordered that? Do you believe there is something about the statue he was attempting to conceal?"]]
	end

	choiceOnce([["Yes! The Statue is secretly animated, like the $(gargoyleName)!"]], "trial2_statueAnimated")
	choice([["Yes. The Statue is the Queen's resting place."]], "trial2_restingPlace")
	choiceOnce([["No. He was trying to protect the statue from being damaged."]], "trial2_statueProtect")
end

function trial2_statueAnimated()
	image "vultures"

	text [["This is nonsense." Milpreve is growing increasingly agitated. "You are making a farce of these proceedings."]]

	text [["I'm quite sure," says Leofwine hurriedly before Milpreve can continue, "that if the statue were galatologically enchanted, *someone* would have noticed by now. Besides, the question of its animation has no bearing whatsoever on the issue at hand."]]

	jump "trial2_milpreveOrdered"
end

function trial2_restingPlace()
	image "vultures"
	if not visited "trial2_restingPlace" then
		text [[Leofwine seems taken aback. "Are you *quite sure*? What could lead you to believe such a thing?"]]

		text [["The daylilies." As the words leave your mouth you feel a wave of calm pass over you; you picture how you look, standing here in the stuffy courtroom in the improbable city beyond the edge of nowhere, discussing a floral carving with a two-headed bird, watched over by a snake and a tree. A shame that the charming skeleton isn't here to witness your coup de grace, your victory over the forces of tedium and despair. Surely, you catch yourself thinking, this will finally secure your Citizenship.]]

		text [[The moment passes. The vultures' eyes bore into you as you frantically try to substantiate.]]

		text [["The…statue has a carved emblem of the Moon, encircled by a ring of daylilies. And the Moon is – well, Luna is a lot of things, obviously, but here it's most certainly the *anima*, and the daylilies, those are for death, that's what they are everywhere, even in Gethrick–"]]

		text [["The language of flowers, as intricate and fascinating as it may be, cannot be considered admissible in isolation; the court requires material evidence. By what means do you intend to prove, *beyond doubt*, that Her Serenity no longer walks among us?"]]
	end

	choice([["Open the compartment in the back of the statue."]], "trial2_openStatue")
	choiceOnce([["Check Milpreve's records."]], "trial2_checkRecords")
	choiceOnce([["Search the city thoroughly for any sign of her."]], "trial2_searchCity")
end

function trial2_openStatue()
	text [[You feel absolutely certain about this. "The emblem on the statue has a little door. It could be opened! There's sure to be an urn or… bones, or… something."]]

	text [[You're trying not to look in Milpreve's direction in case you antagonise him even more.]]

	text [["Any one of you taking a single step toward that statue you will be held in contempt. The defence will withdraw its objections."]]

	text [[Milpreve is standing now.]]

	text [["I have allowed this hearing to continue more than long enough."]]

	jump "trial2_breakdown"
end

function trial2_checkRecords()
	text [["Under no circumstances!" Milpreve has to stop himself from waving his arms. "The City records are the preserve of the Remembrancer alone. They may not simply be 'checked', at a whim, to substantiate some dim-witted aspirant notion!"]]

	text [[Leofwine bobs up and down a little. "Though a consultation of the records might, hypothetically, bring light to the matter, it would seem that the court is unlikely to grant the necessary approval. We must therefore confine ourselves to the materials currently accessible to us."]]

	jump "trial2_restingPlace"
end

function trial2_searchCity()
	text [["Her Serenity is *not* in Gallos, and has not been for, as best anyone in this court can estimate, quite some time. A search of the city would take considerable effort, considerable time, and almost certainly reveal nothing of value. Once again, I must ask you to provide *conclusive* evidence or withdraw this ludicrous assertion."]]

	jump "trial2_restingPlace"
end

function trial2_statueProtect()
	text [["And yet here we encounter a contradiction," Leowine intones thoughtfully. "Need I remind you that you earlier contended that nobody in the City was concerned with the state of the statue at all? Whence, then, this sudden concern for its condition on the part of the Remembrancer?"]]

	jump "trial2_milpreveOrdered"
end

function trial2_breakdown()
	image "milpreve"

	text [["Until now I have shown patience.]]
	text [["I have conducted these proceedings with utmost equanimity and in strict accordance with the law.""]]
	text [["And in this courtroom I have seen the most wanton disregard for the City's sacred traditions it is possible to imagine.]]

	text [["All these innumerable years I have maintained the institutions of Gallos as laid down by Her Serenity. Without constant adherence to its strictures, the city would crumble to *DUST!*"]]

	text [[He slams a fist down on the pile of documents in front of him, disturbing a cloud of dust.]]

	text [["And yet! At every turn, my efforts are resisted, undermined, blockaded, subverted, and mocked!]]

	text [["To impose order on such a mindless rabble is an impossible task!]]

	text [["The law is powerless before even its own appointed keepers, who squander the City's valuable time with preening and disputation even in the face of *UTTER RUIN!*]]

	text [["Even before a despicable, insolent wretch such as *Edmund Hobson*, the law has no power!]]

	text [["Why, *death itself* can put no stop to the man's interminable arrogance, his revolting tomfoolery, his wilful obstinacy! Too stubborn even to die properly!]]

	image("scowles", "cover")

	text [[You hear a rumbling from Scowles. "IS THIS WISE?"]]

	text [[Milpreve stares at the ceiling, seemingly unwilling to even look at the creature.]]

	image "milpreve"

	text [["Scowles talks of wisdom. Scowles! That...thing...that remains the most diabolical irregularity of all, *a fact of which there can be no record*.]]
	text [["How am I even to CATEGORISE such an aberration? 'Extratelluric Flora?' 'Ambulatory Rhizomes?' *'ONTOLOGICALLY DISTINCT PHENOMENA NOT OTHERWISE SPECIFIED?!'*" His voice is beginning to carry an unpleasant vibrato.]]

	text [["Enough! The court instructs that Scowles will return this aspirant to the cells immediately and for an indefinite period. She has no place in this City or among civilised people. *Her very presence here is an affront to the memory of Her Serenity!*"]]

	text [[Silence envelops the courtroom for several seconds, punctured eventually by a creaking from Scowles.]]

	image("scowles", "cover")

	text [["I DECLINE."]]

	image "milpreve"

	text [[Milpreve leaps from his seat, eyes blazing, reaching his hands towards you.]]

	image "vultures"

	text [[Before you can react his progress is interrupted by a shrieking agglomeration of feather and talon, twin beaks alternately berating and pecking at him.]]

	image("courtroom", "cover")

	text [[As he stumbles and flails at the birds, you:]]

	choice("Run.", "ending")
end
