procedure error(msg : desc_str);

begin
   gotoxy(ERROR_COL, ERROR_ROW);
   write(' ' : 27);
   gotoxy(ERROR_COL, ERROR_ROW);
   write(msg)
end; {error}


function make_room : room_pointer;

var new_room : room_pointer;
    count : integer;

begin
     new(new_room);
     new_room^.desc := '';
     for count := N to D do
        new_room^.dir[count] := 0;
     num_rooms := num_rooms + 1;
     new_room^.room_num := num_rooms;
     rooms[num_rooms] := new_room;
     make_room := new_room
end; {make_room}


procedure way_back(new_room : room_pointer; dir : integer);

var opp : array[N..D] of integer;

begin
   opp[N] := S;
   opp[S] := N;
   opp[E] := W;
   opp[W] := E;
   opp[NE] := SW;
   opp[NW] := SE;
   opp[SE] := NW;
   opp[SW] := NE;
   opp[U] := D;
   opp[D] := U;
   new_room^.dir[opp[dir]] := current_room^.room_num
end; {way_back}


procedure row_col_level(new_room, current_room : room_pointer; dir : integer);

begin
   new_room^.row := current_room^.row;
   new_room^.col := current_room^.col;
   new_room^.level := current_room^.level;
   case dir of
      N : new_room^.row := current_room^.row - 1;
      W : new_room^.col := current_room^.col - 1;
      S : new_room^.row := current_room^.row + 1;
      E : new_room^.col := current_room^.col + 1;
      NW : begin
              new_room^.row := current_room^.row - 1;
              new_room^.col := current_room^.col - 1
           end;
      SE : begin
              new_room^.row := current_room^.row + 1;
              new_room^.col := current_room^.col + 1
           end;
      NE : begin
              new_room^.col := current_room^.col + 1;
              new_room^.row := current_room^.row - 1
           end;
      SW : begin
              new_room^.row := current_room^.row + 1;
              new_room^.col := current_room^.col - 1
           end;
      U : new_room^.level := current_room^.level + 1;
      D : new_room^.level := current_room^.level - 1
   end
end; {row_col_level}


procedure make_new(dir : integer);

var new_room : room_pointer;

begin
   new_room := make_room;
   current_room^.dir[dir] := new_room^.room_num;
   row_col_level(new_room, current_room, dir);
   way_back(new_room, dir);
   current_room := new_room
end; {make_new}


function return(dir : integer; slash : boolean) : boolean;

begin
     if dir = DONT_KNOW then begin
        error('Type a direction first!');
        return := false
     end
     else begin
        if current_room^.dir[dir] = 0 then
           if slash then begin
              make_new(dir);
              return := true
           end
           else begin
              error('Use ''/'' to create new room');
              return := true
{           new_room := make_room;
           current_room^.dir[dir] := new_room^.room_num;
           row_col_level(new_room, current_room, dir);
           way_back(new_room, dir);
           current_room := new_room;
           return := true
}        end
        else begin
           current_room := rooms[current_room^.dir[dir]];
           return := true
        end
     end
end; {return}


procedure input_desc(var desc : desc_str);

var row, col, count : integer;
    left : array[0..3] of integer;
    ch : char;


   procedure move_word_up;

   begin
      gotoxy(INPUT_COL, INPUT_ROW + row - 1);
      write(' ' : 12);
      row := row - 1;
      col := 13;
      gotoxy(INPUT_COL + 12 - left[row], INPUT_ROW + row - 1);
      write(copy(desc, count - left[row], left[row]));
      left[row] := 0
   end; {move_word_up}


   procedure move_word_down(pos : integer);

   begin
      while desc[pos] <> ' ' do
         pos := pos - 1;
      gotoxy(INPUT_COL + col - (count - pos), INPUT_ROW + row - 1);
      write('' : count - pos - 1);
      left[row] := count - pos - 1;
      gotoxy(INPUT_COL, INPUT_ROW + row);
      col := left[row] + 1;
      write(copy(desc, count - left[row], left[row]));
      row := row + 1
   end; {move_word_down}


   procedure new_line;

   begin
      col := 0;
      row := row + 1;
      gotoxy(INPUT_COL, INPUT_ROW + row - 1)
   end;


begin {input_desc}
   if desc <> '' then
      erase_words;
   gotoxy(INPUT_COL, INPUT_ROW);
   read(kbd, ch);
   left[0] := -1;
   left[1] := 0;
   left[2] := 0;
   row := 1;
   col := 1;
   count := 1;
   while (ch <> ^M) and ((row < 3) or (col < 13)) do begin
      if ch = chr(127) then begin
         if count > 1 then begin
            count := count - 1;
            col := col - 1;
            write(chr(8), ' ', chr(8));
            if (col = 12) and (desc[count] = ' ') then
               count := count - 1;
            desc[0] := chr(count - 1);
            if (col - 1) <= left[row - 1] then
               move_word_up
         end
      end
      else begin
         desc[count] := ch;
         if col = 13 then
            if ch = ' ' then
               new_line
            else begin
               move_word_down(count);
               write(ch)
            end
         else
            write(ch);
         count := count + 1;
         col := col + 1;
         desc[0] := chr(count - 1)
      end;
      read(kbd, ch)
   end
end; {input_desc}


procedure comma;

begin
     input_desc(current_room^.desc);
     print_desc(current_room^.desc, 3, row[MIDDLE], col[MIDDLE]);
end; {comma}


procedure erase_misc;

begin
   gotoxy(MISC_COL, MISC_ROW);
   write('' : 27);
   gotoxy(MISC_COL, MISC_ROW + 1);
   write('' : 28);
   gotoxy(MISC_COL, MISC_ROW + 2);
   write('' : 28)
end; {erase_misc}

   
function right_room(a_room : room_pointer) : boolean;

var answer : char;
    save_current : room_pointer;

begin
     save_current := current_room;
     current_room := a_room;
     print_screen;
     current_room := save_current;
     gotoxy(MISC_COL, MISC_ROW);
     write('Is this the room you want? ');
     read(kbd, answer);
     erase_misc;
     right_room := (answer = 'Y') or (answer = 'y')
end; {right_room}


function find_room(desc : desc_str) : room_pointer;

var found_room : room_pointer;
    number, code : integer;


   function search_for_room(room_number : integer; desc : desc_str)
                            : room_pointer;

   var room_q : que;
       count : integer;
       found : boolean;
       room_in : room_pointer;


      function compare_desc(desc1, desc2 : desc_str) : boolean;

      var count : integer;
          found : boolean;

      begin
         count := 1;
         found := (length(desc1) <= length(desc2));
         while (count <= length(desc1)) and (count <= length(desc2)) and found
               do begin
            if upcase(desc1[count]) <> upcase(desc2[count]) then
               found := false;
            count := count + 1
         end;
         compare_desc := found
      end; {compare_desc}


   begin {search_for_room}
        found := false;
        count := 1;
        while not found and (count <= num_rooms) do begin
           room_in := rooms[count];
           if room_number = 0 then begin
              if compare_desc(desc, room_in^.desc) then begin
                 if right_room(room_in) then
                    found := true;
              end
           end
           else
              if room_number = room_in^.room_num then begin
                 if right_room(room_in) then
                    found := true;
              end;
          count := count + 1
        end; {while}
        if found then
           search_for_room := room_in
        else
           search_for_room := nil
   end; {search_for_room}


begin {find_room}
     val(desc, number, code);
     if code <> 0 then
        number := 0;
     found_room := search_for_room(number, desc);
     if found_room = nil then begin
        error('Room not found!     ')
     end;
     find_room := found_room
end; {find_room}


function get_file : boolean;

var new_file : line_str;

begin
   gotoxy(MISC_COL, MISC_ROW);
   write('File name, <RETURN> for ');
   gotoxy(MISC_COL, MISC_ROW + 1);
   write(file_name, ' or X to abort');
   gotoxy(MISC_COL, MISC_ROW + 2);
   write(': ');
   readln(new_file);
   erase_misc;
   if new_file <> '' then
      file_name := new_file;
   get_file := not ((new_file[1] = 'x') or (new_file[1] = 'X'))
end; {get_file}


procedure output_map(room_in : room_pointer);

var outfile : file of room;
    count : integer;
    OK, cont : boolean;

begin {output_map}
   repeat
      cont := get_file;
      if cont then begin
         assign(outfile, file_name);
         {$I-} rewrite(outfile); {$I+}
         OK := (IOresult = 0);
         if not OK then
            error('Write unsuccessful')
      end
   until OK or not cont;
   if cont then begin
      for count := 1 to num_rooms do
         write(outfile, rooms[count]^);
      close(outfile)
   end
end; {output_map}


procedure input_map;

var room_in : room_pointer;
    count : integer;
    infile : file of room;
    OK, cont : boolean;

begin
   repeat
      cont := get_file;
      if cont then begin
         assign(infile, file_name);
         {$I-} reset(infile); {$I+}
         OK := (IOresult = 0);
         if not OK then
            error('File not found')
      end
   until OK or not cont;
   if cont then begin
      count := 1;
      while not eof(infile) do begin
         new(rooms[count]);
         read(infile, rooms[count]^);
         count := count + 1
      end;
      num_rooms := count - 1;
      current_room := rooms[num_rooms]
   end
end; {input_map}


procedure move(dir : integer);

var new_room : room_pointer;
    desc : desc_str;

begin
     desc := current_room^.desc;
     input_desc(desc);
     new_room := find_room(desc);
     if new_room <> nil then begin
        if dir <> DONT_KNOW then begin
           current_room^.dir[dir] := new_room^.room_num;
           way_back(new_room, dir)
        end;
        current_room := new_room
     end
end; {move}


procedure delete(dir : integer);

begin
   if dir = DONT_KNOW then
      error('Type a direction first! ')
   else
      current_room^.dir[dir] := 0
end; {delete}


procedure dont_go(dir : integer);

var new_room : room_pointer;

begin
   if dir = DONT_KNOW then
      error('Type a direction first! ')
   else begin
      new_room := make_room;
      current_room^.dir[dir] := new_room^.room_num
   end
end; {dont_go}


procedure accept_input;

var dir : integer;
    desc : desc_str;
    ch : char;
    done : boolean;

begin
     if current_room^.desc = '' then begin
        input_desc(current_room^.desc);
        print_desc(current_room^.desc, 3, row[MIDDLE], col[MIDDLE]);
     end;
     dir := DONT_KNOW;
     done := false;
     repeat
        read(kbd, ch);
        case ch of
           ',' : comma;
           '.' : begin
                    move(dir);
                    done := true
                 end;
           '+' : begin
                    dont_go(dir);
                    done := true
                 end;
           '-' : begin
                    delete(dir);
                    done := true
                 end;
           '/' : done := return(dir, true);
           'n' : dir := N;
           's' : dir := S;
           'e' : case dir of
                    N : dir := NE;
                    S : dir := SE;
                 else
                    dir := E
                 end;
           'w' : case dir of
                    N : dir := NW;
                    S : dir := SW;
                 else
                    dir := W
                 end;
           'u' : dir := U;
           'd' : dir := D;
           'q' : begin
                    finish := true;
                    done := true
                 end;
           'i' : begin
                    input_map;
                    done := true
                 end;
           'o' : output_map(first_room);
           'p' : print_map
        else
           done := false
        end;
        if ch = chr(13) then
           done := return(dir, false);
     until done
end; {accept_input}


procedure cls;

begin
     clrscr;
{
     write(chr(ESC), ':', chr(ESC), '*');
}
end;


