bedroom: room
  sdesc = "Bedroom"
  ldesc = {
    if (!self.seen) {
      self.seen := true;
      dog.leaveCnt := 0;
      setdaemon(watsonCharliseDaemon,nil);                   // two turns before Watson leaves
    }
    "Inexplicable vegetable cravings aside, this room leaves you quite content for the moment. ";
    if (Me.location = comfyChair) {
      "You're curled up in what you and Kieron call 'the comfy chair'";
      if (intensity.isIn(Me))
        ", reading one of the Dean Koontz novels you missed in hardcover. Being 
        39 weeks pregnant, you've had ample time to catch up on your reading";
      ". ";
    }
    "\b Your bedroom is paneled with a kind of faux wooden interior, to kind of make it look like 
    the inside of a log cabin. To your left is your bed, and just beyond that is a dresser. ";
  }
  noexit = { 
    "You momentarily forget that your hallway is west, so you head that way instead. \b ";
    remdaemon(watsonCharliseDaemon, nil);
    Me.travelTo(hallway3);
  }
  west = {
    "You exit to the hallway. \b ";
    remdaemon(watsonCharliseDaemon, nil);
    return hallway3;
  }
  out = (self.west)
  genericHint = true
  listendesc = {
    if (dog.leaveCnt > 6)
      "Nothing now -- since the big crash, only Watson has made a sound.  ";
    else
      "Not much more than the puttering of Watson wandering around the house. ";
  }
;

fakeHallwayItem: fixeditem
  sdesc = "Hallway"
  noun = 'hallway' 'hall'
  location = bedroom
  ldesc = "The hallway leads toward the kitchen. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}    
  doBoard(actor) = { 
    if (Me.location = comfyChair)
      "You need to get up first. ";
    else
      endCharliseScene(); 
  } 
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the house. "
;

bedroomItem: fixeditem
  sdesc = "bedroom"
  noun = 'bedroom'
  ldesc = { bedroom.ldesc; }
  location = bedroom
  takedesc = "It's firmly attached to the rest of the house. "
;

comfyChair: chairitem
  sdesc = "comfy chair"
  noun = 'chair'
  adjective = 'comfy'
  ldesc = "Kieron had never seen the Monty Python sketch that made 'the Comfy Chair'a 
          household phrase amongst American and British teenagers worldwide. He collapsed 
          into fits of nigh painful laughter when you finally showed it to him. Since then, 
          the line 'Cardinal Fang! Fetch the so-and-so!' had become an in-joke between the two of you. "
  location = bedroom
  listendesc = { bedroom.listendesc; }
  reachable = { return(self.location.contents); }
  outOfPrep = "off of"
  statusPrep = {
    if (Me.location = self and self.sitting)
      "sitting on";
    else
      "on";
  }
  out = { self.doUnboard(Me); }

//<Okay, if the player is determined to get up, it should take three attempts to do so...> 
  count = 0     // number of times trying to get up
  down = { self.doUnboard(Me); }
  doUnboard(actor) = {
    switch (self.count++) {
      case 0:
        "Oof! You're not too sure about the feasibility of that. Maybe in a bit. ";
        break;
      case 1:
        "Ah, almost there. Trivial tasks have really become grand gestures lately for you. ";
        break;
      default:
        inherited.doUnboard(actor);
        break;
    }
  }
  doSynonym('Unboard') = 'Getdown' 'Jump'
  up = { self.doUnboard(Me); }
;

baby: item
  sdesc = "baby"
  noun = 'baby' 'pea'
  adjective = 'sweet'
  ldesc = "You can't really see it from here -- the angle is all wrong -- but you're
          aware that it's to be a little girl. "
  verDoDrop(actor) = { "What a concept!"; }
  touchdesc = { self.ldesc; }
  doSynonym('TalkTo') = 'SingTo'
  verDoTalkTo(actor) = {}
  doTalkTo(actor) = { 
    if (!self.sung) {
      self.sung := true;
      "You recall a few verses that you had been reading earlier before, some
      nonsense nursery rhymes, really:\b
      <i><q>He thought he saw an Elephant,\n
         That practised on a fife:\n
         He looked again, and found it was\n
         A letter from his wife. \n
         'At length I realise,' he said,\n
         'The bitterness of Life!'</q>\b
         <q>He thought he saw a Rattlesnake\n
         That questioned him in Greek:\n
         He looked again, and found it was\n
         The Middle of Next Week.\n
         'The one thing I regret,' he said,\n
         'Is that it cannot speak!'</q></i> ";
    }
    else
      "You whisper sweet sounds to the baby. ";
  }
;

intensity: item, readable
  sdesc = "<b>Intensity</b>"
  adesc = "the novel <b>Intensity</b>"
  noun = 'intensity' 'book' 'novel'
  ldesc = "It's _Intensity_ by Dean Koontz. Pretty good. Well, the last one you read was _Phantoms_, 
          so your palette had been cleansed somewhat, so to speak. Such a shame that poor Ben Affleck 
          got roped into doing that one, he would have done a much better job in the small-screen 
          adaptation of _Intensity_. Local Boston actors -- just can't catch a break. "
  readdesc = { self.ldesc; }
;

watsonCharliseDaemon: function(parm)
{
  local winOrLose;
  switch (dog.leaveCnt++) {
    case 2:    
      "\bWatson's ears perk up, and he leaves to the hallway. \b ";
      dog.moveInto(nil);
/* Commented out for now
// Read glf file to see if Kieron won or lost.      
      game.handle := fopen('pc1.glf', 'r');
      winOrLose := fread(game.handle);
      fclose(game.handle);
      if (winOrLose = 'W')
        "(Kieron won MJS)\n";
      else
         "(Kieron lost MJS)\n";
*/         
      "You feel the baby squirm about...\ and find yourself talking to her, for just a bit. \b";
      "<q>The first time he came home from work, after we got back from our honeymoon...\ he 
      was drenched in sweat after having beaten some kid ten years younger than him in basketball. 
      The kid eventually signed with one of the larger branches, No Limit, or something like that. 
      Kieron came in with that sad, exhausted look on his face...\ I think he knew at that point
      that he wasn't going to sign him. I was fussing over this one painting -- trying to get 
      colored lighting for it, before the paint congealed -- and he dropped his briefcase on the 
      floor and said 'I think one of us needs a hug.' I turned, looked over toward him, somewhat 
      slightly confused. After a beat he said, 'It's not you is it? Ah, ah right...\ must be *me* then.'</q>\b
      <q>And that's how it began, married life. You never really prepare yourself for that moment. 
      You can read all the articles you want on the subject, but you don't know...\ when that critical 
      moment comes... if you'll be looking at the rest of your life with someone who is really just a 
      stranger. Or someone who will remain just as fresh, funny, and driven as the day you met him.</q>\b
      <q>I took the next day. To commence with the props, I mean. And we've traded off and on like 
      that ever since. And on those days where he utterly failed to get a signature on a deal he was 
      assured was a 'lock' and on those days when my greens and oranges have turned to blue and red, 
      we've sounded off to each other, individually and in concert. And I hope, sure, that one day 
      you'll feel this -- get this -- as well, Sweet Pea.</q> ";
      break;
    case 4:
      "\bWatson starts barking. ";
      break;
    case 5:
      "\bWatson continues barking, most likely to be let out. ";
      break;
    case 6:
      "\bYou hear a crash -- it sounds like one of the windows in your living room!\b
      You can hear Watson barking. ";
      break;
    default:
      if (dog.leaveCnt > 6) {  // if dog around
        if (rand(9) = rand(9)) 
          if (!dog.streaked) {
            dog.streaked := true;
            "\bWatson streaks into the room, cocks his head at you and then bolts out of the room. ";
          }
          else
            "\bWatson streaks into the room, cocks his head at you, barks, and then bolts again. ";
      }
      break;
  }
}

bedCharlise: fixeditem
  sdesc = "bed"
  noun = 'bed'
  adjective = 'queen-size' 'queen'
  location = bedroom
  ldesc = "It's a queen-sized bed with a nice oak headstand to it. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  verDoBoard(actor) = { 
    "You weigh the pros and cons of this decision and decide against it,
    as the bed is just too high up to tackle right now. ";
    if (dog.leaveCnt > 6)
      "Especially since Watson probably knocked something over and needs to be let outside. "; 
  }
;

headstand: fixeditem
  sdesc = "headstand"
  noun = 'headstand'
  location = bedCharlise
  ldesc = "Books such as _The Art of the Deal_, _Mel Kiper Jr's Collegiate Draft Compendium_ 
          and _Field of Schemes_ on one side, resources for 16th-Century Renaissance and 
          Italian Art on the other. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached. "
;

books: decoration
  sdesc = "various books"
  noun = 'books'
  adjective = 'various'
  location = headstand
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
  isThem = true
;

dresser: fixeditem
  sdesc = "dresser"
  noun = 'dresser'
  location = bedroom
  ldesc = "The <<self.sdesc>> complements the other furniture nicely. "
  takedesc = "The <<self.sdesc>> <<self.isdesc>> is far too heavy. "
  verDoOpen(actor) = { "You're preoccupied with food for the moment and decide to not go looking
                       through your dresser. "; }
  verDoLookin(actor) = { self.verDoOpen(actor); }                      
;

furniture: decoration
  sdesc = "furniture"
  noun = 'furniture'
  location = bedroom
  ldesc = "The <<self.sdesc>> <<self.isntdesc>> important. "
;

hallway3: room
  sdesc = "Hallway"
  ldesc = "The hallway leads to your kitchen, and beyond that, the room where the crash came from. "
  noexit = { endCharliseScene(); }
  east = bedroom
  inHouse = true
;

fakeKitchenItem: fixeditem
  sdesc = "Kitchen"
  noun = 'kitchen'
  location = hallway3
  ldesc = "The <<self.sdesc>> is to the north. "
  verDoEnter(actor) = { self.verDoBoard(actor); }
  doEnter(actor) = { self.doBoard(actor); }
  verDoBoard(actor) = {}    
  doBoard(actor) = { endCharliseScene(); } 
  takedesc = "The <<self.sdesc>> <<self.isdesc>> firmly attached to the house. "
;

endCharliseScene: function
{
  "You've never really gotten used to locomotion at this weight...\ you enter the kitchen, 
  and slip upon something, a spill of some kind...\b
  You hit your head on the counter on your way down...\b ";
  morePrompt();
  "Shapes fade in and out of view...\ some time passes, but you have no idea how much...
  you vaguely remember Kieron coming home...\ hear passages of sound -- an ambulance, 
  sharp words at a hospital...\b
  And you awake to news you aren't prepared to hear.\n ";
  updateGameState('C');
  die();
}

