/*
    DAGEX.T
    This file contains only the pd_nodes of the sample
    program.  The #included files will supply the pd_node
    class referred to and the trivial items such as
    the rooms and the manipulable items that will
    appear in them.
*/

#include "plotdag.t"  //class definitions and includes
#include "dage1pla.t"  //places and items

//Set the pd_nodes...
pd_node1: pd_node
    noun = 'pd_node1'
    sdesc = "pd_node1"
    child = [pd_node2 pd_node3]
    child_conditions = [&cond1 &cond2]
    child_actions = [&act1 &act2]

    cond1 =
    {
        return(rubberball.location = Me and
                Me.location = corridor1);
        //Returns a boolean-style value of true or nil.
    }

    cond2 =
    {
        return(Me.location = cave1 and
                caveswitch.isActive = true);
    }

    act1 =
    {
        greencube.moveInto(Me.location);
        "\bThe rubber ball glows red for a moment and
        you hear a soft popping noise.  At your feet
        you see a small green cube.";
    }

    act2 =
    {
        note1.moveInto(Me.location);
        "\nYou hear a grinding sound and look up to
         see a small hole open in the cave ceiling.
         A small slip of paper floats down from it and
         lands on the gravel in front of you.";
    }
;

pd_node2: pd_node
    noun = 'pd_node2'
    sdesc = "pd_node2"
    child = [pd_node4]
    child_conditions = [&c1]
    child_actions = [&a1]

    c1 =
    {
        return(greencube.location = startroom);
    }

    a1 =
    {
        "\bOk - Green Cube is in Alcove!";
    }
;

pd_node3:pd_node
    noun = 'pd_node3'
    sdesc = "pd_node3"
    child = [pd_node4]
    child_conditions = [&c1]
    child_actions = [&a1]

    c1 =
    {
        return(note1.location = corridor1);
    }

    a1 =
    {
        "\bGOOD!  Note is in the corridor!";
    }
;

pd_node4:pd_node
    noun = 'pd_node4'
    sdesc = "pd_node4"
    child = [pd_node5]
    child_conditions = [&c1]
    child_actions = [&a1]

    c1 =
    {
        return(greencube.location = Me and
                note1.location = Me and
                rubberball.location = Me and
                Me.location = startroom);
    }

    a1 =
    {
        "\bYAY!";
    }
;

pd_node5:pd_node        //An impassible pd_node (dead end/win)
    noun = 'pd_node5'
    sdesc = "pd_node5"
    child = [pd_node5]
    child_conditions = [&c1]
    child_actions = [&a1]

    c1 =
    {
        return(true);    //ERROR!!
    }

    a1 = {}
;
