/* Copyright (c) 1999, 2000 by Kevin Forchione.  All Rights Reserved. */
/*
 *  TADS ADV.T/STD.T LIBRARY EXTENSION
 *  SCOPEDBG.T				
 *  version 1.0
 *
 *	    Scoping verbs for use in debugging, in conjunction with Scope.t.
 *
 *----------------------------------------------------------------------
 *  REQUIREMENTS
 *
 *      + HTML TADS 2.4.0 or later
 *      + Requires ADV.T and STD.T
 *      + Requires SCOPE.T 2.0 or later.
 *      + Should be #included after SCOPE.T.
 *
 *----------------------------------------------------------------------
 *  IMPORTANT LIBRARY INTERFACE AND MODIFICATION
 *
 *	    Note that any parameters set by these verbs apply only to the 
 *      debugging verbs and will NOT affect the scope of objects 
 *      otherwise.
 *
 *----------------------------------------------------------------------
 *  COPYRIGHT NOTICE
 *
 *  	You may modify and use this file in any way you want, provided that
 *		if you redistribute modified copies of this file in source form, the
 *   	copies must include the original copyright notice (including this
 *   	paragraph), and must be clearly marked as modified from the original
 *   	version.
 *
 *------------------------------------------------------------------------------
 *  REVISION HISTORY
 *
 *		14-May-99:	Creation.
 */
 
#define __SCOPEDBG_MODULE_
 
#ifndef __SCOPE_MODULE_
#error  THIS MODULE REQUIRES YOU TO HAVE #INCLUDE'D SCOPE.T
#endif

 
/* 
 *	scopeVerb: sysverb
 *
 *	This verb will produce alisting of the scope for the vantage.
 */
scopeVerb: sysverb
    sdesc = "scope"
    verb = 'scope'
    doAction = 'Scope'
    action( actor ) =
    {
        local scopelist := scope( parserGetMe(), limitVerb.limit,
            levelVerb.scopelevel );
        smartlist( scopelist, length( scopelist ) );
    }
    validDoList( actor ) = (nil)
    validDo( actor, obj, seqno ) = (true)
;

/*
 *	levelVerb: sysverb
 *
 *	Simple toggle that sets the scope level for the scope verb.
 */
levelVerb: sysverb
    sdesc = "level"
    verb = 'level'
	scopelevel = 2
    action( actor ) = 
    {
        self.scopelevel++;
        if (self.scopelevel > 3)
            self.scopelevel := 1;
        switch(self.scopelevel)
        {
            case 1:
                "[SCOPE_OBJTREE SET]\b";
                break;
            case 2:
                "[SCOPE_VISIBLE SET]\b";
                break;
            case 3:
                "[SCOPE_REACHABLE SET]\b";
                break;
        }
    }
;

/*
 *	limitVerb: sysverb
 *
 *	Allows the player to assign an object to ceiling limit. If no object is
 *	found for the player entry then ceiling limit is set to nil.
 */
limitVerb: sysverb
	sdesc = "limit"
    verb = 'limit'
    action(actor) =
    {
        "Enter a string>\ ";
        self.processString(actor, input());
    }
    silentMode = nil
    processString(actor, str) =
    {
        local toklist, typelist, objlist, nplist;
        local i;
        
        /* tokenize it */
        toklist := parserTokenize(str);

        /* get the type list */
        typelist := parserGetTokTypes(toklist);

        /* show the tokens and types */
        "Tokens:\n";
        for (i := 1 ; i <= length(toklist) ; ++i)
            "\t[<<i>>] = <<toklist[i]>> (<<typelist[i]>>)\n";

        /* look up objects */
        objlist := parserDictLookup(toklist, typelist);

        /* show the objects */
        "\bObjects:\n";
        for (i := 1 ; i <= length(objlist) ; ++i)
            "\t[<<i>>] = <<objlist[i].sdesc>>\n";

        /* build the nplist */
        nplist := [1 length(toklist)] + objlist;
        nplist := [nplist];

        /* invert "silent" mode */
        self.silentMode := !self.silentMode;
        if (self.silentMode)
            "(Silent Mode)\n";
        else
            "(Interactive Mode)\n";

        /* try disambiguation */
        objlist := parserResolveObjects(actor, askVerb, nil, nil,
                                        PRO_RESOLVE_DOBJ, &verIoAskAbout,
                                        toklist, nplist, self.silentMode);

        if (objlist[1] = PRSERR_DISAMBIG_RETRY)
        {
            "Got new command: <<objlist[2]>>
            \nExecuting the new command...\b";

            parserReplaceCommand(objlist[2]);
        }
        else if (objlist[1] != PRS_SUCCESS && objlist[1] != PRSERR_AMBIGUOUS)
        {
            "Error <<objlist[1]>> resolving objects\n";
        }
        else
        {
            "\bResolved Objects:\n";

            /* mention ambiguity if necessary */
            if (objlist[1] = PRSERR_AMBIGUOUS)
                "(Object list is still ambiguous)\n";
            
            /* show the objects */
            for (i := 2 ; i <= length(objlist) ; ++i)
                "\t[<<i>>] = <<objlist[i].sdesc>>\n";

            if (length(objlist) = 2)
            {
            	"Limit set to <<objlist[2].sdesc>> ";
            	self.limit := objlist[2];
            }
            else
            {
            	"Limit set to nil ";
            	self.limit := nil;
            }
        }
    }
    doAction = 'Limit'
;     

/*
 *	Modification of thing to include scoping debug verbs.
 */
modify thing
    verDoScope( actor ) = {}
    doScope( actor ) =
    {
        local scopelist;
    	"VANTAGE: "; self.sdesc;
    	"\nCEILING_LIMIT: "; 
    	if (limitVerb.limit)
    	    limitVerb.limit.sdesc;
    	else
    	    "nil";
    	"\nSCOPE_LEVEL: ";
        switch( levelVerb.scopelevel )
        {
        	case SCOPE_OBJTREE: 
        		"objtree ";
        		break;
        	case SCOPE_VISIBLE:
        		"visible ";
        		break;
        	case SCOPE_REACHABLE:
        		"reachable ";
        		break;
        }
    	"\nSCOPE: [";
        scopelist := scope( self, limitVerb.limit, 
            levelVerb.scopelevel );
        smartlist( scopelist, length( scopelist ));
        "]";
    }
;

modify strObj
    verDoLimit(actor) = { }
    doLimit(actor) = { limitVerb.processString(actor, self.value); }
;
