{
  Beispielprogramm fuer die Textopia-Toolbox
  Kapitel 8.1
}
PROGRAM demo8;
USES TSTRING,TIO,TMAIN;

CONST
  forest_id   = 10;
  sword_id    = 11;
  rucksack_id = 12;
  horse_id    = 13;
  hill_id     = 14;
  grave_id    = 15;
  chamber_id  = 16;
  cave_id     = 17;
  sarko_id    = 18;
  stone_id    = 19;
  bone_id     = 20;
  key_id      = 21;
  link1_id    = 22;
  link2_id    = 23;
  link3_id    = 24;
  link4_id    = 25;
  troll_id    = 26;

TYPE
  TnRoom = OBJECT(TRoom)
             FUNCTION  BeforeAction(event : TEvent) : BOOLEAN; VIRTUAL;
             PROCEDURE MyText; VIRTUAL;
           END;
  PnRoom = ^TnRoom;
  TnItem = OBJECT(TItem)
             PROCEDURE MyText; VIRTUAL;
             FUNCTION  BeforeAction(event : TEvent) : BOOLEAN; VIRTUAL;
             PROCEDURE RunDaemon; VIRTUAL;
           END;
  PnItem = ^TnItem;

VAR
  room   : PnROOM;
  item   : PnItem;
  lock   : PLock;
  link   : PLink;
  player : PPLAYER;
  game   : PGAME;

FUNCTION TnRoom.BeforeAction(event : TEvent) : BOOLEAN;
VAR
  ok : BOOLEAN;
BEGIN
  ok:=t;
  WITH event DO
  BEGIN
    CASE action OF
      go_ev : IF ToDir=down THEN
              BEGIN
                ok:=player^.GetContainer=NIL;
                IF NOT(ok) THEN
                   Print('Mit dem Pferd knnen Sie hier nicht hinein.\n');
              END ELSE IF (ToDir=northeast) AND
                          (PItem(Adr(troll_id))^.GetMatter=alive) THEN
                          BEGIN
                            Print('Sie spren kurz eine Klaue im Nacken, '+
                                  'dann wird es um Sie dunkel...\n');
                            player^.SetState(dead_ps);
                          END;
    END;
  END;
  BeforeAction:=ok;
END;

PROCEDURE TnRoom.MyText;
BEGIN
  CASE GetID OF
    hill_id : BEGIN
                Print('Ein kleiner Hgel erhebt sich in der Mitte einer'+
                      ' Lichtung ber das Grab eines Zwergenknigs. ');
                IF gate[down]^.lock^.GetState=closed THEN
                   Print('Ein steinernes Tor in der Nordseite versperrt'+
                         ' Ihnen den Weg ins Innere.\n')
                   ELSE Print('Das steinerne Tor in der Nordseite steht'+
                              ' offen. Dahinter fhrt eine Treppe in '+
                              'das Grab hinab.\n');
              END;
    cave_id : IF PItem(Adr(troll_id))^.GetMatter=alive THEN
              BEGIN
                Print('Als Sie die Hhle betreten springt Ihnen mit '+
                      'markerschtterndem Gebrll ein Troll entgegen!\n');
                PItem(Adr(troll_id))^.StartDaemon;
              END ELSE BEGIN
                         Print('Sie befinden sich in der kleinen Hhle im '+
                               'Sdwesten der Grabkammer. Diese Hhle '+
                               'wurde offensichtlich nicht von den Zwergen '+
                               'angelegt, als sie das Grab schufen. Die '+
                               'Wand der Grabkammer wurde fr die Hhle '+
                               'durchbrochen und die Wnde ');
                         Print('der Hhle sind mit scheulichen Symbolen '+
                               'bersht, die sich stark von den '+
                               'Schriftzeichen der Zwerge auf dem '+
                               'Sarkophag unterscheiden.\n');
                       END;
  END;
END;

PROCEDURE TnItem.RunDaemon;
BEGIN
  CASE RANDOM(3) OF
    0 : Print('Die furchtbaren Klauen des Trolls verfehlen Sie um '+
              'Haaresbreite.\n');
    1 : Print('Der Troll schlgt Ihnen beinahe das Schwert aus der '+
              'Hand.\n');
    2 : Print('Sie knnen grade noch dem Schlag des Trolls ausweichen.\n');
  END;
END;

PROCEDURE TnItem.MyText;
BEGIN
  CASE GetID OF
    sarko_id : BEGIN
                 Print('In der Ihnen unbekannten Zwergensprache ist ein '+
                       'Text in die Seiten des Sarkophags gemeielt. Die '+
                       'schwere Steinplatte, die den Sarkophag einmal '+
                       'verschlo, ist halb zur Seite geschoben. ');
                 IF Contains(Adr(bone_id)) THEN
                    Print('Im Sarkophag liegt ein einzelner Knochen.\n')
                    ELSE Print('Von dem Zwergenknig ist im Sarkophag '+
                               'nichts mehr zu entdecken.\n');
               END;

  END;
END;

FUNCTION TnItem.BeforeAction(event : TEvent) : BOOLEAN;
VAR
  ok : BOOLEAN;
BEGIN
  ok:=t;
  WITH event DO
  BEGIN
    IF who<>NIL THEN
    BEGIN
      ok:=f;
      Print('Der Troll denkt nicht daran, Ihre Befehle auszufhren.\n');
    END;
    CASE action OF
      tell_ev : BEGIN
                  ok:=f;
                  IF POS('zwerg',STRING(data^))>0 THEN
                     Print('Der Troll sagt: "Die Zwergenknochen sind mir '+
                           'ausgegangen, du kommst genau richtig..."\n')
                     ELSE Print('Der Troll leckt nur seine Zhne und '+
                                'schaut Sie mit einem sehr beunruhigenden '+
                                'Blick an.\n');
                END;
      kill_ev : BEGIN
                  ok:=f;
                  IF PItem(Adr(sword_id))^.GetLocation=NIL THEN
                  BEGIN
                    IF RANDOM(2)=0 THEN
                    BEGIN
                      SetMatter(dead);
                      ListMe(t);
                      StopDaemon;
                      Print('Mit einem schrecklichen Schrei stirbt der '+
                            'Troll, als Ihr Schwert ihn trifft. Als er zu '+
                            'Boden strzt, fllt ein Schlssel aus seinem '+
                            'Wams.\n');
                            PItem(Adr(key_id))^.MoveItemTo(Adr(cave_id));
                            player^.IncScores(5);
                    END ELSE Print('Sie haben noch nie ein Schwert in der '+
                                   'Hand gehabt, stimmts?\n');
                  END ELSE Print('Mit bloen Hnden??\n');
                END;
    END;
  END;
  BeforeAction:=ok;
END;

BEGIN
  Prepare('grab',t);
  {
    --- Wald ---
  }
  NEW(room,Init(forest_id,'+W%ald#er'));
  WITH room^ DO
  BEGIN
    AddText('Fast undurchdringliches Unterholz lt Sie nur mhsam '+
            'weiterkommen. Weiter westlich scheinen die Bume weniger '+
            'dicht beieinander zu stehen.\n');
  END;
  {
    --- Lichtung mit Eingang ---
    Variable Beschreibung erfolgt in der berladenen Methode TnRoom.MyText
  }
  NEW(room,Init(hill_id,'-Lichtung#en'));
  {
    --- Grabkammer ---
  }
  NEW(room,Init(grave_id,'-Grabkammer#n'));
  WITH room^ DO
  BEGIN
    AddText('In der Mitte der engen Grabkammer steht ein Sarkophag. In '+
            'der Ostwand befindet sich eine schwere, mit Eisen beschlagene '+
            'Eichentr. Im Sdwesten fhrt ein schmaler Gang weiter in '+
            'eine hinter der Grabkammer liegende Hhle.\n');
  END;
  {
    --- Schatzkammer ---
  }
  NEW(room,Init(chamber_id,'-Schatzkammer#n'));
  WITH room^ DO
  BEGIN
    AddText('In dieser Kammer lagerten die Grabbeigaben des Knigs.\n');
  END;
  {
    --- Versteck des Trolls ---
  }
  NEW(room,Init(cave_id,'-Hhle#n'));
  {
    --- Pferd ---
  }
  NEW(item,Init(horse_id,'Pferd#e',Adr(forest_id),t,1,10));
  WITH item^ DO
  BEGIN
    SetAttrib(enterable_at,t);
    SetAttrib(moveable_at,t);
    SetPraepos('auf');
  END;
  {
    --- Spieler ---
    Muss vor den Objekten definiert werden, die in seinem Inventar
    plaziert werden
  }
  NEW(player,Init(horse_id,sie,male,1,10));
  {
    --- Schwert ---
  }
  NEW(item,Init(sword_id,'Schwert#er',NIL,t,1,0));
  WITH item^ DO
  BEGIN
    SetAttrib(takeable_at,t);
    AddText('Das Schwert hat der Waffenschmied Ihnen kurz vor Ihrer '+
            'Abreise gegeben. Es schimmert und ist sehr scharf. Den '+
            'Schmied zu berreden, Ihnen das Schwert anzuschreiben, weil '+
            'Sie die ntigen Taler erst noch in den Grbern finden '+
            'mten, war nicht einfach.\n');
  END;
  {
    --- Rucksack ---
  }
  NEW(item,Init(rucksack_id,'+Rucks%ack#e',NIL,t,1,5));
  item^.SetAttrib(takeable_at,t);
  NEW(lock,Init(item,t,t,closed,NIL));
  {
    --- Sarkophag ---
  }
  NEW(item,Init(sarko_id,'+Sarkophag',Adr(grave_id),f,1,5));
  NEW(lock,Init(item,f,f,open,NIL));
  NEW(item,Init(stone_id,'-Steinplatte#n',Adr(grave_id),f,1,0));
  {
    --- Knochen ---
  }
  NEW(item,Init(bone_id,'+Knochen',Adr(sarko_id),t,1,0));
  WITH item^ DO
  BEGIN
    SetAttrib(takeable_at,t);
    AddText('Dies ist der einzige Knochen, der von dem hier bestatteten '+
            'Knig geblieben ist. Wenn Sie genau hinschauen, entdecken Sie '+
            'an dem Knochen tiefe Kratzer, die nur von sehr scharfen '+
            'Zhnen stammen knnen.\n');
  END;
  {
    --- Troll ---
  }
  NEW(item,Init(troll_id,'+Troll#e',Adr(cave_id),f,1,5));
  WITH item^ DO
  BEGIN
    SetMatter(alive);
    SetAttrib(talkable_at,t);
    AddText('Berichte ber Trolle mit ihren langen, scharfen Fangzhnen '+
            'und Klauen haben Sie bisher nur in Tavernen gehrt und nie '+
            'ernst genommen. Jetzt sollten Sie Ihre Meinung ndern.\n');
  END;
  {
    Schluessel fuer Eichentuer
  }
  NEW(item,Init(key_id,'+Schlssel',top,t,1,0));
  item^.SetAttrib(takeable_at,t);
  {
    --- Verbindungen und Tren zwischen Raeumen ---
  }
  NEW(link,Init(link1_id,'',forest_id,west,hill_id,f));
  NEW(link,Init(link2_id,'Tor',hill_id,down,grave_id,f));  { Tor und }
  NEW(lock,Init(link,t,t,closed,NIL));  { zugehoeriges Schloss }
  NEW(link,Init(link3_id,'-Eichentr#en;-Tr#en',grave_id,east,chamber_id,f));
  NEW(lock,Init(link,t,t,locked,Adr(key_id)));
  NEW(link,Init(link4_id,'',grave_id,southwest,cave_id,f));
  {
    --- Spiel ---
  }
  NEW(game,Init(t,f,t,4));
  WITH game^ DO
  BEGIN
    AddProlog('Das Zwergengrab\nEine Texttopia-Demo von Oliver Berse\n\n'+
              'Drei Tage schon durchstreifen Sie abseits der Straen den '+
              'alten Wald. Hier irgendwo liegen die mit Schtzen gefllten '+
              'Grber der Zwergenknige, die einst diese Lnder '+
              'beherrschten.\n\n');
    Run;
    Done;
  END;
END.