{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+}

{ This UNIT was originally written by Pasi Kettunen }
{ Little modifications by Kimmo Fredriksson.        }

UNIT Controls;


(****************************************************************************)
				 INTERFACE
(****************************************************************************)

CONST	Esc        = $01;	{ Scan codes of some keys }
	One        = $02;
	Two        = $03;
	Tre        = $04;
	Fou        = $05;
	Fiv        = $06;
	Six        = $07;
	Sev        = $08;
	Eig        = $09;
	Nin        = $0A;
	Zer        = $0B;
	Q          = $10;
	W          = $11;
	E          = $12;
	R          = $13;
	T          = $14;
	Y          = $15;
	U          = $16;
	I          = $17;
	O          = $18;
	P          = $19;
	ENTER      = $1C;
	CTRL       = $1D;
	A          = $1E;
	S          = $1F;
	D          = $20;
	F          = $21;
	G          = $22;
	H          = $23;
	J          = $24;
	K          = $25;
	L          = $26;
	LSHIFT     = $2A;
	Z          = $2C;
	X          = $2D;
	C          = $2E;
	V          = $2F;
	B          = $30;
	N          = $31;
	M          = $32;
	RSHIFT     = $36;
	ALT        = $38;
	Space      = $39;
	CsLock     = $3A;
	F1         = $3B;
	F2         = $3C;
	F3         = $3D;
	F4         = $3E;
	F5         = $3F;
	F6         = $40;
	F7         = $41;
	F8         = $42;
	F9         = $43;
	F10        = $44;
	Home       = $47;
	UpArrow    = $48;
	PgUp       = $49;
	Minus      = $4A;
	LeftArrow  = $4B;
	RightArrow = $4D;
	Plus       = $4E;
	EndK       = $4F;
	DownArrow  = $50;
	PgDn       = $51;
	Ins        = $52;
	Del        = $53;

VAR	Joystick : Boolean;
	JoyLeft  : Boolean;
	JoyRight : Boolean;
	JoyUp    : Boolean;
	JoyDown  : Boolean;

	JoyX     : Integer;
	JoyY     : Integer;

	KeyHitC  : Boolean;

	Key      : ARRAY[ 0 .. 127 ] OF Boolean;

	SaveExit : Pointer;

(****************************************************************************)

PROCEDURE InitKey;	   { set the new keyboard interrupt }
PROCEDURE InitNonBlankKey; { like InitKey, but try to disable VGASaves }
PROCEDURE DisabKey;	   { restore normal interrupt }
PROCEDURE WaitForKey( Scan : Byte );    { wait for key }
PROCEDURE DisableStick;                 { disable joystick }
FUNCTION  CenterStick( positions : Integer ) : Boolean;  { calibrate joystick }
PROCEDURE GetStick;
PROCEDURE ReadStick;
FUNCTION  Fire1 : Boolean;
FUNCTION  Fire2 : Boolean;

(****************************************************************************)
				IMPLEMENTATION
(****************************************************************************)

VAR	JoyResp : RECORD
		    CASE Integer OF
		      0 : ( xy   : LongInt );
		      1 : ( x, y : Integer )
		    END;

	CompY, CompX, JoyDiv : Integer;

	Int9H   	: Pointer Absolute $0000:$0024;
	SaveInt 	: Pointer;

	ind     	: Word;

(****************************************************************************)

FUNCTION  ReadJoy : LongInt; EXTERNAL;

PROCEDURE KeyInt; EXTERNAL;

{$L CONTROLS.OBJ}

PROCEDURE KeyIntNB; FAR; ASSEMBLER;
ASM
	PUSH	AX
	PUSH	DX

	MOV	DX,03C4h
	MOV	AL,01h
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	AND	AL,NOT 20h
	OUT	DX,AL

	POP	DX
	POP	AX

	PUSHF
	CALL	FAR [KeyInt]

	IRET
END;

PROCEDURE InitNonBlankKey;
BEGIN
  FillChar( Key, SizeOf( Key ), 0 );
  KeyHitC := FALSE;
  Int9H := @KeyIntNB
END;

PROCEDURE InitKey;
BEGIN
  FillChar( Key, SizeOf( Key ), 0 );
  KeyHitC := FALSE;
  Int9H := @KeyInt
END;

PROCEDURE DisabKey;
BEGIN
  Int9H := SaveInt
END;

PROCEDURE WaitForKey( Scan : Byte );
BEGIN
  WHILE NOT Key[ Scan ] DO;
  WHILE Key[ Scan ] DO;
END;

FUNCTION Fire1 : Boolean;
BEGIN
  Fire1 := ( Port[ $201 ] AND 32 ) = 0;
END;

FUNCTION Fire2 : Boolean;
BEGIN
  Fire2 := ( Port[ $201 ] AND 16 ) = 0;
END;

PROCEDURE DisableStick;
BEGIN
  Joystick := FALSE;
  JoyLeft := FALSE;
  JoyRight := FALSE;
  JoyDown := FALSE;
  JoyUp := FALSE;
END;

FUNCTION CenterStick( positions : Integer ) : Boolean;
BEGIN
  JoyResp.xy := ReadJoy;
  IF JoyResp.xy > 0 THEN
    BEGIN
      CompY := JoyResp.y;
      CompX := JoyResp.x;
      JoyStick := TRUE;
      JoyDiv := ( CompX + CompY ) DIV positions
    END
  ELSE
    DisableStick;
  CenterStick := JoyStick
END;

PROCEDURE GetStick;
VAR x, y : Integer;
BEGIN
  JoyResp.xy := ReadJoy;
  x := ( JoyResp.x - CompX ) DIV JoyDiv;
  y := ( JoyResp.y - CompY ) DIV JoyDiv;
  JoyRight := ( x > 0 );
  JoyLeft  := ( x < 0 );
  JoyDown  := ( y > 0 );
  JoyUp    := ( y < 0 )
END;

PROCEDURE ReadStick;
BEGIN
  JoyResp.xy := ReadJoy;
  JoyX := ( JoyResp.x - CompX ) DIV JoyDiv;
  JoyY := ( JoyResp.y - CompY ) DIV JoyDiv
END;

PROCEDURE SafeExit; FAR;
BEGIN
  ExitProc := SaveExit;
  DisabKey
END;

(****************************************************************************)
(*                              INITIALIZATION                              *)
(****************************************************************************)


BEGIN
  DisableStick;
  FillChar( Key, SizeOf( Key ), 0 );
  KeyHitC := FALSE;
  SaveInt := Int9H;
  SaveExit := ExitProc;
  ExitProc := @SafeExit;
END.
