
;----------------------------------------------------------------------------:
; Code to deal with .PCX and .PCC files on VGA								 :
;	SILVERMOON																 :
; (C) John Connors					1993									 :
;----------------------------------------------------------------------------:

	IDEAL
	MODEL	HUGE,C
	P286N
    
	INCLUDE "STRUCTS.INC"

	PUBLIC	decode_pcx_buffer
    
PCX_Header_Size EQU 128
PCX_CLUT_Size	EQU 256*3

;----------------------------------------------------------------------------:
;			CODE SEGMENT													 :
;----------------------------------------------------------------------------:


	CODESEG
    
;----------------------------------------------------------------------------:
; decode_pcx_buffer(char *dest,char *source)								 :
;																			 :
; Given that a .PCX file has been read into File_Segment, decode the binary  :
; image data into the 32-bit data segment at Screen_Buffer					 : 
;----------------------------------------------------------------------------:

PROC decode_pcx_buffer 
	ARG 	destination_buffer:DWORD,source_buffer:DWORD
    
	PUSH	DS
	PUSH	SI
	PUSH	DI
	    
	LDS 	SI,[source_buffer]					; set up File Segment source
	LES 	DI,[destination_buffer] 			; set up Screen buffer dest.
	XOR 	CX,CX								; clear counter
	MOV 	DX,[(PCX_Header PTR SI).X2] 		; DX = x dimension of picture
	SUB 	DX,[(PCX_Header PTR SI).X1]
	INC 	DX
	TEST	DX,1								; allow for deluxe paint quirk
	JZ		SHORT @@Not_Odd_Width
	INC 	DX
@@Not_Odd_Width:
	MOV 	AX,[(PCX_Header PTR SI).Y2] 		; AX = y dimesnion of picture
	SUB 	AX,[(PCX_Header PTR SI).Y1]
	INC 	AX
	MUL 	DX									; AX = DX * AX (size of image)
	MOV 	DX,AX
	ADD 	DX,DI								; DX = offset of last byte
	ADD 	SI,PCX_Header_Size					; point to start of data

Decode_Next_PCX_Byte:
	CMP 	DX,DI								; end of encoded data?
	JBE 	SHORT Decoded_PCX
	LODSB										; get next byte
	MOV 	AH,AL
	AND 	AH,11000000b						; is it a run ?
	CMP 	AH,11000000b
	JNZ 	SHORT @@Not_Compressed				; nope, branch
	MOV 	AH,AL
	AND 	AH,00111111b						; AH is run length
	LODSB										; AL is colour byte
	MOV 	CL,AH	 
	TEST	CL,00111111b						; run of zero ?
	JZ		SHORT Decode_Next_PCX_Byte			; yes, forget it
    
@@Decode_Run:
	STOSB
	LOOP	@@Decode_Run
	JMP 	SHORT Decode_Next_PCX_Byte

@@Not_Compressed:
	STOSB
	JMP 	SHORT Decode_Next_PCX_Byte 

Decoded_PCX:
	POP 	DI
	POP 	SI
	POP 	DS

	RET
ENDP	decode_pcx_buffer


	END
