/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import XMLConsumer.Idx;
import XMLConsumer.IdxEntry;
import XMLConsumer.Project;
import hhapplet.BsscFont;
import hhapplet.BsscFontFixPatch;
import hhapplet.BsscImageLabel;
import hhapplet.BsscImagePanel;
import hhapplet.IndexListView;
import hhapplet.IndexViewSkin;
import hhapplet.ResourceLib;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class IndexView
extends BsscImagePanel
implements Runnable,
TextListener,
ActionListener {
    private TextField m_tfEdit;
    private Button m_btnDisplay;
    private Vector m_vProjects;
    private Vector m_vIdx;
    private IndexListView m_list;
    int m_bResearch = 1;
    private Object m_Cursor = null;
    private LayoutManager m_layout;

    public IndexView(Vector vector, IndexViewSkin indexViewSkin) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        BsscFont bsscFont;
        this.m_vProjects = vector;
        this.m_tfEdit = new TextField();
        this.m_btnDisplay = new Button(ResourceLib.GetRes("Display"));
        BsscImagePanel bsscImagePanel = new BsscImagePanel();
        BsscImageLabel bsscImageLabel = new BsscImageLabel(ResourceLib.GetRes("IndexInputPrompt"));
        this.m_vIdx = new Vector();
        this.loadIdxInfo();
        this.m_list = new IndexListView(this.m_vIdx);
        Color color = indexViewSkin.getBgColor();
        if (color != null) {
            this.m_list.setBackground(color);
        } else {
            this.m_list.setBackground(Color.white);
        }
        Image image = indexViewSkin.getBgImage();
        if (image != null) {
            this.m_list.setBgImage(image);
        }
        if ((bsscFont = indexViewSkin.getNormalFont()) != null) {
            Color color2;
            object = bsscFont.getFont();
            serializable2 = this.getFontMetrics((Font)object);
            ((FontMetrics)serializable2).getHeight();
            this.m_list.setUnitHeight(((FontMetrics)serializable2).getHeight());
            serializable = bsscFont.getFont();
            if (serializable != null) {
                IdxEntry.setNormalFont((Font)serializable);
            }
            if ((color2 = bsscFont.getColor()) != null) {
                IdxEntry.setNormalColor(color2);
            }
            IdxEntry.setNormalUnderline(bsscFont.isUnderline());
        }
        if ((object = indexViewSkin.getHoverFont()) != null) {
            serializable2 = ((BsscFont)object).getFont();
            if (serializable2 != null) {
                IdxEntry.setHoverFont((Font)serializable2);
            }
            if ((serializable = ((BsscFont)object).getColor()) != null) {
                IdxEntry.setHoverColor(serializable);
            }
            IdxEntry.setHoverUnderline(((BsscFont)object).isUnderline());
        }
        IdxEntry.setActiveColor(indexViewSkin.getActiveColor());
        bsscImagePanel.setLayout(new BorderLayout(0, 0));
        bsscImagePanel.add("North", bsscImageLabel);
        bsscImagePanel.add("Center", this.m_tfEdit);
        ((Component)this.m_tfEdit).setBackground(Color.white);
        this.m_tfEdit.addTextListener(this);
        this.m_tfEdit.addActionListener(this);
        this.setLayout(new BorderLayout(2, 2));
        int n = BsscFontFixPatch.GetFontSize();
        ((Component)this.m_list).setFont(new Font(BsscFontFixPatch.GetFontName(), 0, n));
        this.m_tfEdit.setFont(new Font(BsscFontFixPatch.GetFontName(), 0, n));
        this.m_btnDisplay.setFont(new Font(BsscFontFixPatch.GetFontName(), 0, n));
        this.add("North", bsscImagePanel);
        this.add("Center", this.m_list);
        this.add("South", this.m_btnDisplay);
        this.m_btnDisplay.addActionListener(this);
        this.m_tfEdit.requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_tfEdit || actionEvent.getSource() == this.m_btnDisplay) {
            this.m_list.active();
        }
    }

    public Dimension getPreferredSize() {
        return this.getParent().getSize();
    }

    public void run() {
    }

    public void textValueChanged(TextEvent textEvent) {
        if (textEvent.getSource() == this.m_tfEdit) {
            String string = this.m_tfEdit.getText();
            this.m_list.findAndSelect(string);
        }
    }

    public void loadIdxInfo() {
        try {
            if (this.m_vProjects != null && this.m_vProjects.size() > 0) {
                String string = null;
                Enumeration enumeration = this.m_vProjects.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (!(e instanceof Project)) continue;
                    if (string == null) {
                        string = ((Project)e).getLangId();
                    } else if (!string.equals(((Project)e).getLangId())) continue;
                    Idx idx = ((Project)e).getIdx();
                    if (idx == null) continue;
                    idx.process();
                    this.m_vIdx.addElement(idx);
                }
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

