VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "HIME small VB demo"
   ClientHeight    =   5160
   ClientLeft      =   60
   ClientTop       =   348
   ClientWidth     =   8088
   LinkTopic       =   "Form1"
   ScaleHeight     =   5160
   ScaleWidth      =   8088
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton CalculateButt 
      Caption         =   "&Calculate"
      Height          =   375
      Left            =   5880
      TabIndex        =   11
      Top             =   3600
      Width           =   2055
   End
   Begin VB.TextBox BitLentxt 
      Height          =   285
      Left            =   5880
      TabIndex        =   9
      Text            =   "100"
      Top             =   840
      Width           =   855
   End
   Begin VB.CommandButton RandomDataButt 
      Caption         =   "Enter random data"
      Height          =   375
      Left            =   5880
      TabIndex        =   8
      Top             =   1200
      Width           =   2055
   End
   Begin VB.CommandButton ExitButt 
      Caption         =   "&Exit"
      Height          =   375
      Left            =   5880
      TabIndex        =   7
      Top             =   4560
      Width           =   2055
   End
   Begin VB.ComboBox OperationCmb 
      Height          =   315
      Left            =   5880
      TabIndex        =   6
      Top             =   2400
      Width           =   2055
   End
   Begin VB.TextBox Result 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.4
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   4
      Top             =   3600
      Width           =   5295
   End
   Begin VB.TextBox ParamB 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.4
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   2
      Top             =   1920
      Width           =   5295
   End
   Begin VB.TextBox ParamA 
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.4
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   975
      Left            =   240
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   600
      Width           =   5295
   End
   Begin VB.Label Label5 
      Caption         =   "Select operation"
      Height          =   255
      Left            =   5880
      TabIndex        =   12
      Top             =   2160
      Width           =   1935
   End
   Begin VB.Line Line2 
      X1              =   5760
      X2              =   8040
      Y1              =   1680
      Y2              =   1680
   End
   Begin VB.Line Line1 
      X1              =   5760
      X2              =   8040
      Y1              =   600
      Y2              =   600
   End
   Begin VB.Label Label4 
      Caption         =   "bits"
      Height          =   255
      Left            =   6840
      TabIndex        =   10
      Top             =   840
      Width           =   615
   End
   Begin VB.Label Label3 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Result"
      Height          =   255
      Left            =   240
      TabIndex        =   5
      Top             =   3360
      Width           =   2775
   End
   Begin VB.Label Label2 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Parameter 'b'"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   1680
      Width           =   2775
   End
   Begin VB.Label Label1 
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Parameter 'a'"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   360
      Width           =   2775
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Private Sub CalculateButt_Click()
    Dim s          As String
    Dim i          As Long
    Dim Plaintext  As String
    Dim Ciphertext As String
    Dim Passphrase As String
    
        'Get parameters from textboxes and store in HIME registers
    s = ParamA.Text         'Get text from parameter textbox
    i = HI_PUTREG(s, 1)     'Store it in a HIME register
    i = HI_DEC2HUGE(1, 1)   'Convert from ascii string to binary
    
    s = ParamB.Text         'Get text from parameter textbox
    i = HI_PUTREG(s, 2)     'Store it in a HIME register
    i = HI_DEC2HUGE(2, 2)   'Convert from ascii string to binary
    
    Select Case OperationCmb.Text
        Case "a + b"
            i = HI_ADD(1, 2, 9)
            
        Case "a - b"
            i = HI_SUB(1, 2, 9)
            
        Case "a * b"
            i = HI_MUL(1, 2, 9)
            
        Case "a / b"
            i = HI_DIV(1, 2, 9, 3)
            
        Case "a ^ b"
            i = HI_POW(1, 2, 9)
            
        Case "a mod b"
            i = HI_MOD(1, 2, 9)
            
        Case "AES encryption"
                 'Step 1: Encrypt some data ============================================
                    'Enter some plaintext
            a = "Enter a string (of any length) to encrypt"
            Plaintext = InputBox(a, , "")
            ParamA.Text = Plaintext  'Show plaintext in textbox
            
                    'Enter the passphrase
            a = "Enter a passphrase to encrypt the string"
            Passphrase = InputBox(a, , "")

                    'Calculate the SHA-256 hash value of the passphrase to
                    'use that as the key for AES encryption
            i = HI_PUTREG(Passphrase, 1)    'Store passphrase in register 1
            i = HI_HASH_SHA_256(1, 2)       'Hash register 1 --> 2
                                            'Register 2 now holds the AES key (32 bytes/256 bits)
            
                    'Store plaintext in register 3
            i = HI_PUTREG(Plaintext, 3)
            
                    'Use an empty string as IV (Initial Vector) and store in register 4
            i = HI_PUTREG("", 4)
            
                    'Encrypt plaintext
            i = HI_ENCRYPT_AES_CBC(3, 2, 4, 5)  'Ciphertext is in register 5
            If i = 1 Then
                    MsgBox ("AES key is NOT equal to 16, 24 or 32 bytes")
                    Exit Sub
            End If
            
            If i = 2 Then
                    MsgBox "IV is not empty and not equal to blocklength (16 bytes)"
                    Exit Sub
            End If
                  
                    'Show ciphertext in textbox
            ParamB.Text = HI_GETREG(5)
            
            'Step 2: Decrypt the data ============================================
                    'Enter the passphrase
            a = "Enter a passphrase to decrypt the string"
            Passphrase = InputBox$(a, , "")

                    'Calculate the SHA-256 hash value of the passphrase to
                    'use that as the key for AES encryption
            i = HI_PUTREG(Passphrase, 1)    'Store passphrase in register 1
            i = HI_HASH_SHA_256(1, 2)       'Hash register 1 --> 2
                                            'Register 2 now holds the AES key (32 bytes/256 bits)
                            
                    'Decrypt ciphertext in register 5
            i = HI_DECRYPT_AES_CBC(5, 2, 6) 'Register 6 contains the decrypted ciphertext. This should
                                            'equal the original plaintext
                                            
            If i = 1 Then
                    MsgBox "AES key is NOT equal to 16, 24 or 32 bytes"
                    Exit Sub
            End If
            
            If i = 2 Then
                    MsgBox "Ciphertext length is not a multiple of an AES block (16 bytes)"
                    Exit Sub
            End If

                    'Show decrypted ciphertext in textbox
            Result.Text = HI_GETREG(6)
            
            If HI_ISNOTEQUAL(3, 6) Then
                MsgBox "Decryption error: decrypted ciphertext does not equal original plaintext!"
            End If
            Exit Sub
        
        Case "SHA-256 hash value"
                    'Store Parameter A in register 1
            i = HI_PUTREG(ParamA.Text, 1)
            
                    'Calculate its hash value
            i = HI_HASH_SHA_256(1, 2)   'Register 2 contains hash value
            i = HI_REGREVERSE(2, 2)     'Reverse hashvalue because hi_Huge2Hex changes endian
            i = HI_HUGE2HEX(2, 3)       'Convert hash value to hex
            ParamB.Text = HI_GETREG(3)
            
            Exit Sub
        
        Case Else
            MsgBox "Unknown operation"
    End Select
    
        'Get result from register and display
    i = HI_HUGE2DEC(9, 9)    'Convert from binary to ascii string
    s = HI_GETREG(9)        'Get the contents from the register
    Result.Text = s
End Sub

Private Sub ExitButt_Click()
    Unload Form1
End Sub



Private Sub Form_Load()
    Dim s As String
    
    OperationCmb.Clear
    OperationCmb.AddItem "a + b"
    OperationCmb.AddItem "a - b"
    OperationCmb.AddItem "a * b"
    OperationCmb.AddItem "a / b"
    OperationCmb.AddItem "a ^ b"
    OperationCmb.AddItem "a mod b"
    OperationCmb.AddItem "AES encryption"
    OperationCmb.AddItem "SHA-256 hash value"
    OperationCmb.ListIndex = 0
    
    s = "This is only a small demo that shows how to call" + Chr$(13) + Chr$(10)
    s = s + "HIME functions from a Visual Basic program." + Chr$(13) + Chr$(10)
    s = s + "In this demo, only a few math functions are shown." + Chr$(13) + Chr$(10)
    s = s + " " + Chr$(13) + Chr$(10)
    s = s + "Program HIMEWorkbench.exe has more functions implemented." + Chr$(13) + Chr$(10)
    MsgBox s
End Sub

Private Sub RandomDataButt_Click()
    Dim i      As Long
    Dim s      As String
    Dim BitLen As Long

            'Fill parameter textboxes with random data of the required
            'bitlength
    BitLen = Val(BitLentxt.Text)
    
    i = HI_GENERATERANDOM(BitLen, 1)
    HI_HUGE2DEC 1, 1
    s = HI_GETREG(1)
    ParamA.Text = s
    
    i = HI_GENERATERANDOM(BitLen, 1)
    HI_HUGE2DEC 1, 1
    s = HI_GETREG(1)
    ParamB.Text = s
    
End Sub
