.code
;
;
; *************************
; *****  %_abs.giant  *****  ABS(giant)
; *************************
;
; in:	arg1:arg0 = source number
; out:	edx:eax = absolute value of source number
;
; destroys: nothing
;
; Generates an overflow trap if source number is 0x8000000000000000.
;

%_abs.giant:
	mov	edx,[esp+8]        					; edx = ms half of source number
	mov	eax,[esp+4]        					; eax = ls half of source number
	or	edx,edx            					; greater than or equal to zero?
	jns	> gabs_ret     							; yes: source number is its own absolute value
;
	cmp	edx,0x80000000     					; make sure |edx:eax| can be represented as
	jne	> gabs_negate  							; a signed 64-bit positive number
	or	eax,eax
	jnz	> gabs_negate
	call	%_eeeOverflow       			;Return from there
;
gabs_negate:
	not	edx                					; negate edx:eax
	neg	eax
	sbb	edx,-1
;
gabs_ret:
	ret
