/*
 * Decompiled with CFR 0.152.
 */
package unity.annotation;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import unity.annotation.CommonMethods;
import unity.annotation.SourceDatabase;
import unity.util.DGraph;

public class AnnotatedSourceDatabase
extends SourceDatabase {
    private String semanticDatabaseName = "";
    private Connection con = null;
    private DGraph joinGraph;

    public AnnotatedSourceDatabase() {
        this("", "", "", "", "");
    }

    public AnnotatedSourceDatabase(String name, String productName, String version, String url, String driver) {
        super(name, productName, version, url, driver);
    }

    public void setSemanticDatabaseName(String name) {
        this.semanticDatabaseName = name;
    }

    public String getSemanticDatabaseName() {
        return this.semanticDatabaseName;
    }

    public void setConnection(Connection newCon) {
        this.con = newCon;
    }

    public Connection getConnection() throws SQLException {
        if (this.con == null) {
            try {
                Class.forName(this.getJavaDriverName()).newInstance();
                this.con = DriverManager.getConnection(this.getURLJava());
            }
            catch (Exception e) {
                throw new SQLException("Connection error: " + e.toString());
            }
        }
        return this.con;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer(10000);
        buf.append("    <semanticDatabaseName>" + this.semanticDatabaseName + "</semanticDatabaseName>\n");
        buf.append(super.toXML());
        return buf.toString();
    }

    public DGraph getJoinGraph() {
        return this.joinGraph;
    }

    public void setJoinGraph(DGraph join) {
        this.joinGraph = join;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(10000);
        buf.append("SemanticDatabaseName: " + this.semanticDatabaseName + "\n");
        buf.append(super.toString());
        return buf.toString();
    }

    public Node importXML(Node xspec) {
        Element x = ((Document)xspec).getDocumentElement();
        Node child = x.getFirstChild();
        while (!child.getNodeName().equals("TABLE")) {
            if (child.getNodeName().equals("semanticDatabaseName")) {
                this.semanticDatabaseName = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("databaseName")) {
                this.databaseName = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("databaseProductName")) {
                this.databaseProductName = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("databaseProductVersion")) {
                this.databaseProductVersion = CommonMethods.getName(child);
            } else if (child.getNodeName().equals("urlJDBC")) {
                this.urlJDBC = CommonMethods.extractXMLParserSafe(CommonMethods.getName(child));
            } else if (child.getNodeName().equals("driverName")) {
                this.driverName = CommonMethods.getName(child);
            }
            child = child.getNextSibling();
        }
        return child;
    }
}

