/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import unity.functions.Expression;
import unity.functions.Function;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class F_Sqrt
extends Function {
    private Expression expr;

    public F_Sqrt(Expression e) {
        this.expr = e;
        this.returnType = Attribute.TYPE_DOUBLE;
    }

    public Object evaluate(Tuple t) {
        Object val = this.expr.evaluate(t);
        if (val == null) {
            return null;
        }
        if (val instanceof Number) {
            return new Double(Math.sqrt(((Number)val).doubleValue()));
        }
        return null;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public static int[] getParamListTypes() {
        return new int[]{Attribute.TYPE_NUMBER};
    }

    public static String getFunctionName() {
        return "SQRT";
    }

    public String toString(Relation relation) {
        return "SQRT(" + this.expr.toString(relation) + ")";
    }
}

