/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import unity.annotation.AttributeValueSource;
import unity.functions.Expression;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public class Multiply
extends Expression {
    public Multiply(Expression leftExpr, Expression rightExpr) throws SQLException {
        this.children = new ArrayList(2);
        this.children.add(leftExpr);
        this.children.add(rightExpr);
        int leftType = leftExpr.getReturnType();
        int rightType = rightExpr.getReturnType();
        boolean leftDouble = Attribute.isDoubleType(leftType);
        boolean rightDouble = Attribute.isDoubleType(rightType);
        boolean leftString = Attribute.isStringType(leftType);
        boolean rightString = Attribute.isStringType(rightType);
        if (leftString || rightString) {
            throw new SQLException("Cannot multiply strings around: " + leftExpr.toString() + " and " + rightExpr.toString());
        }
        this.returnType = leftDouble || rightDouble ? Attribute.TYPE_DOUBLE : (leftType == Attribute.TYPE_DECIMAL || rightType == Attribute.TYPE_DECIMAL ? Attribute.TYPE_DECIMAL : Attribute.TYPE_INT);
    }

    public Object evaluate(Tuple t) {
        Expression leftExpr = (Expression)this.children.get(0);
        Expression rightExpr = (Expression)this.children.get(1);
        Object val1 = leftExpr.evaluate(t);
        if (val1 == null) {
            return null;
        }
        Object val2 = rightExpr.evaluate(t);
        if (val2 == null) {
            return null;
        }
        Object v1 = val1;
        Object v2 = val2;
        int sourceRef = 0;
        if (val1 instanceof AttributeValueSource) {
            v1 = ((AttributeValueSource)val1).getValue();
            sourceRef = 1;
        }
        if (val2 instanceof AttributeValueSource) {
            v2 = ((AttributeValueSource)val2).getValue();
            sourceRef = 2;
        }
        Number returnVal = null;
        if (this.returnType == Attribute.TYPE_INT) {
            int i1 = (Integer)v1;
            int i2 = (Integer)v2;
            returnVal = new Integer(i1 * i2);
        } else if (this.returnType == Attribute.TYPE_DOUBLE) {
            double d1 = leftExpr.getReturnType() == Attribute.TYPE_INT ? (double)((Integer)v1).intValue() : (Double)v1;
            double d2 = rightExpr.getReturnType() == Attribute.TYPE_INT ? (double)((Integer)v2).intValue() : (Double)v2;
            returnVal = new Double(d1 * d2);
        } else if (this.returnType == Attribute.TYPE_DECIMAL) {
            BigDecimal d1 = leftExpr.getReturnType() == Attribute.TYPE_INT ? new BigDecimal((Integer)v1) : (leftExpr.getReturnType() == Attribute.TYPE_DOUBLE ? new BigDecimal((Double)v1) : (BigDecimal)v1);
            BigDecimal d2 = rightExpr.getReturnType() == Attribute.TYPE_INT ? new BigDecimal((Integer)v2) : (leftExpr.getReturnType() == Attribute.TYPE_DOUBLE ? new BigDecimal((Double)v2) : (BigDecimal)v2);
            returnVal = d1.multiply(d2);
        }
        if (sourceRef == 0) {
            return returnVal;
        }
        if (sourceRef == 1) {
            return new AttributeValueSource(returnVal, ((AttributeValueSource)val1).getSource());
        }
        return new AttributeValueSource(returnVal, ((AttributeValueSource)val2).getSource());
    }

    public String toString(Relation relation) {
        return String.valueOf(((Expression)this.children.get(0)).toString(relation)) + " * " + ((Expression)this.children.get(1)).toString(relation);
    }
}

