/*
 * Decompiled with CFR 0.152.
 */
package unity.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.relational.TupleTS;

public class Page {
    private Tuple[] tuples;
    private int maxTuples;
    private int curTuples;
    private int pageId;
    private int curPos;
    private static int lastPageId = 0;
    private Relation relation;
    private static long numReads = 0L;
    private static long numWrites = 0L;

    public Page(int max, Relation r) {
        this.maxTuples = max;
        this.curTuples = 0;
        this.relation = r;
        this.pageId = lastPageId++;
        this.tuples = new Tuple[max];
    }

    public Tuple[] getTuples() {
        return this.tuples;
    }

    public Tuple getTuple(int i) {
        return this.tuples[i];
    }

    public int getTupleCount() {
        return this.curTuples;
    }

    public int getMaxTupleCount() {
        return this.maxTuples;
    }

    public boolean hasSpace() {
        return this.curTuples < this.maxTuples;
    }

    public void initIterator() {
        this.curPos = 0;
    }

    public boolean hasNext() {
        return this.curPos < this.curTuples;
    }

    public Tuple next() {
        return this.tuples[this.curPos++];
    }

    public int getPageId() {
        return this.pageId;
    }

    public static long getReadCount() {
        return numReads;
    }

    public static long getWriteCount() {
        return numWrites;
    }

    public static long getIOCount() {
        return numReads + numWrites;
    }

    public static void resetCounts() {
        numReads = 0L;
        numWrites = 0L;
    }

    public boolean addTuple(Tuple t) {
        if (this.curTuples == this.maxTuples) {
            return false;
        }
        this.tuples[this.curTuples] = t instanceof TupleTS ? new TupleTS((TupleTS)t) : new Tuple(t);
        ++this.curTuples;
        return true;
    }

    public int read(BufferedInputStream in) throws IOException {
        this.curTuples = 0;
        while (this.curTuples < this.maxTuples) {
            Tuple t = new Tuple(this.relation);
            if (!t.read(in)) break;
            this.tuples[this.curTuples] = t;
            ++this.curTuples;
        }
        if (this.curTuples > 0) {
            ++numReads;
        }
        return this.curTuples;
    }

    public void write(BufferedOutputStream out) throws IOException {
        int i = 0;
        while (i < this.curTuples) {
            this.tuples[i].write(out);
            ++i;
        }
        ++numWrites;
    }

    public void flush(BufferedOutputStream out) throws IOException {
        this.write(out);
        this.curTuples = 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.maxTuples * 500);
        int i = 0;
        while (i < this.curTuples) {
            buf.append("      " + this.tuples[i] + "\n");
            ++i;
        }
        return buf.toString();
    }
}

