/*
 * Decompiled with CFR 0.152.
 */
package unity.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import unity.query.GlobalQuery;
import unity.query.ResultRowData;

public class UnityResultSetMetaData
implements ResultSetMetaData {
    private String[] columnHeaders;
    private ResultRowData rrd;
    private GlobalQuery gq;
    int columnNoNulls = 0;
    int columnNullable = 1;
    int columnNullableUnknown = 2;

    UnityResultSetMetaData(ResultRowData results) throws SQLException {
        this.rrd = results;
        this.gq = this.rrd.getGlobalQuery();
        this.columnHeaders = this.gq.getHeaders();
    }

    public int getColumnCount() throws SQLException {
        return this.columnHeaders.length;
    }

    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    public boolean isCaseSensitive(int column) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public boolean isSearchable(int column) throws SQLException {
        throw new SQLException("Method not implemented");
    }

    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    public int isNullable(int column) throws SQLException {
        return this.gq.isNullable(column);
    }

    public boolean isSigned(int column) throws SQLException {
        return false;
    }

    public int getColumnDisplaySize(int column) throws SQLException {
        return this.gq.getColumnDisplaySize(column);
    }

    public String getColumnLabel(int column) throws SQLException {
        return this.columnHeaders[column - 1];
    }

    public String getColumnName(int column) throws SQLException {
        return this.columnHeaders[column - 1];
    }

    public String getSchemaName(int column) throws SQLException {
        return this.gq.getSchemaName(column);
    }

    public int getPrecision(int column) throws SQLException {
        return this.gq.getPrecision(column);
    }

    public int getScale(int column) throws SQLException {
        return 0;
    }

    public String getTableName(int column) throws SQLException {
        return this.gq.getTableName(column);
    }

    public String getCatalogName(int column) throws SQLException {
        return this.gq.getCatalogName(column);
    }

    public int getColumnType(int column) throws SQLException {
        return this.gq.getColumnType(column);
    }

    public String getColumnTypeName(int column) throws SQLException {
        return this.gq.getColumnTypeName(column);
    }

    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    public String getColumnClassName(int column) throws SQLException {
        throw new SQLException("Method not implemented");
    }
}

