/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import java.util.Random;
import unity.operators.Operator;
import unity.relational.Tuple;

public class BufferOperator
extends Operator {
    protected Tuple[] buffer;
    protected int first;
    protected int last;
    protected int count;
    protected int maxBufferSize;
    protected int maxProcessSize;
    protected int minTupleCount;
    protected Operator inputOp;
    protected boolean threadRunning;
    protected boolean endInput;
    protected Random generator;
    protected long seed;
    protected int delay;
    protected long transferRate;
    protected int blockSize;
    protected boolean makeDelays;
    protected boolean doBursty;
    protected double burstyValue;
    protected int blockCounter;
    protected static int threadCount = 0;

    public BufferOperator(Operator in, int maxSize, int genSeed, boolean doDelay, int transRate, boolean doBurst, double bursty) {
        this(in, maxSize, maxSize / 2, maxSize / 4, genSeed, doDelay, transRate, doBurst, bursty);
    }

    public BufferOperator(Operator in, int maxSize, int maxProcess, int minCount) {
        this(in, maxSize, maxProcess, minCount, 0, false, 0, false, 0.0);
    }

    public BufferOperator(Operator in, int maxSize, int maxProcess, int minCount, int genSeed, boolean doDelay, int transRate, boolean doBurst, double bursty) {
        super(new Operator[]{in}, 0, 0);
        this.inputOp = in;
        this.buffer = new Tuple[maxSize];
        this.maxBufferSize = maxSize;
        this.minTupleCount = minCount;
        this.maxProcessSize = maxProcess;
        this.first = 0;
        this.last = this.maxBufferSize - 1;
        this.count = 0;
        this.endInput = false;
        this.setOutputRelation(in.getOutputRelation());
        this.makeDelays = doDelay;
        if (doDelay) {
            this.seed = genSeed;
            this.burstyValue = bursty;
            this.doBursty = doBurst;
            this.delay = 32;
            this.blockSize = transRate / (1000 / (this.delay + 2));
            this.transferRate = transRate;
            this.generator = new Random(this.seed);
            this.blockCounter = this.blockSize;
            System.out.println("Initialized buffer operator with transfer rate of: " + this.transferRate + " and delay: " + this.delay + " block size: " + this.blockSize);
        }
    }

    public int numTuplesInBuffer() {
        return this.count;
    }

    public boolean isBuffered() {
        return true;
    }

    public void init() throws IOException {
        this.inputOp.init();
        this.createNewThread();
    }

    protected void createNewThread() {
        this.threadRunning = true;
        BufferThread bt = new BufferThread();
        Thread t = new Thread(bt);
        t.start();
        System.out.println("Creating new thread.  Active: " + Thread.activeCount() + " Total: " + ++threadCount);
    }

    public Tuple next() throws IOException {
        while (this.count == 0 && !this.endInput) {
            if (!this.threadRunning) {
                this.createNewThread();
                continue;
            }
            Thread.yield();
        }
        return this.pop();
    }

    public boolean endInput() {
        return this.count == 0 && this.endInput;
    }

    public boolean hasNext() throws IOException {
        if (this.count > 0) {
            return true;
        }
        return this.count != 0 || !this.endInput;
    }

    public void close() throws IOException {
        super.close();
    }

    protected synchronized void updateCount(int change) {
        this.count += change;
    }

    protected int next_index(int idx) {
        return (idx + 1) % this.maxBufferSize;
    }

    protected void push(Tuple t) {
        if (this.makeDelays && this.blockCounter-- == 0) {
            try {
                int thisDelay = this.delay;
                if (this.doBursty) {
                    double r = this.generator.nextDouble();
                    r = -Math.log(r);
                    thisDelay = (int)(r *= (double)this.delay);
                }
                if (thisDelay >= 5) {
                    Thread.sleep(thisDelay);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.blockCounter = this.blockSize - 1;
        }
        this.last = this.next_index(this.last);
        this.buffer[this.last] = t;
        this.updateCount(1);
    }

    protected Tuple pop() {
        if (this.count == 0) {
            return null;
        }
        Tuple t = this.buffer[this.first];
        this.first = this.next_index(this.first);
        this.updateCount(-1);
        this.incrementTuplesOutput();
        if (!this.threadRunning && this.count < this.minTupleCount) {
            this.createNewThread();
        }
        return t;
    }

    public String toString() {
        return "BUFFER: (SizeInTuples=" + this.maxBufferSize + ")";
    }

    private class BufferThread
    extends Thread {
        BufferThread() {
        }

        public void run() {
            try {
                while (BufferOperator.this.count < BufferOperator.this.minTupleCount) {
                    int i = 0;
                    while (i < BufferOperator.this.maxProcessSize) {
                        if (BufferOperator.this.count < BufferOperator.this.maxBufferSize) {
                            Tuple inTuple = BufferOperator.this.inputOp.next();
                            if (inTuple == null) {
                                BufferOperator.this.threadRunning = false;
                                BufferOperator.this.endInput = true;
                                return;
                            }
                            BufferOperator.this.push(inTuple);
                        }
                        ++i;
                    }
                }
                System.out.println("Looping again.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            BufferOperator.this.threadRunning = false;
            System.out.println("Thread done: " + Thread.activeCount());
        }
    }
}

