/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import unity.io.FileManager;
import unity.io.Page;
import unity.predicates.EquiJoinPredicate;
import unity.predicates.SortComparator;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.relational.TupleTS;
import unity.relational.TupleXJoin;
import unity.util.HashFunc;

public class DualHashTable {
    private int NUM_BUCKETS;
    private int NUM_PARTITIONS;
    private int MAX_SIZE;
    private int PARTITION_SIZE;
    private int BLOCKING_FACTOR;
    public static int DEFAULT_LIST_SIZE = 5;
    public static int IS_EXPANDING = 1;
    public static int IS_FROZEN = 2;
    public static int IS_REBUILDING = 3;
    private Relation[] schemas;
    private EquiJoinPredicate[] predicates;
    private int keyType;
    private int numJoinAttrs;
    private int[][] joinAttrLocs;
    private boolean EARLY_PURGE;
    private boolean leftInputFinished;
    private boolean rightInputFinished;
    private Object[] buckets;
    private boolean[] isArray;
    private PartitionInfo[] partitions;
    private int[] tupleCount;
    private int tuplesDiscarded;
    private int insertsAvoided;

    public DualHashTable(int maxsize, int numPart, int bfr, Relation left, Relation right, EquiJoinPredicate p, boolean earlyDelete) {
        this(maxsize, numPart, bfr, left, right, p, earlyDelete, 1.0);
    }

    public DualHashTable(int maxsize, int numPart, int bfr, Relation left, Relation right, EquiJoinPredicate p, boolean earlyDelete, double scale) {
        this.NUM_PARTITIONS = numPart;
        this.MAX_SIZE = maxsize;
        this.BLOCKING_FACTOR = bfr;
        this.NUM_BUCKETS = (int)((double)this.MAX_SIZE * scale);
        this.PARTITION_SIZE = this.NUM_BUCKETS / this.NUM_PARTITIONS;
        this.PARTITION_SIZE = this.PARTITION_SIZE <= 1 ? 1 : HashFunc.nextPrime(this.PARTITION_SIZE);
        this.NUM_BUCKETS = this.PARTITION_SIZE * this.NUM_PARTITIONS;
        this.schemas = new Relation[2];
        this.schemas[0] = left;
        this.schemas[1] = right;
        this.predicates = new EquiJoinPredicate[2];
        this.predicates[0] = p;
        this.predicates[1] = p.inversePredicate();
        this.keyType = p.getKeyType();
        this.joinAttrLocs = new int[2][];
        this.joinAttrLocs[0] = p.getRelation1Locs();
        this.joinAttrLocs[1] = p.getRelation2Locs();
        this.numJoinAttrs = this.joinAttrLocs[0].length;
        this.EARLY_PURGE = earlyDelete;
        this.buckets = new Object[2 * this.NUM_BUCKETS];
        Arrays.fill(this.buckets, null);
        this.isArray = new boolean[2 * this.NUM_BUCKETS];
        Arrays.fill(this.isArray, false);
        this.tupleCount = new int[2];
        this.tupleCount[0] = 0;
        this.tupleCount[1] = 0;
        this.partitions = new PartitionInfo[2 * this.NUM_PARTITIONS];
        int i = 0;
        while (i < this.NUM_PARTITIONS) {
            int startIndex = i * this.PARTITION_SIZE;
            int endIndex = (i + 1) * this.PARTITION_SIZE - 1;
            this.partitions[i] = new PartitionInfo(i, startIndex, endIndex);
            this.partitions[this.NUM_PARTITIONS + i] = new PartitionInfo(i, this.NUM_BUCKETS + startIndex, this.NUM_BUCKETS + endIndex);
            ++i;
        }
        this.tuplesDiscarded = 0;
        this.insertsAvoided = 0;
        this.leftInputFinished = false;
        this.rightInputFinished = false;
    }

    public int insert(Tuple t, int source, boolean NProbeMatch) throws IOException {
        int bucket = this.getTupleLocation(t, source);
        int index = source * this.NUM_BUCKETS + bucket;
        int partIndex = bucket / this.PARTITION_SIZE;
        int partitionIndex = source * this.NUM_PARTITIONS + partIndex;
        if (source == 1 && this.EARLY_PURGE && NProbeMatch || source == 1 && this.leftInputFinished && this.partitions[partIndex].numFlushes == 0 || source == 0 && this.rightInputFinished && this.partitions[this.NUM_PARTITIONS + partIndex].numFlushes == 0) {
            ++this.insertsAvoided;
            return 0;
        }
        if (this.partitions[partitionIndex].state == IS_FROZEN) {
            return this.partitions[partitionIndex].addTupleToOutputPage(t);
        }
        if (this.buckets[index] == null) {
            this.buckets[index] = t;
        } else if (this.isArray[index]) {
            ((ArrayList)this.buckets[index]).add(t);
        } else {
            Tuple oldTuple = (Tuple)this.buckets[index];
            ArrayList<Tuple> list = new ArrayList<Tuple>(DEFAULT_LIST_SIZE);
            list.add(oldTuple);
            list.add(t);
            this.buckets[index] = list;
            this.isArray[index] = true;
        }
        int n = source;
        this.tupleCount[n] = this.tupleCount[n] + 1;
        ++this.partitions[partitionIndex].numTuples;
        return 0;
    }

    public boolean hasOverflow() {
        return this.tupleCount[0] + this.tupleCount[1] > this.MAX_SIZE;
    }

    public ArrayList probe(Tuple probeTuple, int probeSource) throws IOException {
        int bucket = this.getTupleLocation(probeTuple, probeSource);
        int otherSource = (probeSource + 1) % 2;
        int index = otherSource * this.NUM_BUCKETS + bucket;
        int partitionIndex = otherSource * this.NUM_PARTITIONS + bucket / this.PARTITION_SIZE;
        if (this.partitions[partitionIndex].state == IS_FROZEN) {
            return null;
        }
        EquiJoinPredicate joinPred = this.predicates[otherSource];
        ArrayList<Object> matches = null;
        if (this.buckets[index] == null) {
            return null;
        }
        if (this.isArray[index]) {
            ArrayList a = (ArrayList)this.buckets[index];
            matches = new ArrayList<Object>(a.size());
            int i = 0;
            while (i < a.size()) {
                Tuple otherTuple = (Tuple)a.get(i);
                if (joinPred.isEqual(otherTuple, probeTuple)) {
                    matches.add(otherTuple);
                    if (this.EARLY_PURGE && probeSource == 0) {
                        a.remove(i);
                        --i;
                        ++this.tuplesDiscarded;
                    }
                }
                ++i;
            }
            if (matches.size() == 0) {
                return null;
            }
            return matches;
        }
        if (joinPred.isEqual((Tuple)this.buckets[index], probeTuple)) {
            matches = new ArrayList(1);
            matches.add(this.buckets[index]);
            if (this.EARLY_PURGE && probeSource == 0) {
                this.buckets[index] = null;
                ++this.tuplesDiscarded;
            }
            return matches;
        }
        return null;
    }

    public void flush(int source, int partitionIndex, int newState, int timestamp) throws IOException {
        this.flush(source, partitionIndex, newState, timestamp, false, null, false);
    }

    public void flush(int source, int partitionIndex, int newState, int timestamp, boolean flushSorted, SortComparator sorter, boolean departTS) throws IOException {
        BufferedOutputStream out;
        String fileName = "";
        PartitionInfo partInfo = this.partitions[source * this.NUM_PARTITIONS + partitionIndex];
        if (partInfo.state == IS_EXPANDING) {
            fileName = FileManager.createTempFileName(source + "_" + partitionIndex + "_" + partInfo.numFlushes);
            out = FileManager.openOutputFile(fileName);
            partInfo.outputCounter = this.BLOCKING_FACTOR - 1;
            partInfo.fileNames.add(fileName);
        } else {
            out = partInfo.outputFile;
        }
        int startBucketIndex = partInfo.startIndex;
        int endBucketIndex = partInfo.endIndex;
        int flushedTuples = partInfo.numTuples;
        if (flushSorted) {
            Tuple[] buffer = new Tuple[partInfo.numTuples];
            int count = 0;
            int i = startBucketIndex;
            while (i <= endBucketIndex) {
                if (this.buckets[i] != null) {
                    if (this.isArray[i]) {
                        ArrayList a = (ArrayList)this.buckets[i];
                        int j = 0;
                        while (j < a.size()) {
                            Tuple t = (Tuple)a.get(j);
                            buffer[count++] = t;
                            ++j;
                        }
                    } else {
                        buffer[count++] = (Tuple)this.buckets[i];
                    }
                    this.buckets[i] = null;
                    this.isArray[i] = false;
                }
                ++i;
            }
            Arrays.sort(buffer, 0, count, sorter);
            i = 0;
            while (i < count) {
                buffer[i].write(out);
                ++i;
            }
        } else if (!departTS) {
            int i = startBucketIndex;
            while (i <= endBucketIndex) {
                if (this.buckets[i] != null) {
                    if (this.isArray[i]) {
                        ArrayList a = (ArrayList)this.buckets[i];
                        int j = 0;
                        while (j < a.size()) {
                            Tuple t = (Tuple)a.get(j);
                            t.write(out);
                            ++j;
                        }
                    } else {
                        ((Tuple)this.buckets[i]).write(out);
                    }
                    this.buckets[i] = null;
                    this.isArray[i] = false;
                }
                ++i;
            }
        } else {
            int i = startBucketIndex;
            while (i <= endBucketIndex) {
                if (this.buckets[i] != null) {
                    if (this.isArray[i]) {
                        ArrayList a = (ArrayList)this.buckets[i];
                        int j = 0;
                        while (j < a.size()) {
                            TupleXJoin t = (TupleXJoin)a.get(j);
                            t.setDepartureTimestamp(timestamp);
                            t.write(out);
                            ++j;
                        }
                    } else {
                        TupleXJoin t = (TupleXJoin)this.buckets[i];
                        t.setDepartureTimestamp(timestamp);
                        t.write(out);
                    }
                    this.buckets[i] = null;
                    this.isArray[i] = false;
                }
                ++i;
            }
        }
        if (newState == IS_EXPANDING) {
            FileManager.closeFile(out);
        } else {
            partInfo.outputFile = out;
        }
        int n = source;
        this.tupleCount[n] = this.tupleCount[n] - flushedTuples;
        partInfo.numTuples -= flushedTuples;
        partInfo.state = newState;
        ++partInfo.numFlushes;
        partInfo.currentPartitionSize += flushedTuples;
        partInfo.outputPage = new Page(this.BLOCKING_FACTOR, this.schemas[source]);
        partInfo.flushTimes.add(new Integer(timestamp));
        partInfo.probeTimes.add(new Integer(timestamp));
    }

    public int close(int state, int timestamp) throws IOException {
        int total = 0;
        int i = 0;
        while (i < this.NUM_PARTITIONS) {
            if (this.partitions[i].state == state) {
                if (this.partitions[i].state == IS_REBUILDING) {
                    this.flush(0, i, IS_REBUILDING, timestamp);
                }
                total += this.partitions[i].close();
            }
            if (this.partitions[i + this.NUM_PARTITIONS].state == state) {
                if (this.partitions[i].state == IS_REBUILDING) {
                    this.flush(1, i, IS_REBUILDING, timestamp);
                }
                total += this.partitions[i + this.NUM_PARTITIONS].close();
            }
            ++i;
        }
        return total;
    }

    public void empty() {
        Arrays.fill(this.buckets, null);
        Arrays.fill(this.isArray, false);
        this.tupleCount[0] = 0;
        this.tupleCount[1] = 0;
    }

    public void clear() throws IOException {
        int i = 0;
        while (i < 2 * this.NUM_PARTITIONS) {
            this.partitions[i].clear();
            ++i;
        }
    }

    public void clear(int source, int partitionIndex) throws IOException {
        PartitionInfo part = this.partitions[source * this.NUM_PARTITIONS + partitionIndex];
        Arrays.fill(this.buckets, part.startIndex, part.endIndex, null);
        Arrays.fill(this.isArray, part.startIndex, part.endIndex, false);
        int n = source;
        this.tupleCount[n] = this.tupleCount[n] - part.numTuples;
        part.clear();
    }

    public String toString() {
        String st = "";
        st = String.valueOf(st) + "Max_size: " + this.MAX_SIZE + " Partition size: " + this.PARTITION_SIZE + " Table Size: " + this.NUM_BUCKETS + "\n";
        st = String.valueOf(st) + "Left table: \n";
        int i = 0;
        while (i < this.NUM_BUCKETS) {
            st = this.buckets[i] != null ? String.valueOf(st) + "Bucket " + i + ": " + this.buckets[i].toString() + "\n" : String.valueOf(st) + "Bucket " + i + ": (empty)\n";
            ++i;
        }
        st = String.valueOf(st) + "Right table: \n";
        i = 0;
        while (i < this.NUM_BUCKETS) {
            int idx = this.NUM_BUCKETS + i;
            st = this.buckets[idx] != null ? String.valueOf(st) + "Bucket " + i + ": " + this.buckets[idx].toString() + "\n" : String.valueOf(st) + "Bucket " + i + ": (empty)\n";
            ++i;
        }
        st = String.valueOf(st) + "\nTable Statistics:\n";
        i = 0;
        while (i < this.NUM_PARTITIONS) {
            st = String.valueOf(st) + "Partition: " + i + "\t" + this.partitions[i].toString() + "\t" + this.partitions[this.NUM_PARTITIONS + i].toString() + "\n";
            ++i;
        }
        st = String.valueOf(st) + "\nTotal Left Tuples (memory): " + this.tupleCount[0] + "\n";
        st = String.valueOf(st) + "Total Right Tuples (memory): " + this.tupleCount[1] + "\n";
        return st;
    }

    public String printTupleCounts() {
        String st = "\nTotal Left Tuples (memory): " + this.tupleCount[0] + "\n";
        st = String.valueOf(st) + "Total Right Tuples (memory): " + this.tupleCount[1] + "\n";
        return st;
    }

    public boolean leftSmaller() {
        return this.tupleCount[0] <= this.tupleCount[1];
    }

    public PartitionInfo[] getPartitionInfo() {
        return this.partitions;
    }

    public int getTupleCount(int source) {
        return this.tupleCount[source];
    }

    public int getPartitionTupleCount(int source, int partIndex) {
        return this.partitions[source * this.NUM_PARTITIONS + partIndex].numTuples;
    }

    public int getPartitionState(int source, int partIndex) {
        return this.partitions[source * this.NUM_PARTITIONS + partIndex].state;
    }

    public void setPartitionState(int source, int partIndex, int state) {
        this.partitions[source * this.NUM_PARTITIONS + partIndex].state = state;
    }

    public ArrayList getPartitionFileNames(int source, int partIndex) {
        return this.partitions[source * this.NUM_PARTITIONS + partIndex].fileNames;
    }

    public void addPartitionFileNames(int source, int partIndex, String fname) {
        this.partitions[source * this.NUM_PARTITIONS + partIndex].fileNames.add(fname);
    }

    public ArrayList getPartitionFlushTimes(int source, int partIndex) {
        return this.partitions[source * this.NUM_PARTITIONS + partIndex].flushTimes;
    }

    public ArrayList getPartitionProbeTimes(int source, int partIndex) {
        return this.partitions[source * this.NUM_PARTITIONS + partIndex].probeTimes;
    }

    public ArrayList getPartitionTuples(int source, int partIndex) {
        PartitionInfo part = this.partitions[source * this.NUM_PARTITIONS + partIndex];
        ArrayList<Tuple> res = new ArrayList<Tuple>(part.numTuples);
        int i = part.startIndex;
        while (i <= part.endIndex) {
            if (this.buckets[i] != null) {
                if (this.isArray[i]) {
                    res.addAll((ArrayList)this.buckets[i]);
                } else {
                    res.add((Tuple)this.buckets[i]);
                }
            }
            ++i;
        }
        return res;
    }

    public void setLeftInputFinished(boolean b) {
        this.leftInputFinished = b;
    }

    public void setRightInputFinished(boolean b) {
        this.rightInputFinished = b;
    }

    public int getNumFiles(int source, int partIndex) {
        return this.partitions[source * this.NUM_PARTITIONS + partIndex].getNumFiles();
    }

    public int clearLeftFinished() throws IOException {
        int tuplesRemoved = 0;
        int i = 0;
        while (i < this.NUM_PARTITIONS) {
            PartitionInfo rightPartInfo = this.partitions[this.NUM_PARTITIONS + i];
            if (rightPartInfo.numFlushes == 0 && this.partitions[i].numFlushes == 0) {
                tuplesRemoved += rightPartInfo.numTuples;
                Arrays.fill(this.buckets, rightPartInfo.startIndex, rightPartInfo.endIndex, null);
                Arrays.fill(this.isArray, rightPartInfo.startIndex, rightPartInfo.endIndex, false);
                this.partitions[this.NUM_PARTITIONS + i].clear();
            }
            this.partitions[i].close();
            ++i;
        }
        this.tupleCount[1] = this.tupleCount[1] - tuplesRemoved;
        return tuplesRemoved;
    }

    public int clearRightFinished() throws IOException {
        int tuplesRemoved = 0;
        int i = 0;
        while (i < this.NUM_PARTITIONS) {
            PartitionInfo leftPartInfo = this.partitions[i];
            if (leftPartInfo.numFlushes == 0 && this.partitions[this.NUM_PARTITIONS + i].numFlushes == 0) {
                tuplesRemoved += leftPartInfo.numTuples;
                Arrays.fill(this.buckets, leftPartInfo.startIndex, leftPartInfo.endIndex, null);
                Arrays.fill(this.isArray, leftPartInfo.startIndex, leftPartInfo.endIndex, false);
                this.partitions[i].clear();
            }
            this.partitions[i + this.NUM_PARTITIONS].close();
            ++i;
        }
        this.tupleCount[0] = this.tupleCount[0] - tuplesRemoved;
        return tuplesRemoved;
    }

    public int getTuplesDiscarded() {
        return this.tuplesDiscarded;
    }

    public int getInsertsAvoided() {
        return this.insertsAvoided;
    }

    private int getTupleLocation(Tuple t, int source) {
        int[] currentIdx = this.joinAttrLocs[source];
        if (this.keyType == 1) {
            if (t.isNull(currentIdx[0])) {
                return 0;
            }
            int key = t.getInt(currentIdx[0]);
            return key % this.NUM_BUCKETS;
        }
        if (this.keyType == 2) {
            if (t.isNull(currentIdx[0])) {
                return 0;
            }
            String key = t.getString(currentIdx[0]);
            return HashFunc.hash(key, this.NUM_BUCKETS);
        }
        Object[] vals = new Object[this.numJoinAttrs];
        int k = 0;
        while (k < this.numJoinAttrs) {
            vals[k] = t.getObject(currentIdx[k]);
            ++k;
        }
        return HashFunc.hash(vals, this.NUM_BUCKETS);
    }

    public static void main(String[] args) throws IOException {
        ArrayList resultList;
        TupleTS t;
        String st;
        ArrayList<String> v;
        int key;
        long seed = System.currentTimeMillis();
        Random generator = new Random(seed);
        Relation rLeft = new Relation(new Attribute[]{new Attribute("key", Attribute.TYPE_STRING, 0), new Attribute("name", Attribute.TYPE_STRING, 35)});
        Relation rRight = new Relation(new Attribute[]{new Attribute("value", Attribute.TYPE_STRING, 20), new Attribute("vkey", Attribute.TYPE_STRING, 0)});
        EquiJoinPredicate p = new EquiJoinPredicate(new int[1], new int[]{1}, EquiJoinPredicate.INT_KEY);
        DualHashTable H = new DualHashTable(250, 11, 10, rLeft, rRight, p, false);
        int i = 0;
        while (i < 200) {
            key = generator.nextInt(50) + 1;
            v = new ArrayList<String>();
            st = "" + key;
            if (i % 2 == 0) {
                v.add(st);
                v.add("Test" + st);
                t = new TupleTS(v.toArray(), rLeft, i);
            } else {
                v.add("Value" + st);
                v.add(st);
                t = new TupleTS(v.toArray(), rRight, i);
            }
            H.insert(t, i % 2, false);
            if (H.hasOverflow()) {
                System.out.println("Insert failed.  Key: " + key);
            }
            ++i;
        }
        System.out.println("Hash table:\n" + H);
        System.out.println("\nProbing left table...");
        i = 1;
        while (i <= 10) {
            key = i;
            v = new ArrayList();
            st = "" + key;
            v.add("ValueProbe" + st);
            v.add(st);
            t = new TupleTS(v.toArray(), rRight, 200 + i);
            resultList = H.probe(t, 1);
            if (resultList != null) {
                System.out.println("Probe for key on left: " + t.getInt(1) + " found # tuples: " + resultList.size());
            } else {
                System.out.println("Probe for key on left: " + t.getInt(1) + " found # tuples: 0");
            }
            ++i;
        }
        System.out.println("\nProbing right table...");
        i = 1;
        while (i <= 10) {
            key = i;
            v = new ArrayList();
            st = "" + key;
            v.add(st);
            v.add("Test" + st);
            t = new TupleTS(v.toArray(), rLeft, 200 + i);
            resultList = H.probe(t, 0);
            if (resultList != null) {
                System.out.println("Probe for key on right: " + t.getInt(0) + " found # tuples: " + resultList.size());
            } else {
                System.out.println("Probe for key on right: " + t.getInt(0) + " found # tuples: 0");
            }
            ++i;
        }
    }

    public ArrayList getNonJoinedLeft() {
        ArrayList<TupleTS> res = new ArrayList<TupleTS>();
        int i = 0;
        while (i < this.NUM_PARTITIONS) {
            PartitionInfo leftPartInfo = this.partitions[i];
            if (leftPartInfo.numFlushes == 0) {
                int j = leftPartInfo.startIndex;
                while (j <= leftPartInfo.endIndex) {
                    if (this.buckets[j] != null) {
                        if (this.isArray[j]) {
                            ArrayList a = (ArrayList)this.buckets[j];
                            int k = 0;
                            while (k < a.size()) {
                                TupleTS t = (TupleTS)a.get(k);
                                if (t.getTimestamp() > 0) {
                                    res.add(t);
                                }
                                ++k;
                            }
                        } else {
                            TupleTS t = (TupleTS)this.buckets[j];
                            if (t.getTimestamp() > 0) {
                                res.add(t);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return res;
    }

    public ArrayList getNonJoinedRight() {
        ArrayList<TupleTS> res = new ArrayList<TupleTS>();
        int i = 0;
        while (i < this.NUM_PARTITIONS) {
            PartitionInfo rightPartInfo = this.partitions[i + this.NUM_PARTITIONS];
            if (rightPartInfo.numFlushes == 0) {
                int j = rightPartInfo.startIndex;
                while (j <= rightPartInfo.endIndex) {
                    if (this.buckets[j] != null) {
                        if (this.isArray[j]) {
                            ArrayList a = (ArrayList)this.buckets[j];
                            int k = 0;
                            while (k < a.size()) {
                                TupleTS t = (TupleTS)a.get(k);
                                if (t.getTimestamp() > 0) {
                                    res.add(t);
                                }
                                ++k;
                            }
                        } else {
                            TupleTS t = (TupleTS)this.buckets[j];
                            if (t.getTimestamp() > 0) {
                                res.add(t);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return res;
    }

    public class PartitionInfo {
        public int numTuples;
        public int state;
        public int startIndex;
        public int endIndex;
        public int partitionNum;
        public int numFlushes;
        public ArrayList fileNames;
        public BufferedOutputStream outputFile;
        public ArrayList flushTimes;
        public ArrayList partitionSizes;
        public int currentPartitionSize;
        public ArrayList probeTimes;
        private int fileIdx;
        private int outputCounter;
        public Page outputPage;

        public PartitionInfo(int num, int si, int ei) {
            this.startIndex = si;
            this.endIndex = ei;
            this.partitionNum = num;
            this.init();
        }

        public int getNumTuples() {
            return this.numTuples;
        }

        public int getState() {
            return this.state;
        }

        public int getFileIdx() {
            return this.fileIdx;
        }

        public int getNumFiles() {
            return this.fileNames.size();
        }

        public int getPartitionSize(int idx) {
            if (idx == this.flushTimes.size() - 1) {
                return this.currentPartitionSize;
            }
            return (Integer)this.partitionSizes.get(idx);
        }

        public int getLongestProbeTime(int minSize) {
            if (this.state == IS_FROZEN) {
                int idx = -1;
                int longestTime = 999999999;
                int i = 0;
                while (i < this.probeTimes.size()) {
                    int partSize;
                    int probeTime = (Integer)this.probeTimes.get(i);
                    if (probeTime < longestTime && (partSize = i == this.flushTimes.size() - 1 ? this.currentPartitionSize : (Integer)this.partitionSizes.get(i)) > minSize) {
                        longestTime = probeTime;
                        idx = i;
                    }
                    ++i;
                }
                this.fileIdx = idx;
                return longestTime;
            }
            return -1;
        }

        public void init() {
            this.numTuples = 0;
            this.outputCounter = 0;
            this.state = IS_EXPANDING;
            this.numFlushes = 0;
            this.currentPartitionSize = 0;
            this.fileNames = new ArrayList();
            this.flushTimes = new ArrayList();
            this.probeTimes = new ArrayList();
            this.partitionSizes = new ArrayList();
            this.outputFile = null;
            this.outputPage = null;
        }

        public void clear() {
            int i = 0;
            while (i < this.fileNames.size()) {
                String fileName = (String)this.fileNames.get(i);
                FileManager.deleteFile(fileName);
                ++i;
            }
            this.init();
        }

        public int close() throws IOException {
            if (this.outputFile != null) {
                if (this.outputPage != null) {
                    this.outputPage.write(this.outputFile);
                }
                FileManager.closeFile(this.outputFile);
                this.partitionSizes.add(new Integer(this.currentPartitionSize));
                this.outputFile = null;
                return DualHashTable.this.BLOCKING_FACTOR - 1 - this.outputCounter;
            }
            return 0;
        }

        public int addTupleToOutputPage(Tuple t) throws IOException {
            this.outputPage.addTuple(t);
            if (this.outputCounter-- == 0) {
                this.outputCounter = DualHashTable.this.BLOCKING_FACTOR - 1;
                this.outputPage.flush(this.outputFile);
                return DualHashTable.this.BLOCKING_FACTOR;
            }
            return 0;
        }

        public String toString() {
            return "Tuples: " + this.numTuples;
        }

        public boolean createNewOutputFile(int source, int timestamp) throws IOException {
            if (this.outputFile == null) {
                return false;
            }
            this.close();
            String fileName = FileManager.createTempFileName(source + "_" + this.partitionNum + "_" + this.numFlushes);
            ++this.numFlushes;
            int prevFlushTime = (Integer)this.flushTimes.get(this.flushTimes.size() - 1);
            this.flushTimes.add(new Integer(prevFlushTime));
            this.outputFile = FileManager.openOutputFile(fileName);
            this.outputPage = new Page(DualHashTable.this.BLOCKING_FACTOR, DualHashTable.this.schemas[source]);
            this.fileNames.add(fileName);
            this.currentPartitionSize = 0;
            return true;
        }
    }
}

