/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import unity.io.FileManager;
import unity.io.Page;
import unity.operators.ChainedHashTable;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.util.HashFunc;

public class PageHashTable {
    private HashBucket[] buckets;
    private int tableSize;
    private int pageSize;
    private int usedPages;
    private int maxPages;
    private Relation relation;
    public static int IS_EMPTY = 0;
    public static int IS_EXPANDING = 1;
    public static int IS_FROZEN = 2;
    private int tupleIOs;
    private int pageIOs;

    public PageHashTable(int tblSize, int pgSize, int maxpg, Relation r) {
        this.buckets = new HashBucket[tblSize];
        this.pageSize = pgSize;
        this.maxPages = maxpg;
        this.relation = r;
        this.tableSize = this.buckets.length;
        int i = 0;
        while (i < this.tableSize) {
            this.buckets[i] = new HashBucket(i);
            ++i;
        }
    }

    public int getTupleIOs() {
        return this.tupleIOs;
    }

    public int getPageIOs() {
        return this.pageIOs;
    }

    public void clear() {
        int i = 0;
        while (i < this.tableSize) {
            this.buckets[i].clear();
            ++i;
        }
    }

    public void flush(int state) throws IOException {
        this.tupleIOs = 0;
        this.pageIOs = 0;
        int i = 0;
        while (i < this.tableSize) {
            if (this.buckets[i].getState() == state) {
                this.buckets[i].flush();
            }
            ++i;
        }
    }

    public void close(int state) throws IOException {
        this.tupleIOs = 0;
        this.pageIOs = 0;
        int i = 0;
        while (i < this.tableSize) {
            if (this.buckets[i].getState() == state) {
                this.buckets[i].close();
            }
            ++i;
        }
    }

    public void purge(int bucket) throws IOException {
        this.tupleIOs = 0;
        this.pageIOs = 0;
        this.buckets[bucket].purge();
    }

    public ChainedHashTable buildHashTable(int bucket, int keyType, int[] keyIdx, int numAttrs) throws IOException {
        return this.buckets[bucket].buildHashTable(keyType, keyIdx, numAttrs);
    }

    public int getHashLocation(int key) {
        return key % this.tableSize;
    }

    public int getHashLocation(String key) {
        return HashFunc.hash(key, this.tableSize);
    }

    public int getHashLocation(Object[] keys) {
        return HashFunc.hash(keys, this.tableSize);
    }

    public int getPages(int bucket) {
        return this.buckets[bucket].getPages();
    }

    public int getTuples(int bucket) {
        return this.buckets[bucket].getTuples();
    }

    public String getFileName(int bucket) {
        return this.buckets[bucket].getFileName();
    }

    public int insert(Object[] keys, Tuple t) throws IOException {
        this.tupleIOs = 0;
        this.pageIOs = 0;
        int bucket = this.getHashLocation(keys);
        if (!this.buckets[bucket].add(t)) {
            return -1;
        }
        return bucket;
    }

    public int insert(String key, Tuple t) throws IOException {
        this.tupleIOs = 0;
        this.pageIOs = 0;
        int bucket = this.getHashLocation(key);
        if (!this.buckets[bucket].add(t)) {
            return -1;
        }
        return bucket;
    }

    public int insert(int key, Tuple t) throws IOException {
        this.tupleIOs = 0;
        this.pageIOs = 0;
        int bucket = this.getHashLocation(key);
        if (!this.buckets[bucket].add(t)) {
            return -1;
        }
        return bucket;
    }

    public LinkedList getList(int bucket) {
        return this.buckets[bucket].getList();
    }

    public void setBucketState(int bucket, int state) {
        this.buckets[bucket].setState(state);
    }

    public void initBucket(int bucket, int state) throws IOException {
        this.buckets[bucket].init(state);
    }

    public ArrayList probeHashTable(int bucket, int key) {
        return this.buckets[bucket].probeHashTable(key);
    }

    public ArrayList probeHashTable(int bucket, String key) {
        return this.buckets[bucket].probeHashTable(key);
    }

    public ArrayList probeHashTable(int bucket, Object[] key) {
        return this.buckets[bucket].probeHashTable(key);
    }

    public ChainedHashTable getHashTable(int bucket) {
        return this.buckets[bucket].hashTable;
    }

    public String toString() {
        String st = "";
        int i = 0;
        while (i < this.tableSize) {
            st = String.valueOf(st) + "Contents of bucket " + i + " # tuples: " + this.buckets[i].getTuples() + " \n" + this.buckets[i] + "\n";
            ++i;
        }
        return st;
    }

    private class HashBucket {
        private LinkedList pages;
        private int state = IS_EMPTY;
        private int tupCnt = 0;
        private int pageCnt = 0;
        private int resPageCnt = 0;
        private String fileName = "";
        private BufferedOutputStream outFile = null;
        private int num;
        private ChainedHashTable hashTable;

        public HashBucket(int n) {
            this.pages = new LinkedList();
            this.num = n;
            this.hashTable = null;
        }

        public int getState() {
            return this.state;
        }

        public void setState(int s) {
            this.state = s;
        }

        public int getPages() {
            return this.pageCnt;
        }

        public int getTuples() {
            return this.tupCnt;
        }

        public String getFileName() {
            return this.fileName;
        }

        public LinkedList getList() {
            return this.pages;
        }

        public void clear() {
            this.pages.clear();
            this.tupCnt = 0;
            this.pageCnt = 0;
            this.resPageCnt = 0;
            this.state = IS_EMPTY;
            if (!this.fileName.equals("")) {
                FileManager.deleteFile(this.fileName);
            }
        }

        public void flush() throws IOException {
            ListIterator it = this.pages.listIterator(0);
            while (it.hasNext()) {
                Page p = (Page)it.next();
                p.write(this.outFile);
                PageHashTable pageHashTable = PageHashTable.this;
                pageHashTable.pageIOs = pageHashTable.pageIOs + 1;
                PageHashTable pageHashTable2 = PageHashTable.this;
                pageHashTable2.tupleIOs = pageHashTable2.tupleIOs + p.getTupleCount();
            }
            this.pages.clear();
            this.resPageCnt = 0;
        }

        public void close() throws IOException {
            this.flush();
            FileManager.closeFile(this.outFile);
        }

        public void purge() throws IOException {
            this.fileName = FileManager.createTempFileName("bucket_" + this.num);
            this.outFile = FileManager.openOutputFile(this.fileName);
            if (this.pages.size() >= 1) {
                Page lastP = (Page)this.pages.getLast();
                PageHashTable.this.usedPages = PageHashTable.this.usedPages - this.resPageCnt - 1;
                ListIterator it = this.pages.listIterator(0);
                while (it.hasNext()) {
                    Page p = (Page)it.next();
                    if (p == lastP) break;
                    p.write(this.outFile);
                    PageHashTable pageHashTable = PageHashTable.this;
                    pageHashTable.pageIOs = pageHashTable.pageIOs + 1;
                    PageHashTable pageHashTable2 = PageHashTable.this;
                    pageHashTable2.tupleIOs = pageHashTable2.tupleIOs + p.getTupleCount();
                }
                this.pages.clear();
                this.pages.add(lastP);
            } else {
                Page p = new Page(PageHashTable.this.pageSize, PageHashTable.this.relation);
                this.pages.add(p);
                PageHashTable pageHashTable = PageHashTable.this;
                pageHashTable.usedPages = pageHashTable.usedPages + 1;
                this.pageCnt = 1;
            }
            this.resPageCnt = 1;
            this.state = IS_FROZEN;
        }

        public void init(int st) throws IOException {
            this.fileName = FileManager.createTempFileName("bucket_" + this.num);
            this.outFile = FileManager.openOutputFile(this.fileName);
            this.state = st;
            if (this.state == IS_FROZEN) {
                Page p = new Page(PageHashTable.this.pageSize, PageHashTable.this.relation);
                this.pages.addLast(p);
                this.pageCnt = 1;
                this.resPageCnt = 1;
                PageHashTable pageHashTable = PageHashTable.this;
                pageHashTable.usedPages = pageHashTable.usedPages + 1;
            }
        }

        public boolean add(Tuple t) throws IOException {
            Page p = null;
            boolean mustPurge = false;
            if (this.state == IS_EMPTY) {
                p = new Page(PageHashTable.this.pageSize, PageHashTable.this.relation);
                this.pages.addLast(p);
                this.pageCnt = 1;
                this.resPageCnt = 1;
                PageHashTable pageHashTable = PageHashTable.this;
                pageHashTable.usedPages = pageHashTable.usedPages + 1;
                this.state = IS_EXPANDING;
            } else if (this.state == IS_FROZEN) {
                p = (Page)this.pages.getLast();
                if (!p.hasSpace()) {
                    PageHashTable pageHashTable = PageHashTable.this;
                    pageHashTable.pageIOs = pageHashTable.pageIOs + 1;
                    PageHashTable pageHashTable2 = PageHashTable.this;
                    pageHashTable2.tupleIOs = pageHashTable2.tupleIOs + p.getTupleCount();
                    p.flush(this.outFile);
                }
            } else if (this.state == IS_EXPANDING) {
                p = (Page)this.pages.getLast();
                if (!p.hasSpace()) {
                    p = new Page(PageHashTable.this.pageSize, PageHashTable.this.relation);
                    this.pages.addLast(p);
                    ++this.pageCnt;
                    ++this.resPageCnt;
                    PageHashTable pageHashTable = PageHashTable.this;
                    pageHashTable.usedPages = pageHashTable.usedPages + 1;
                }
                if (PageHashTable.this.usedPages >= PageHashTable.this.maxPages) {
                    mustPurge = true;
                }
            }
            p.addTuple(t);
            ++this.tupCnt;
            return mustPurge;
        }

        public ChainedHashTable buildHashTable(int keyType, int[] keyIdx, int numAttrs) {
            this.hashTable = new ChainedHashTable(this.tupCnt);
            if (this.state == IS_EMPTY) {
                return this.hashTable;
            }
            ListIterator it = this.pages.listIterator(0);
            while (it.hasNext()) {
                Page p = (Page)it.next();
                int j = 0;
                while (j < p.getTupleCount()) {
                    Tuple t = p.getTuple(j);
                    if (keyType == 1) {
                        this.hashTable.insert(t.getInt(keyIdx[0]), (Object)t);
                    } else if (keyType == 2) {
                        this.hashTable.insert(t.getString(keyIdx[0]), (Object)t);
                    } else {
                        Object[] vals = new Object[numAttrs];
                        int k = 0;
                        while (k < numAttrs) {
                            vals[k] = t.getObject(keyIdx[k]);
                            ++k;
                        }
                        this.hashTable.insert(vals, (Object)t);
                    }
                    ++j;
                }
            }
            this.pages.clear();
            return this.hashTable;
        }

        public ArrayList probeHashTable(int key) {
            return this.hashTable.find(key);
        }

        public ArrayList probeHashTable(String key) {
            return this.hashTable.find(key);
        }

        public ArrayList probeHashTable(Object[] key) {
            return this.hashTable.find(key);
        }

        public String toString() {
            String st = "";
            int i = 0;
            ListIterator it = this.pages.listIterator(0);
            while (it.hasNext()) {
                Page p = (Page)it.next();
                st = String.valueOf(st) + "Page " + i + ":\n" + p.toString() + "\n";
                ++i;
            }
            return st;
        }
    }
}

