/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.IOException;
import java.sql.SQLException;
import unity.operators.Operator;
import unity.predicates.SelectionPredicate;
import unity.relational.Tuple;

public class Selection
extends Operator {
    protected SelectionPredicate predicate;
    private Operator input;

    public Selection(Operator in, SelectionPredicate p) {
        super(new Operator[]{in}, 0, 0);
        this.input = in;
        this.predicate = p;
        this.setOutputRelation(this.input.getOutputRelation());
    }

    public void init() throws IOException {
        this.input.init();
    }

    public Tuple next() throws IOException {
        try {
            Tuple inTuple;
            while ((inTuple = this.input.next()) != null) {
                this.incrementTuplesRead();
                if (!this.predicate.evaluate(inTuple)) continue;
                this.incrementTuplesOutput();
                return inTuple;
            }
        }
        catch (SQLException e) {
            throw new IOException("Predicate evaluation error: " + e);
        }
        return null;
    }

    public void close() throws IOException {
        super.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("SELECT: ");
        sb.append(this.predicate.toString(this.outputRelation));
        return sb.toString();
    }
}

