/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import unity.io.FileManager;
import unity.operators.Operator;
import unity.relational.Relation;
import unity.relational.Tuple;

public class TextFileScan
extends Operator {
    protected String inFileName;
    protected BufferedReader inFile;
    protected Relation inputRelation;

    public TextFileScan(String inName, Relation r) {
        this.inFileName = inName;
        this.inputRelation = r;
        this.setOutputRelation(r);
    }

    public void init() throws FileNotFoundException, IOException {
        this.inFile = FileManager.openTextInputFile(this.inFileName);
    }

    public Tuple next() throws IOException {
        Tuple t = new Tuple(this.inputRelation);
        if (!t.readText(this.inFile)) {
            return null;
        }
        this.incrementTuplesRead();
        this.incrementTuplesOutput();
        return t;
    }

    public boolean hasNext() throws IOException {
        return this.inFile.ready();
    }

    public void close() throws IOException {
        FileManager.closeFile(this.inFile);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(250);
        sb.append("TEXT FILE SCAN: (FileName=" + this.inFileName + ")");
        return sb.toString();
    }
}

