/*
 * Decompiled with CFR 0.152.
 */
package unity.relational;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.functions.F_Cast;
import unity.util.Convert;

public class Attribute {
    private String name;
    private int type;
    private int length;
    private Object reference;
    public static int TYPE_SMALLINT = 5;
    public static int TYPE_INT = 4;
    public static int TYPE_FLOAT = 6;
    public static int TYPE_DECIMAL = 3;
    public static int TYPE_DOUBLE = 8;
    public static int TYPE_CHAR = 1;
    public static int TYPE_STRING = 12;
    public static int TYPE_BLOB = 2004;
    public static int TYPE_DATE = 91;
    public static int TYPE_TIMESTAMP = 93;
    public static int TYPE_TIME = 92;
    public static int TYPE_NUMBER = 99999;
    public static int TYPE_SOURCEREF = 100000;

    public Attribute() {
        this.name = "";
        this.type = 0;
    }

    public Attribute(Attribute a) {
        this.name = a.name;
        this.type = a.type;
        this.length = a.length;
        this.reference = a.reference;
    }

    public Attribute(String n, int t, int l) {
        this.name = n;
        this.type = t;
        this.length = l;
    }

    public Attribute(String n, int t, int l, Object ref) {
        this.name = n;
        this.type = t;
        this.length = l;
        this.reference = ref;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String st) {
        this.name = st;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int t) {
        this.type = t;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int l) {
        this.length = l;
    }

    public void setReference(Object ref) {
        this.reference = ref;
    }

    public Object getReference() {
        return this.reference;
    }

    public static Object read(BufferedInputStream in, int attrType) throws IOException {
        byte[] tmp = new byte[1000];
        if (attrType == TYPE_INT) {
            in.read(tmp, 0, 4);
            return new Integer(Convert.toInt(tmp));
        }
        if (attrType == TYPE_SMALLINT) {
            in.read(tmp, 0, 4);
            return new Short(Convert.toShort(tmp));
        }
        if (attrType == TYPE_DECIMAL) {
            byte len = (byte)in.read();
            in.read(tmp, 0, len);
            tmp[len] = 0;
            return Convert.toBigDecimal(tmp, len);
        }
        if (attrType == TYPE_STRING || attrType == TYPE_CHAR) {
            byte len = (byte)in.read();
            in.read(tmp, 0, len);
            tmp[len] = 0;
            return Convert.toString(tmp, len);
        }
        if (attrType == TYPE_TIMESTAMP) {
            byte len = (byte)in.read();
            in.read(tmp, 0, len);
            tmp[len] = 0;
            return Timestamp.valueOf(Convert.toString(tmp, len));
        }
        return null;
    }

    public static Object read(RandomAccessFile in, int attrType) throws IOException {
        byte[] tmp = new byte[1000];
        if (attrType == TYPE_INT) {
            in.read(tmp, 0, 4);
            return new Integer(Convert.toInt(tmp));
        }
        if (attrType == TYPE_SMALLINT) {
            in.read(tmp, 0, 4);
            return new Short(Convert.toShort(tmp));
        }
        if (attrType == TYPE_DECIMAL) {
            byte len = (byte)in.read();
            in.read(tmp, 0, len);
            tmp[len] = 0;
            return Convert.toBigDecimal(tmp, len);
        }
        if (attrType == TYPE_STRING || attrType == TYPE_CHAR) {
            byte len = (byte)in.read();
            in.read(tmp, 0, len);
            tmp[len] = 0;
            return Convert.toString(tmp, len);
        }
        if (attrType == TYPE_TIMESTAMP) {
            byte len = (byte)in.read();
            in.read(tmp, 0, len);
            tmp[len] = 0;
            return Timestamp.valueOf(Convert.toString(tmp, len));
        }
        return null;
    }

    public static void write(BufferedOutputStream out, int attrType, Object obj) throws IOException {
        byte[] raw = null;
        if (attrType == TYPE_INT) {
            raw = Convert.toByte((Integer)obj);
        } else if (attrType == TYPE_SMALLINT) {
            raw = Convert.toByte(((Short)obj).intValue());
        } else if (attrType == TYPE_DECIMAL) {
            raw = Convert.toByte(((BigDecimal)obj).toString());
            out.write(raw.length);
        } else if (attrType == TYPE_STRING || attrType == TYPE_CHAR) {
            raw = Convert.toByte((String)obj);
            out.write(raw.length);
        } else if (attrType == TYPE_DATE) {
            System.out.println("Date type.");
        } else if (attrType == TYPE_TIMESTAMP) {
            raw = Convert.toByte(obj.toString());
            out.write(raw.length);
        }
        if (raw == null) {
            System.out.println("Type: " + attrType + " Data: " + obj);
        }
        out.write(raw, 0, raw.length);
    }

    public static void write(RandomAccessFile out, int attrType, Object obj) throws IOException {
        byte[] raw = null;
        if (attrType == TYPE_INT) {
            raw = Convert.toByte((Integer)obj);
        } else if (attrType == TYPE_SMALLINT) {
            raw = Convert.toByte(((Short)obj).intValue());
        } else if (attrType == TYPE_DECIMAL) {
            raw = Convert.toByte(((BigDecimal)obj).toString());
            out.write(raw.length);
        } else if (attrType == TYPE_STRING || attrType == TYPE_CHAR) {
            raw = Convert.toByte((String)obj);
            out.write(raw.length);
        } else if (attrType == TYPE_DATE) {
            System.out.println("Date type.");
        } else if (attrType == TYPE_TIMESTAMP) {
            raw = Convert.toByte(obj.toString());
            out.write(raw.length);
        }
        if (raw == null) {
            System.out.println("Type: " + attrType + " Data: " + obj);
        }
        out.write(raw, 0, raw.length);
    }

    public static int getByteSize(int attrType, Object obj) {
        if (attrType == TYPE_INT) {
            return 4;
        }
        if (attrType == TYPE_SMALLINT) {
            return 2;
        }
        if (attrType == TYPE_DECIMAL) {
            return ((BigDecimal)obj).toString().length() + 1;
        }
        if (attrType == TYPE_STRING) {
            return ((String)obj).length() + 1;
        }
        String st = obj.toString();
        return st.length() + 1;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.type + "(" + this.length + ")" + this.reference;
    }

    public String outputString() {
        return String.valueOf(this.name) + ":" + this.type + "(" + this.length + ")" + this.reference;
    }

    public String getTypeName() {
        return Attribute.getTypeName(this.type);
    }

    public static boolean isStringType(int type) {
        return type == TYPE_STRING || type == TYPE_CHAR;
    }

    public static boolean isDoubleType(int type) {
        return type == TYPE_DOUBLE || type == TYPE_FLOAT;
    }

    public static boolean isNumberType(int type) {
        return type == TYPE_INT || type == TYPE_DOUBLE || type == TYPE_FLOAT || type == TYPE_NUMBER || type == TYPE_SMALLINT || type == TYPE_DECIMAL;
    }

    public static String getTypeName(int type) {
        if (type == TYPE_INT) {
            return "integer";
        }
        if (type == TYPE_STRING) {
            return "varchar";
        }
        if (type == TYPE_FLOAT) {
            return "float";
        }
        if (type == TYPE_DECIMAL) {
            return "decimal";
        }
        if (type == TYPE_SMALLINT) {
            return "smallint";
        }
        if (type == TYPE_DOUBLE) {
            return "double";
        }
        if (type == TYPE_CHAR) {
            return "char";
        }
        if (type == TYPE_BLOB) {
            return "blob";
        }
        if (type == TYPE_DATE) {
            return "date";
        }
        if (type == TYPE_TIMESTAMP) {
            return "timestamp";
        }
        return "(unknown)";
    }

    public static Attribute unionCompatible(Attribute leftAttr, Attribute rightAttr, boolean[] flags, Expression[] expr, int index) throws SQLException {
        int rightType = rightAttr.getType();
        int leftType = leftAttr.getType();
        flags[0] = false;
        flags[1] = false;
        if (leftType == rightType) {
            return leftAttr;
        }
        if (leftType == TYPE_STRING || rightType == TYPE_STRING) {
            if (leftType == TYPE_STRING) {
                flags[1] = true;
                expr[1] = new F_Cast((Expression)new ExtractAttribute(index, rightType), rightType, TYPE_STRING);
                return leftAttr;
            }
            flags[0] = true;
            expr[0] = new F_Cast((Expression)new ExtractAttribute(index, leftType), leftType, TYPE_STRING);
            return rightAttr;
        }
        if (leftAttr.getType() != rightAttr.getType()) {
            throw new SQLException("Relations are not union-compatible because type of left attribute: " + leftAttr.getName() + " (type: " + leftAttr.getTypeName() + ") does not match right attribute: " + rightAttr.getName() + " (type: " + rightAttr.getTypeName() + ")");
        }
        return null;
    }
}

