/*
 * Decompiled with CFR 0.152.
 */
package unity.relational;

import java.sql.SQLException;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.operators.ProjectionList;
import unity.query.GQFieldRef;
import unity.relational.Attribute;

public class Relation {
    private Attribute[] attributes;

    public Relation() {
        this.attributes = null;
    }

    public Relation(Attribute[] attrs) {
        this.attributes = attrs;
    }

    public Relation(Relation r) {
        this.attributes = new Attribute[r.attributes.length];
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i] = new Attribute(r.attributes[i]);
            ++i;
        }
    }

    public int getAttributeType(int index) {
        return this.attributes[index].getType();
    }

    public void setAttributeType(int i, int type) {
        this.attributes[i].setType(type);
    }

    public int getNumAttributes() {
        return this.attributes.length;
    }

    public Attribute getAttribute(int index) {
        return this.attributes[index];
    }

    public void setAttribute(int index, Attribute a) {
        this.attributes[index] = a;
    }

    public int getAttributeIndex(String name) {
        int i = 0;
        while (i < this.attributes.length) {
            if (((GQFieldRef)this.attributes[i].getReference()).getLocalName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getAttributeIndexByName(String name) {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getAttributeIndexbyFullName(String name) {
        int i = 0;
        while (i < this.attributes.length) {
            if (((GQFieldRef)this.attributes[i].getReference()).getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getAttributeIndex(Object ref) {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].getReference() == ref) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void mergeRelation(Relation r) {
        if (this.attributes == null) {
            this.attributes = new Attribute[r.attributes.length];
            int i = 0;
            while (i < r.attributes.length) {
                this.attributes[i] = r.attributes[i];
                ++i;
            }
        } else {
            int len = this.attributes.length + r.attributes.length;
            Attribute[] attr = new Attribute[len];
            int i = 0;
            while (i < this.attributes.length) {
                attr[i] = this.attributes[i];
                ++i;
            }
            i = this.attributes.length;
            while (i < len) {
                attr[i] = r.attributes[i - this.attributes.length];
                ++i;
            }
            this.attributes = attr;
        }
    }

    public Relation projectRelation(ProjectionList plist) {
        Attribute[] attrs = new Attribute[plist.getNumAttributes()];
        int i = 0;
        while (i < attrs.length) {
            attrs[i] = new Attribute(this.getAttribute(plist.getIndex(i)));
            ++i;
        }
        if (plist.performRename()) {
            i = 0;
            while (i < attrs.length) {
                attrs[i].setName(plist.getName(i));
                ++i;
            }
        }
        return new Relation(attrs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.attributes.length) {
            sb.append(this.attributes[i].toString());
            sb.append(" ");
            ++i;
        }
        return sb.toString();
    }

    public static Relation unionCompatible(Relation leftRelation, Relation rightRelation, Expression[] exprConvertLeft, Expression[] exprConvertRight, boolean[] flags) throws SQLException {
        if (leftRelation.getNumAttributes() != rightRelation.getNumAttributes()) {
            throw new SQLException("Relations are not union-compatible because they do not have the same number of attributes.");
        }
        flags[0] = false;
        flags[1] = false;
        Expression[] expr = new Expression[2];
        boolean[] attrFlag = new boolean[2];
        Relation outputRelation = new Relation(leftRelation);
        int i = 0;
        while (i < leftRelation.getNumAttributes()) {
            int j;
            Attribute leftAttr = leftRelation.getAttribute(i);
            Attribute rightAttr = rightRelation.getAttribute(i);
            Attribute outputAttribute = Attribute.unionCompatible(leftAttr, rightAttr, attrFlag, expr, i);
            if (flags[0] || attrFlag[0]) {
                if (!flags[0]) {
                    flags[0] = true;
                    j = 0;
                    while (j < i) {
                        exprConvertLeft[j] = new ExtractAttribute(j, outputAttribute.getType());
                        ++j;
                    }
                }
                if (attrFlag[0]) {
                    leftRelation.setAttributeType(i, outputAttribute.getType());
                    exprConvertLeft[i] = expr[0];
                } else {
                    exprConvertLeft[i] = new ExtractAttribute(i, outputAttribute.getType());
                }
            }
            if (flags[1] || attrFlag[1]) {
                if (!flags[1]) {
                    flags[1] = true;
                    j = 0;
                    while (j < i) {
                        exprConvertRight[j] = new ExtractAttribute(j, outputAttribute.getType());
                        ++j;
                    }
                }
                if (attrFlag[1]) {
                    rightRelation.setAttributeType(i, outputAttribute.getType());
                    exprConvertRight[i] = expr[1];
                } else {
                    exprConvertRight[i] = new ExtractAttribute(i, outputAttribute.getType());
                }
            }
            outputRelation.setAttribute(i, outputAttribute);
            ++i;
        }
        return outputRelation;
    }
}

