/*
 * Decompiled with CFR 0.152.
 */
package unity.relational;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import unity.relational.Relation;
import unity.relational.Tuple;
import unity.util.Convert;

public class TupleXJoin
extends Tuple {
    private int arrivalTimestamp;
    private int departureTimestamp;

    public TupleXJoin(Relation r) {
        super(r);
        this.arrivalTimestamp = 0;
        this.departureTimestamp = 0;
    }

    public TupleXJoin(Object[] vals, Relation r, int TS) {
        super(vals, r);
        this.arrivalTimestamp = TS;
        this.departureTimestamp = 0;
    }

    public TupleXJoin(Tuple t, int ATS, int DTS) {
        super(t.relation);
        this.values = t.values;
        this.arrivalTimestamp = ATS;
        this.departureTimestamp = DTS;
    }

    public TupleXJoin(TupleXJoin t) {
        super(t);
        this.arrivalTimestamp = t.arrivalTimestamp;
        this.departureTimestamp = t.departureTimestamp;
    }

    public int getArrivalTimestamp() {
        return this.arrivalTimestamp;
    }

    public void setArrivalTimestamp(int TS) {
        this.arrivalTimestamp = TS;
    }

    public int getDepartureTimestamp() {
        return this.departureTimestamp;
    }

    public void setDepartureTimestamp(int TS) {
        this.departureTimestamp = TS;
    }

    public boolean read(BufferedInputStream in) throws IOException {
        byte[] tmp = new byte[4];
        if (in.read(tmp, 0, 4) == -1) {
            return false;
        }
        this.arrivalTimestamp = Convert.toInt(tmp);
        in.read(tmp, 0, 4);
        this.departureTimestamp = Convert.toInt(tmp);
        return super.read(in);
    }

    public void write(BufferedOutputStream out) throws IOException {
        out.write(Convert.toByte(this.arrivalTimestamp));
        out.write(Convert.toByte(this.departureTimestamp));
        super.write(out);
    }

    public String toString() {
        String st = "ATS: " + this.arrivalTimestamp + "\tDTS: " + this.departureTimestamp + "\tTuple: " + super.toString();
        return st;
    }
}

