/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class Reflection {
    public static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public static String[] getClassesInJar(String jarName, String packageName) throws FileNotFoundException, IOException, ClassNotFoundException {
        JarEntry jarEntry;
        ArrayList<String> classes = new ArrayList<String>();
        packageName = packageName.replaceAll("\\.", "/");
        JarInputStream jarFile = new JarInputStream(new FileInputStream(jarName));
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            if (!jarEntry.getName().startsWith(packageName) || !jarEntry.getName().endsWith(".class")) continue;
            String className = jarEntry.getName().replaceAll("/", "\\.");
            className = className.substring(0, className.length() - 6);
            classes.add(className);
        }
        String[] output = new String[classes.size()];
        classes.toArray(output);
        return output;
    }

    public static Class[] getClasses(String pckgname) throws ClassNotFoundException {
        String path = pckgname.replace('.', '/');
        URL resource = classLoader.getResource(path);
        if (resource == null) {
            throw new ClassNotFoundException("No resource for " + path);
        }
        return Reflection.getClasses(pckgname, resource);
    }

    public static Class[] getClasses(String pckgname, URL resource) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        File directory = null;
        try {
            directory = new File(resource.getFile());
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(String.valueOf(pckgname) + " (" + directory + ") does not appear to be a valid package.");
        }
        if (directory.exists()) {
            String[] files = directory.list();
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    classes.add(Class.forName(String.valueOf(pckgname) + '.' + files[i].substring(0, files[i].length() - 6)));
                }
                ++i;
            }
        } else {
            throw new ClassNotFoundException(String.valueOf(pckgname) + " does not appear to be a valid package");
        }
        Class[] classesA = new Class[classes.size()];
        classes.toArray(classesA);
        return classesA;
    }
}

