/*
 * Decompiled with CFR 0.152.
 */
package unity.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import unity.util.CryptoModule;
import unity.util.VerifySystem;

public class Register {
    private static int numRegistrations;
    private static int numLicenses;
    private static String userName;
    private static String companyName;
    private static String userEmail;

    public static void main(String[] args) {
        boolean textVersion = true;
        if (args.length > 0) {
            textVersion = true;
        }
        String dateString = null;
        String keyVal = null;
        String systemId = null;
        if (textVersion) {
            System.out.println("Retrieving system information...");
            systemId = VerifySystem.getSystemId();
            System.out.print("Enter registration key: ");
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                keyVal = reader.readLine();
                System.out.println("Contacting registration server...");
                int code = Register.verifyKey(keyVal, systemId);
                if (code == 0) {
                    System.out.println("Key is valid.  Completing registration...");
                } else {
                    if (code == 1) {
                        System.out.println("Invalid key entered.");
                    } else if (code == 2) {
                        System.out.println("Valid key entered BUT the key has been used to register " + numRegistrations + " times but only " + numLicenses + " were paid for.");
                    } else if (code == 3) {
                        System.out.println("Error with the registration system.  Try again later.");
                    }
                    System.out.println("UnityJDBC has not been registered.");
                    System.exit(1);
                }
                CryptoModule cm = new CryptoModule();
                if (userName.equals("TRIAL")) {
                    if (Register.FileExistsinJar("t.class")) {
                        String expiryDate = VerifySystem.getExpiryDate();
                        if (expiryDate.equals("0")) {
                            System.out.println("UnityJDBC has already been registered as a full version.");
                        } else {
                            System.out.println("UnityJDBC has already been registered for a 30-day trial.");
                            System.out.println("Trial period ends on: " + expiryDate);
                        }
                        System.exit(1);
                    }
                    GregorianCalendar expirationDate = new GregorianCalendar();
                    expirationDate.add(5, 30);
                    DateFormat format = DateFormat.getDateInstance();
                    dateString = format.format(expirationDate.getTime());
                    Register.CreateKeyFile("s.class", cm.encrypt(systemId), cm);
                    Register.CreateKeyFile("k.class", cm.encrypt(keyVal), cm);
                    Register.CreateKeyFile("t.class", cm.encrypt(dateString), cm);
                    if (!Register.EmbedIntoJar("k.class", "s.class", "t.class")) {
                        System.out.println("Failed to register JAR for trial.");
                        System.exit(1);
                    }
                    System.out.println("Your system has been configured for a 30-day trial.");
                    System.out.println("Your trial period ends on: " + dateString);
                } else {
                    Register.CreateKeyFile("s.class", cm.encrypt(systemId), cm);
                    Register.CreateKeyFile("k.class", cm.encrypt(keyVal), cm);
                    String tFileName = null;
                    if (Register.FileExistsinJar("t.class")) {
                        Register.CreateKeyFile("t.class", cm.encrypt("0"), cm);
                        tFileName = "t.class";
                    }
                    if (!Register.EmbedIntoJar("k.class", "s.class", tFileName)) {
                        System.out.println("Failed to register JAR.");
                        System.exit(1);
                    }
                    System.out.println("UnityJDBC has been successfully registered for this machine with user information: ");
                    System.out.println("User: " + userName);
                    System.out.println("Company: " + companyName);
                    System.out.println("Email: " + userEmail);
                    System.out.println("Key: " + keyVal);
                    System.out.println("# of registrations: " + numRegistrations);
                    System.out.println("# of paid licenses: " + numLicenses);
                    System.out.println("System Id: " + systemId);
                }
            }
            catch (IOException e) {
                System.out.println("IO Exception: " + e);
                System.out.println("UnityJDBC has not been registered.");
                System.exit(1);
            }
        }
    }

    private static int verifyKey(String keyVal, String systemId) throws IOException {
        String urlText = "http://www.unityjdbc.com/_regkey.jsp?keyval=" + keyVal + "&sysid=" + systemId;
        URL url = new URL(urlText);
        URLConnection conn = url.openConnection();
        conn.connect();
        InputStream in = conn.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        int code = Integer.parseInt(reader.readLine());
        if (code != 0) {
            return code;
        }
        userName = reader.readLine();
        companyName = reader.readLine();
        userEmail = reader.readLine();
        numRegistrations = Integer.parseInt(reader.readLine());
        numLicenses = Integer.parseInt(reader.readLine());
        return code;
    }

    private static void CreateKeyFile(String EncFile_Name, String EncryptedVal, CryptoModule cm) throws FileNotFoundException, NullPointerException, IOException {
        FileOutputStream dos = new FileOutputStream(new File(EncFile_Name));
        OutputStreamWriter dosw = new OutputStreamWriter((OutputStream)dos, cm.getOutCharset());
        dosw.write(EncryptedVal);
        dosw.close();
    }

    private static boolean EmbedIntoJar(String KeyFile, String MACFile, String TrialFile) throws IOException {
        try {
            if (TrialFile != null) {
                Runtime.getRuntime().exec("jar uf UnityJDBC.jar " + KeyFile + " " + MACFile + " " + TrialFile, null);
            } else {
                Runtime.getRuntime().exec("jar uf UnityJDBC.jar " + KeyFile + " " + MACFile, null, null);
            }
            return true;
        }
        catch (Exception ex) {
            try {
                File jarFileCurDir = new File("jar.exe");
                if (jarFileCurDir.exists()) {
                    if (TrialFile != null) {
                        Runtime.getRuntime().exec(".\\jar.exe uf UnityJDBC.jar " + KeyFile + " " + MACFile + " " + TrialFile, null);
                    } else {
                        Runtime.getRuntime().exec(".\\jar.exe uf UnityJDBC.jar " + KeyFile + " " + MACFile, null, null);
                    }
                    return true;
                }
            }
            catch (Exception e) {
                System.out.println("Cannot find jar program.  Make sure it is in your path.");
                return false;
            }
            return false;
        }
    }

    private static boolean FileExistsinJar(String name) {
        return VerifySystem.FileExistsinJar(name);
    }
}

