/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.xinclude;

import com.sun.org.apache.xerces.internal.impl.Constants;
import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.io.MalformedByteSequenceException;
import com.sun.org.apache.xerces.internal.util.AugmentationsImpl;
import com.sun.org.apache.xerces.internal.util.IntStack;
import com.sun.org.apache.xerces.internal.util.ParserConfigurationSettings;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.URI;
import com.sun.org.apache.xerces.internal.util.XMLAttributesImpl;
import com.sun.org.apache.xerces.internal.util.XMLResourceIdentifierImpl;
import com.sun.org.apache.xerces.internal.util.XMLSymbols;
import com.sun.org.apache.xerces.internal.xinclude.ObjectFactory;
import com.sun.org.apache.xerces.internal.xinclude.XInclude11TextReader;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeInputSource;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeMessageFormatter;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeNamespaceSupport;
import com.sun.org.apache.xerces.internal.xinclude.XIncludeTextReader;
import com.sun.org.apache.xerces.internal.xinclude.XPointerFramework;
import com.sun.org.apache.xerces.internal.xinclude.XPointerSchema;
import com.sun.org.apache.xerces.internal.xni.Augmentations;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.QName;
import com.sun.org.apache.xerces.internal.xni.XMLAttributes;
import com.sun.org.apache.xerces.internal.xni.XMLDTDHandler;
import com.sun.org.apache.xerces.internal.xni.XMLDocumentHandler;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XMLResourceIdentifier;
import com.sun.org.apache.xerces.internal.xni.XMLString;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDTDFilter;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDTDSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentFilter;
import com.sun.org.apache.xerces.internal.xni.parser.XMLDocumentSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLEntityResolver;
import com.sun.org.apache.xerces.internal.xni.parser.XMLInputSource;
import com.sun.org.apache.xerces.internal.xni.parser.XMLParserConfiguration;
import java.io.CharConversionException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class XIncludeHandler
implements XMLComponent,
XMLDocumentFilter,
XMLDTDFilter {
    public static final String XPOINTER_DEFAULT_CONFIGURATION = "com.sun.org.apache.xerces.internal.parsers.XPointerParserConfiguration";
    protected static final String XPOINTER_SCHEMA = "http://apache.org/xml/properties/xpointer-schema";
    protected static final String XINCLUDE_AWARE = "http://apache.org/xml/features/xinclude-aware";
    public static final String XINCLUDE_DEFAULT_CONFIGURATION = "com.sun.org.apache.xerces.internal.parsers.XIncludeParserConfiguration";
    public static final String HTTP_ACCEPT = "Accept";
    public static final String HTTP_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HTTP_ACCEPT_CHARSET = "Accept-Charset";
    public static final String XPOINTER = "xpointer";
    public static final String XINCLUDE_NS_URI = "http://www.w3.org/2001/XInclude".intern();
    public static final String XINCLUDE_INCLUDE = "include".intern();
    public static final String XINCLUDE_FALLBACK = "fallback".intern();
    public static final String XINCLUDE_PARSE_XML = "xml".intern();
    public static final String XINCLUDE_PARSE_TEXT = "text".intern();
    public static final String XINCLUDE_ATTR_HREF = "href".intern();
    public static final String XINCLUDE_ATTR_PARSE = "parse".intern();
    public static final String XINCLUDE_ATTR_ENCODING = "encoding".intern();
    public static final String XINCLUDE_ATTR_ACCEPT = "accept".intern();
    public static final String XINCLUDE_ATTR_ACCEPT_LANGUAGE = "accept-language".intern();
    public static final String XINCLUDE_ATTR_ACCEPT_CHARSET = "accept-charset".intern();
    public static final String XINCLUDE_INCLUDED = "[included]".intern();
    public static final String CURRENT_BASE_URI = "currentBaseURI";
    public static final String XINCLUDE_BASE = "base";
    public static final QName XML_BASE_QNAME = new QName(XMLSymbols.PREFIX_XML, "base", XMLSymbols.PREFIX_XML + ":" + "base", NamespaceContext.XML_URI);
    public static final QName NEW_NS_ATTR_QNAME = new QName(XMLSymbols.PREFIX_XMLNS, "", XMLSymbols.PREFIX_XMLNS + ":", NamespaceContext.XMLNS_URI);
    private static final int STATE_NORMAL_PROCESSING = 1;
    private static final int STATE_IGNORE = 2;
    private static final int STATE_EXPECT_FALLBACK = 3;
    protected static final String ALLOW_UE_AND_NOTATION_EVENTS = "http://xml.org/sax/features/allow-dtd-events-after-endDTD";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/allow-dtd-events-after-endDTD"};
    private static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{Boolean.TRUE};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/xpointer-schema"};
    private static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null};
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected XPointerFramework fXPointerFramework = null;
    protected XPointerSchema[] fXPointerSchema;
    protected XMLDTDHandler fDTDHandler;
    protected XMLDTDSource fDTDSource;
    protected XIncludeHandler fParentXIncludeHandler;
    protected String fParentRelativeURI;
    protected XMLParserConfiguration fChildConfig;
    protected XMLLocator fDocLocation;
    protected XIncludeNamespaceSupport fNamespaceContext;
    protected XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected SecurityManager fSecurityManager;
    protected XMLResourceIdentifier fCurrentBaseURI;
    protected IntStack baseURIScope;
    protected Stack baseURI;
    protected Stack literalSystemID;
    protected Stack expandedSystemID;
    protected ParserConfigurationSettings fSettings;
    private int fDepth = 0;
    private static final int INITIAL_SIZE = 8;
    private boolean[] fSawInclude = new boolean[8];
    private boolean[] fSawFallback = new boolean[8];
    private int[] fState = new int[8];
    private Vector fNotations;
    private Vector fUnparsedEntities;
    private boolean fSendUEAndNotationEvents;
    private boolean fIsXML11;
    private boolean fInDTD;

    public XIncludeHandler() {
        this.fSawFallback[this.fDepth] = false;
        this.fSawInclude[this.fDepth] = false;
        this.fState[this.fDepth] = 1;
        this.fNotations = new Vector();
        this.fUnparsedEntities = new Vector();
        this.baseURIScope = new IntStack();
        this.baseURI = new Stack();
        this.literalSystemID = new Stack();
        this.expandedSystemID = new Stack();
        this.fCurrentBaseURI = new XMLResourceIdentifierImpl();
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        Object object;
        int n;
        this.fNamespaceContext = null;
        this.fDepth = 0;
        this.fNotations = new Vector();
        this.fUnparsedEntities = new Vector();
        this.fParentRelativeURI = null;
        this.fIsXML11 = false;
        this.fInDTD = false;
        this.baseURIScope.clear();
        this.baseURI.clear();
        this.literalSystemID.clear();
        this.expandedSystemID.clear();
        for (n = 0; n < this.fState.length; ++n) {
            this.fState[n] = 1;
        }
        for (n = 0; n < this.fSawFallback.length; ++n) {
            this.fSawFallback[n] = false;
        }
        for (n = 0; n < this.fSawInclude.length; ++n) {
            this.fSawInclude[n] = false;
        }
        try {
            this.fSendUEAndNotationEvents = xMLComponentManager.getFeature(ALLOW_UE_AND_NOTATION_EVENTS);
            if (this.fChildConfig != null) {
                this.fChildConfig.setFeature(ALLOW_UE_AND_NOTATION_EVENTS, this.fSendUEAndNotationEvents);
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        try {
            object = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
            if (object != null) {
                this.setErrorReporter((XMLErrorReporter)object);
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ERROR_REPORTER, object);
                }
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fErrorReporter = null;
        }
        try {
            object = (XMLEntityResolver)xMLComponentManager.getProperty(ENTITY_RESOLVER);
            if (object != null) {
                this.fEntityResolver = object;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(ENTITY_RESOLVER, object);
                }
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fEntityResolver = null;
        }
        try {
            this.fXPointerSchema = (XPointerSchema[])xMLComponentManager.getProperty(XPOINTER_SCHEMA);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fXPointerSchema = null;
        }
        try {
            object = (SecurityManager)xMLComponentManager.getProperty(SECURITY_MANAGER);
            if (object != null) {
                this.fSecurityManager = object;
                if (this.fChildConfig != null) {
                    this.fChildConfig.setProperty(SECURITY_MANAGER, object);
                }
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fSecurityManager = null;
        }
        this.fSettings = new ParserConfigurationSettings();
        this.copyFeatures(xMLComponentManager, this.fSettings);
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (string.equals(ALLOW_UE_AND_NOTATION_EVENTS)) {
            this.fSendUEAndNotationEvents = bl;
        }
        if (this.fSettings != null) {
            this.fSettings.setFeature(string, bl);
        }
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals(ERROR_REPORTER)) {
            this.setErrorReporter((XMLErrorReporter)object);
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(string, object);
            }
        }
        if (string.equals(ENTITY_RESOLVER)) {
            this.fEntityResolver = (XMLEntityResolver)object;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(string, object);
            }
        }
        if (string.equals(SECURITY_MANAGER)) {
            this.fSecurityManager = (SecurityManager)object;
            if (this.fChildConfig != null) {
                this.fChildConfig.setProperty(string, object);
            }
        }
    }

    public Boolean getFeatureDefault(String string) {
        for (int i = 0; i < RECOGNIZED_FEATURES.length; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(string)) continue;
            return FEATURE_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        for (int i = 0; i < RECOGNIZED_PROPERTIES.length; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(string)) continue;
            return PROPERTY_DEFAULTS[i];
        }
        return null;
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        if (this.fErrorReporter != null) {
            this.fErrorReporter.setDocumentLocator(xMLLocator);
        }
        if (!this.isRootDocument() && this.fParentXIncludeHandler.searchForRecursiveIncludes(xMLLocator)) {
            this.reportFatalError("RecursiveInclude", new Object[]{xMLLocator.getExpandedSystemId()});
        }
        if (!(namespaceContext instanceof XIncludeNamespaceSupport)) {
            this.reportFatalError("IncompatibleNamespaceContext");
        }
        this.fNamespaceContext = (XIncludeNamespaceSupport)namespaceContext;
        this.fDocLocation = xMLLocator;
        this.fCurrentBaseURI.setBaseSystemId(xMLLocator.getBaseSystemId());
        this.fCurrentBaseURI.setExpandedSystemId(xMLLocator.getExpandedSystemId());
        this.fCurrentBaseURI.setLiteralSystemId(xMLLocator.getLiteralSystemId());
        this.saveBaseURI();
        if (augmentations == null) {
            augmentations = new AugmentationsImpl();
        }
        augmentations.putItem(CURRENT_BASE_URI, this.fCurrentBaseURI);
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.startDocument(xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fIsXML11 = "1.1".equals(string);
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fInDTD) {
            if (this.fDocumentHandler != null && this.getState() == 1) {
                ++this.fDepth;
                augmentations = this.modifyAugmentations(augmentations);
                this.fDocumentHandler.comment(xMLString, augmentations);
                --this.fDepth;
            }
        } else if (this.fDTDHandler != null) {
            this.fDTDHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.fInDTD) {
            if (this.fDocumentHandler != null && this.getState() == 1) {
                ++this.fDepth;
                augmentations = this.modifyAugmentations(augmentations);
                this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
                --this.fDepth;
            }
        } else if (this.fDTDHandler != null) {
            this.fDTDHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        ++this.fDepth;
        this.setState(this.getState(this.fDepth - 1));
        this.processXMLBaseAttributes(xMLAttributes);
        if (this.isIncludeElement(qName)) {
            boolean bl = this.handleIncludeElement(xMLAttributes);
            if (bl) {
                this.setState(2);
            } else {
                this.setState(3);
            }
        } else if (this.isFallbackElement(qName)) {
            this.handleFallbackElement();
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            augmentations = this.modifyAugmentations(augmentations);
            xMLAttributes = this.processAttributes(xMLAttributes);
            this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        ++this.fDepth;
        this.setState(this.getState(this.fDepth - 1));
        this.processXMLBaseAttributes(xMLAttributes);
        if (this.isIncludeElement(qName)) {
            boolean bl = this.handleIncludeElement(xMLAttributes);
            if (bl) {
                this.setState(2);
            } else {
                this.reportFatalError("NoFallback");
            }
        } else if (this.isFallbackElement(qName)) {
            this.handleFallbackElement();
        } else if (this.hasXIncludeNamespace(qName)) {
            if (this.getSawInclude(this.fDepth - 1)) {
                this.reportFatalError("IncludeChild", new Object[]{qName.rawname});
            }
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            augmentations = this.modifyAugmentations(augmentations);
            xMLAttributes = this.processAttributes(xMLAttributes);
            this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
        }
        this.setSawFallback(this.fDepth + 1, false);
        this.setSawInclude(this.fDepth + 1, false);
        if (this.baseURIScope.size() > 0 && this.fDepth == this.baseURIScope.peek()) {
            this.restoreBaseURI();
        }
        --this.fDepth;
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.isIncludeElement(qName) && this.getState() == 3 && !this.getSawFallback(this.fDepth + 1)) {
            this.reportFatalError("NoFallback");
        }
        if (this.isFallbackElement(qName)) {
            if (this.getState() == 1) {
                this.setState(2);
            }
        } else if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endElement(qName, augmentations);
        }
        this.setSawFallback(this.fDepth + 1, false);
        this.setSawInclude(this.fDepth + 1, false);
        if (this.baseURIScope.size() > 0 && this.fDepth == this.baseURIScope.peek()) {
            this.restoreBaseURI();
        }
        --this.fDepth;
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            ++this.fDepth;
            augmentations = this.modifyAugmentations(augmentations);
            this.fDocumentHandler.characters(xMLString, augmentations);
            --this.fDepth;
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && this.getState() == 1) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        if (this.isRootDocument() && this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.attributeDecl(string, string2, string3, stringArray, string4, xMLString, xMLString2, augmentations);
        }
    }

    public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.elementDecl(string, string2, augmentations);
        }
    }

    public void endAttlist(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endAttlist(augmentations);
        }
    }

    public void endConditional(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endConditional(augmentations);
        }
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endDTD(augmentations);
        }
        this.fInDTD = false;
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endExternalSubset(augmentations);
        }
    }

    public void endParameterEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.endParameterEntity(string, augmentations);
        }
    }

    public void externalEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.externalEntityDecl(string, xMLResourceIdentifier, augmentations);
        }
    }

    public XMLDTDSource getDTDSource() {
        return this.fDTDSource;
    }

    public void ignoredCharacters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.ignoredCharacters(xMLString, augmentations);
        }
    }

    public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.internalEntityDecl(string, xMLString, xMLString2, augmentations);
        }
    }

    public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.addNotation(string, xMLResourceIdentifier, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.notationDecl(string, xMLResourceIdentifier, augmentations);
        }
    }

    public void setDTDSource(XMLDTDSource xMLDTDSource) {
        this.fDTDSource = xMLDTDSource;
    }

    public void startAttlist(String string, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startAttlist(string, augmentations);
        }
    }

    public void startConditional(short s, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startConditional(s, augmentations);
        }
    }

    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
        this.fInDTD = true;
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startDTD(xMLLocator, augmentations);
        }
    }

    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startExternalSubset(xMLResourceIdentifier, augmentations);
        }
    }

    public void startParameterEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDTDHandler != null) {
            this.fDTDHandler.startParameterEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void unparsedEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.addUnparsedEntity(string, xMLResourceIdentifier, string2, augmentations);
        if (this.fDTDHandler != null) {
            this.fDTDHandler.unparsedEntityDecl(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public XMLDTDHandler getDTDHandler() {
        return this.fDTDHandler;
    }

    public void setDTDHandler(XMLDTDHandler xMLDTDHandler) {
        this.fDTDHandler = xMLDTDHandler;
    }

    private void setErrorReporter(XMLErrorReporter xMLErrorReporter) {
        this.fErrorReporter = xMLErrorReporter;
        if (this.fErrorReporter != null) {
            this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xinclude", new XIncludeMessageFormatter());
            if (this.fDocLocation != null) {
                this.fErrorReporter.setDocumentLocator(this.fDocLocation);
            }
        }
    }

    protected void handleFallbackElement() {
        this.setSawInclude(this.fDepth, false);
        this.fNamespaceContext.setContextInvalid();
        if (!this.getSawInclude(this.fDepth - 1)) {
            this.reportFatalError("FallbackParent");
        }
        if (this.getSawFallback(this.fDepth)) {
            this.reportFatalError("MultipleFallbacks");
        } else {
            this.setSawFallback(this.fDepth, true);
        }
        if (this.getState() == 3) {
            this.setState(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleIncludeElement(XMLAttributes xMLAttributes) throws XNIException {
        Object object;
        this.setSawInclude(this.fDepth, true);
        this.fNamespaceContext.setContextInvalid();
        if (this.getSawInclude(this.fDepth - 1)) {
            this.reportFatalError("IncludeChild", new Object[]{XINCLUDE_INCLUDE});
        }
        if (this.getState() == 2) {
            return true;
        }
        String string = xMLAttributes.getValue(XINCLUDE_ATTR_HREF);
        String string2 = xMLAttributes.getValue(XINCLUDE_ATTR_PARSE);
        String string3 = xMLAttributes.getValue(XPOINTER);
        String string4 = xMLAttributes.getValue(XINCLUDE_ATTR_ACCEPT);
        String string5 = xMLAttributes.getValue(XINCLUDE_ATTR_ACCEPT_LANGUAGE);
        if (string == null && string3 == null) {
            this.reportFatalError("XpointerMissing");
        }
        if (string2 == null) {
            string2 = XINCLUDE_PARSE_XML;
        }
        boolean bl = false;
        String string6 = null;
        if (string.indexOf("#") != -1) {
            string = string.substring(0, string.indexOf("#"));
        }
        if (string3 != null && string2.equals(XINCLUDE_PARSE_XML)) {
            bl = true;
        }
        if (string4 != null && !this.isValidInHTTPHeader(string4)) {
            this.reportFatalError("AcceptMalformed", null);
        }
        if (string5 != null && !this.isValidInHTTPHeader(string5)) {
            this.reportFatalError("AcceptLanguageMalformed", null);
        }
        XMLInputSource xMLInputSource = null;
        if (this.fEntityResolver != null) {
            try {
                object = new XMLResourceIdentifierImpl(null, string, this.fCurrentBaseURI.getExpandedSystemId(), XMLEntityManager.expandSystemId(string, this.fCurrentBaseURI.getExpandedSystemId(), false));
                xMLInputSource = this.fEntityResolver.resolveEntity((XMLResourceIdentifier)object);
            }
            catch (IOException iOException) {
                this.reportResourceError("XMLResourceError", new Object[]{string, iOException.getMessage()});
                return false;
            }
        }
        if (xMLInputSource == null) {
            xMLInputSource = new XIncludeInputSource(null, string, this.fCurrentBaseURI.getExpandedSystemId());
        }
        if (string2.equals(XINCLUDE_PARSE_XML) && bl) {
            if (this.fXPointerFramework == null) {
                this.fXPointerFramework = new XPointerFramework();
                this.fXPointerFramework.setXPointerSchema(this.fXPointerSchema);
            } else {
                this.fXPointerFramework.reset();
                this.fXPointerFramework.setXPointerSchema(this.fXPointerSchema);
            }
            string6 = XPOINTER_DEFAULT_CONFIGURATION;
            this.fChildConfig = this.createXPointerParser();
            this.fXPointerFramework.setSchemaPointer(string3);
            object = this.fXPointerFramework.getNextXPointerSchema();
            if (object == null && this.fXPointerFramework.getSchemaCount() == 0) {
                this.fNamespaceContext.pushScope();
                object = this.fXPointerFramework.getDefaultSchema();
                object.setXPointerSchemaPointer(string3);
                this.processSchema((XPointerSchema)object, xMLInputSource);
                return true;
            }
            try {
                this.fNamespaceContext.pushScope();
                if (object != null && this.processSchema((XPointerSchema)object, xMLInputSource)) {
                    return true;
                }
                int i = this.fXPointerFramework.getCurrentPointer();
                while (i <= this.fXPointerFramework.getSchemaCount()) {
                    object = this.fXPointerFramework.getNextXPointerSchema();
                    if (object != null && this.processSchema((XPointerSchema)object, xMLInputSource)) {
                        return true;
                    }
                    ++i;
                }
                return true;
            }
            catch (XNIException xNIException) {
                this.reportFatalError("XMLParseError");
                return true;
            }
            finally {
                this.fNamespaceContext.popScope();
            }
        }
        if (string2.equals(XINCLUDE_PARSE_XML)) {
            string6 = XINCLUDE_DEFAULT_CONFIGURATION;
            this.fChildConfig = (XMLParserConfiguration)ObjectFactory.newInstance(string6, ObjectFactory.findClassLoader(), true);
            if (this.fErrorReporter != null) {
                this.fChildConfig.setProperty(ERROR_REPORTER, this.fErrorReporter);
            }
            if (this.fEntityResolver != null) {
                this.fChildConfig.setProperty(ENTITY_RESOLVER, this.fEntityResolver);
            }
            if (this.fSecurityManager != null) {
                this.fChildConfig.setProperty(SECURITY_MANAGER, this.fSecurityManager);
            }
            this.fChildConfig.setProperty("http://apache.org/xml/properties/internal/namespace-context", this.fNamespaceContext);
            object = (XIncludeHandler)this.fChildConfig.getProperty("http://apache.org/xml/properties/internal/xinclude-handler");
            ((XIncludeHandler)object).setParent(this);
            ((XIncludeHandler)object).setDocumentHandler(this.getDocumentHandler());
            this.copyFeatures((XMLComponentManager)this.fSettings, this.fChildConfig);
            this.fChildConfig.setFeature("http://apache.org/xml/features/validation/schema", false);
            this.fChildConfig.setFeature(XINCLUDE_AWARE, true);
            try {
                this.fNamespaceContext.pushScope();
                xMLInputSource = this.setHttpProperties(xMLInputSource, xMLAttributes);
                this.fChildConfig.parse(xMLInputSource);
                if (this.fErrorReporter == null) return true;
                this.fErrorReporter.setDocumentLocator(this.fDocLocation);
                return true;
            }
            catch (XNIException xNIException) {
                if (this.fErrorReporter != null) {
                    this.fErrorReporter.setDocumentLocator(this.fDocLocation);
                }
                this.reportFatalError("XMLParseError", new Object[]{string});
                return true;
            }
            catch (IOException iOException) {
                if (this.fErrorReporter != null) {
                    this.fErrorReporter.setDocumentLocator(this.fDocLocation);
                }
                this.reportResourceError("XMLResourceError", new Object[]{string, iOException.getMessage()});
                boolean bl2 = false;
                return bl2;
            }
            finally {
                this.fNamespaceContext.popScope();
            }
        }
        if (!string2.equals(XINCLUDE_PARSE_TEXT)) {
            this.reportFatalError("InvalidParseValue", new Object[]{string2});
            return true;
        }
        object = xMLAttributes.getValue(XINCLUDE_ATTR_ENCODING);
        xMLInputSource.setEncoding((String)object);
        XIncludeTextReader xIncludeTextReader = null;
        try {
            try {
                xIncludeTextReader = this.fIsXML11 ? new XInclude11TextReader(xMLInputSource, this) : new XIncludeTextReader(xMLInputSource, this);
                if (xMLInputSource.getCharacterStream() == null && xMLInputSource.getByteStream() == null) {
                    xIncludeTextReader.setHttpProperties(string4, string5);
                }
                xIncludeTextReader.setErrorReporter(this.fErrorReporter);
                xIncludeTextReader.parse();
            }
            catch (MalformedByteSequenceException malformedByteSequenceException) {
                this.fErrorReporter.reportError(malformedByteSequenceException.getDomain(), malformedByteSequenceException.getKey(), malformedByteSequenceException.getArguments(), (short)2);
                Object var15_25 = null;
                if (xIncludeTextReader == null) return true;
                try {
                    xIncludeTextReader.close();
                    return true;
                }
                catch (IOException iOException) {
                    this.reportResourceError("TextResourceError", new Object[]{string, iOException.getMessage()});
                    return false;
                }
            }
            catch (CharConversionException charConversionException) {
                this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "CharConversionFailure", null, (short)2);
                Object var15_26 = null;
                if (xIncludeTextReader == null) return true;
                try {}
                catch (IOException iOException) {
                    this.reportResourceError("TextResourceError", new Object[]{string, iOException.getMessage()});
                    return false;
                }
                xIncludeTextReader.close();
                return true;
            }
            catch (IOException iOException) {
                this.reportResourceError("TextResourceError", new Object[]{string, iOException.getMessage()});
                boolean bl3 = false;
                Object var15_27 = null;
                if (xIncludeTextReader == null) return bl3;
                try {}
                catch (IOException iOException2) {
                    this.reportResourceError("TextResourceError", new Object[]{string, iOException2.getMessage()});
                    return false;
                }
                xIncludeTextReader.close();
                return bl3;
            }
            Object var15_24 = null;
            if (xIncludeTextReader == null) return true;
        }
        catch (Throwable throwable) {
            Object var15_28 = null;
            if (xIncludeTextReader == null) throw throwable;
            try {}
            catch (IOException iOException) {
                this.reportResourceError("TextResourceError", new Object[]{string, iOException.getMessage()});
                return false;
            }
            xIncludeTextReader.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            this.reportResourceError("TextResourceError", new Object[]{string, iOException.getMessage()});
            return false;
        }
        xIncludeTextReader.close();
        return true;
    }

    protected boolean hasXIncludeNamespace(QName qName) {
        return qName.uri == XINCLUDE_NS_URI || this.fNamespaceContext.getURI(qName.prefix) == XINCLUDE_NS_URI;
    }

    protected boolean isIncludeElement(QName qName) {
        return qName.localpart.equals(XINCLUDE_INCLUDE) && this.hasXIncludeNamespace(qName);
    }

    protected boolean isFallbackElement(QName qName) {
        return qName.localpart.equals(XINCLUDE_FALLBACK) && this.hasXIncludeNamespace(qName);
    }

    protected boolean sameBaseURIAsIncludeParent() {
        String string = this.getIncludeParentBaseURI();
        String string2 = this.fCurrentBaseURI.getExpandedSystemId();
        return string != null && string.equals(string2);
    }

    protected boolean searchForRecursiveIncludes(XMLLocator xMLLocator) {
        String string = xMLLocator.getExpandedSystemId();
        if (string == null) {
            try {
                string = XMLEntityManager.expandSystemId(xMLLocator.getLiteralSystemId(), xMLLocator.getBaseSystemId(), false);
            }
            catch (URI.MalformedURIException malformedURIException) {
                this.reportFatalError("ExpandedSystemId");
            }
        }
        if (string.equals(this.fCurrentBaseURI.getExpandedSystemId())) {
            return true;
        }
        if (this.fParentXIncludeHandler == null) {
            return false;
        }
        return this.fParentXIncludeHandler.searchForRecursiveIncludes(xMLLocator);
    }

    protected boolean isTopLevelIncludedItem() {
        return this.isTopLevelIncludedItemViaInclude() || this.isTopLevelIncludedItemViaFallback();
    }

    protected boolean isTopLevelIncludedItemViaInclude() {
        return this.fDepth == 1 && !this.isRootDocument();
    }

    protected boolean isTopLevelIncludedItemViaFallback() {
        return this.getSawFallback(this.fDepth - 1);
    }

    protected XMLAttributes processAttributes(XMLAttributes xMLAttributes) {
        Object object;
        String string;
        String string2;
        if (this.isTopLevelIncludedItem()) {
            Object object2;
            if (!this.sameBaseURIAsIncludeParent()) {
                if (xMLAttributes == null) {
                    xMLAttributes = new XMLAttributesImpl();
                }
                object2 = null;
                try {
                    object2 = this.getRelativeBaseURI();
                }
                catch (URI.MalformedURIException malformedURIException) {
                    object2 = this.fCurrentBaseURI.getExpandedSystemId();
                }
                int n = xMLAttributes.addAttribute(XML_BASE_QNAME, XMLSymbols.fCDATASymbol, (String)object2);
                xMLAttributes.setSpecified(n, true);
            }
            object2 = this.fNamespaceContext.getAllPrefixes();
            while (object2.hasMoreElements()) {
                String string3 = (String)object2.nextElement();
                string2 = this.fNamespaceContext.getURIFromIncludeParent(string3);
                if (string2 == (string = this.fNamespaceContext.getURI(string3)) || xMLAttributes == null) continue;
                if (string3 == XMLSymbols.EMPTY_STRING) {
                    if (xMLAttributes.getValue(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS) != null) continue;
                    if (xMLAttributes == null) {
                        xMLAttributes = new XMLAttributesImpl();
                    }
                    object = (QName)NEW_NS_ATTR_QNAME.clone();
                    ((QName)object).localpart = XMLSymbols.PREFIX_XMLNS;
                    ((QName)object).rawname = XMLSymbols.PREFIX_XMLNS;
                    xMLAttributes.addAttribute((QName)object, XMLSymbols.fCDATASymbol, string);
                    continue;
                }
                if (xMLAttributes.getValue(NamespaceContext.XMLNS_URI, string3) != null) continue;
                if (xMLAttributes == null) {
                    xMLAttributes = new XMLAttributesImpl();
                }
                object = (QName)NEW_NS_ATTR_QNAME.clone();
                ((QName)object).localpart = string3;
                ((QName)object).rawname = ((QName)object).rawname + string3;
                xMLAttributes.addAttribute((QName)object, XMLSymbols.fCDATASymbol, string);
            }
        }
        if (xMLAttributes != null) {
            int n = xMLAttributes.getLength();
            for (int i = 0; i < n; ++i) {
                string2 = xMLAttributes.getType(i);
                string = xMLAttributes.getValue(i);
                if (string2 == XMLSymbols.fENTITYSymbol) {
                    this.checkUnparsedEntity(string);
                }
                if (string2 == XMLSymbols.fENTITIESSymbol) {
                    object = new StringTokenizer(string);
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string4 = ((StringTokenizer)object).nextToken();
                        this.checkUnparsedEntity(string4);
                    }
                    continue;
                }
                if (string2 != XMLSymbols.fNOTATIONSymbol) continue;
                this.checkNotation(string);
            }
        }
        return xMLAttributes;
    }

    protected String getRelativeBaseURI() throws URI.MalformedURIException {
        int n = this.getIncludeParentDepth();
        String string = this.getRelativeURI(n);
        if (this.isRootDocument()) {
            return string;
        }
        if (string.equals("")) {
            string = this.fCurrentBaseURI.getLiteralSystemId();
        }
        if (n == 0) {
            if (this.fParentRelativeURI == null) {
                this.fParentRelativeURI = this.fParentXIncludeHandler.getRelativeBaseURI();
            }
            if (this.fParentRelativeURI.equals("")) {
                return string;
            }
            URI uRI = new URI("file", this.fParentRelativeURI);
            uRI = new URI(uRI, string);
            return uRI.getPath();
        }
        return string;
    }

    private String getIncludeParentBaseURI() {
        int n = this.getIncludeParentDepth();
        if (!this.isRootDocument() && n == 0) {
            return this.fParentXIncludeHandler.getIncludeParentBaseURI();
        }
        return this.getBaseURI(n);
    }

    private int getIncludeParentDepth() {
        for (int i = this.fDepth - 1; i >= 0; --i) {
            if (this.getSawInclude(i) || this.getSawFallback(i)) continue;
            return i;
        }
        return 0;
    }

    protected Augmentations modifyAugmentations(Augmentations augmentations) {
        return this.modifyAugmentations(augmentations, false);
    }

    protected Augmentations modifyAugmentations(Augmentations augmentations, boolean bl) {
        if (bl || this.isTopLevelIncludedItem()) {
            if (augmentations == null) {
                augmentations = new AugmentationsImpl();
            }
            augmentations.putItem(XINCLUDE_INCLUDED, Boolean.TRUE);
        }
        return augmentations;
    }

    protected int getState(int n) {
        return this.fState[n];
    }

    protected int getState() {
        return this.fState[this.fDepth];
    }

    protected void setState(int n) {
        if (this.fDepth >= this.fState.length) {
            int[] nArray = new int[this.fDepth * 2];
            System.arraycopy(this.fState, 0, nArray, 0, this.fState.length);
            this.fState = nArray;
        }
        this.fState[this.fDepth] = n;
    }

    protected void setSawFallback(int n, boolean bl) {
        if (n >= this.fSawFallback.length) {
            boolean[] blArray = new boolean[n * 2];
            System.arraycopy(this.fSawFallback, 0, blArray, 0, this.fSawFallback.length);
            this.fSawFallback = blArray;
        }
        this.fSawFallback[n] = bl;
    }

    protected boolean getSawFallback(int n) {
        if (n >= this.fSawFallback.length) {
            return false;
        }
        return this.fSawFallback[n];
    }

    protected void setSawInclude(int n, boolean bl) {
        if (n >= this.fSawInclude.length) {
            boolean[] blArray = new boolean[n * 2];
            System.arraycopy(this.fSawInclude, 0, blArray, 0, this.fSawInclude.length);
            this.fSawInclude = blArray;
        }
        this.fSawInclude[n] = bl;
    }

    protected boolean getSawInclude(int n) {
        if (n >= this.fSawInclude.length) {
            return false;
        }
        return this.fSawInclude[n];
    }

    protected void reportResourceError(String string) {
        this.reportFatalError(string, null);
    }

    protected void reportResourceError(String string, Object[] objectArray) {
        this.reportError(string, objectArray, (short)0);
    }

    protected void reportFatalError(String string) {
        this.reportFatalError(string, null);
    }

    protected void reportFatalError(String string, Object[] objectArray) {
        this.reportError(string, objectArray, (short)2);
    }

    private void reportError(String string, Object[] objectArray, short s) {
        if (this.fErrorReporter != null) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/xinclude", string, objectArray, s);
        }
    }

    protected void setParent(XIncludeHandler xIncludeHandler) {
        this.fParentXIncludeHandler = xIncludeHandler;
    }

    protected boolean isRootDocument() {
        return this.fParentXIncludeHandler == null;
    }

    protected void addUnparsedEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) {
        UnparsedEntity unparsedEntity = new UnparsedEntity();
        unparsedEntity.name = string;
        unparsedEntity.systemId = xMLResourceIdentifier.getLiteralSystemId();
        unparsedEntity.publicId = xMLResourceIdentifier.getPublicId();
        unparsedEntity.baseURI = xMLResourceIdentifier.getBaseSystemId();
        unparsedEntity.notation = string2;
        unparsedEntity.augmentations = augmentations;
        this.fUnparsedEntities.add(unparsedEntity);
    }

    protected void addNotation(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) {
        Notation notation = new Notation();
        notation.name = string;
        notation.systemId = xMLResourceIdentifier.getLiteralSystemId();
        notation.publicId = xMLResourceIdentifier.getPublicId();
        notation.baseURI = xMLResourceIdentifier.getBaseSystemId();
        notation.augmentations = augmentations;
        this.fNotations.add(notation);
    }

    protected void checkUnparsedEntity(String string) {
        UnparsedEntity unparsedEntity = new UnparsedEntity();
        unparsedEntity.name = string;
        int n = this.fUnparsedEntities.indexOf(unparsedEntity);
        if (n != -1) {
            unparsedEntity = (UnparsedEntity)this.fUnparsedEntities.get(n);
            this.checkNotation(unparsedEntity.notation);
            this.checkAndSendUnparsedEntity(unparsedEntity);
        }
    }

    protected void checkNotation(String string) {
        Notation notation = new Notation();
        notation.name = string;
        int n = this.fNotations.indexOf(notation);
        if (n != -1) {
            notation = (Notation)this.fNotations.get(n);
            this.checkAndSendNotation(notation);
        }
    }

    protected void checkAndSendUnparsedEntity(UnparsedEntity unparsedEntity) {
        if (this.isRootDocument()) {
            int n = this.fUnparsedEntities.indexOf(unparsedEntity);
            if (n == -1) {
                XMLResourceIdentifierImpl xMLResourceIdentifierImpl = new XMLResourceIdentifierImpl(unparsedEntity.publicId, unparsedEntity.systemId, unparsedEntity.baseURI, null);
                this.addUnparsedEntity(unparsedEntity.name, xMLResourceIdentifierImpl, unparsedEntity.notation, unparsedEntity.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.unparsedEntityDecl(unparsedEntity.name, xMLResourceIdentifierImpl, unparsedEntity.notation, unparsedEntity.augmentations);
                }
            } else {
                UnparsedEntity unparsedEntity2 = (UnparsedEntity)this.fUnparsedEntities.get(n);
                if (!unparsedEntity.isDuplicate(unparsedEntity2)) {
                    this.reportFatalError("NonDuplicateUnparsedEntity", new Object[]{unparsedEntity.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendUnparsedEntity(unparsedEntity);
        }
    }

    protected void checkAndSendNotation(Notation notation) {
        if (this.isRootDocument()) {
            int n = this.fNotations.indexOf(notation);
            if (n == -1) {
                XMLResourceIdentifierImpl xMLResourceIdentifierImpl = new XMLResourceIdentifierImpl(notation.publicId, notation.systemId, notation.baseURI, null);
                this.addNotation(notation.name, xMLResourceIdentifierImpl, notation.augmentations);
                if (this.fSendUEAndNotationEvents && this.fDTDHandler != null) {
                    this.fDTDHandler.notationDecl(notation.name, xMLResourceIdentifierImpl, notation.augmentations);
                }
            } else {
                Notation notation2 = (Notation)this.fNotations.get(n);
                if (!notation.isDuplicate(notation2)) {
                    this.reportFatalError("NonDuplicateNotation", new Object[]{notation.name});
                }
            }
        } else {
            this.fParentXIncludeHandler.checkAndSendNotation(notation);
        }
    }

    protected void copyFeatures(XMLComponentManager xMLComponentManager, ParserConfigurationSettings parserConfigurationSettings) {
        Enumeration enumeration = Constants.getXercesFeatures();
        this.copyFeatures1(enumeration, "http://apache.org/xml/features/", xMLComponentManager, parserConfigurationSettings);
        enumeration = Constants.getSAXFeatures();
        this.copyFeatures1(enumeration, "http://xml.org/sax/features/", xMLComponentManager, parserConfigurationSettings);
    }

    protected void copyFeatures(XMLComponentManager xMLComponentManager, XMLParserConfiguration xMLParserConfiguration) {
        Enumeration enumeration = Constants.getXercesFeatures();
        this.copyFeatures1(enumeration, "http://apache.org/xml/features/", xMLComponentManager, xMLParserConfiguration);
        enumeration = Constants.getSAXFeatures();
        this.copyFeatures1(enumeration, "http://xml.org/sax/features/", xMLComponentManager, xMLParserConfiguration);
    }

    private void copyFeatures1(Enumeration enumeration, String string, XMLComponentManager xMLComponentManager, ParserConfigurationSettings parserConfigurationSettings) {
        while (enumeration.hasMoreElements()) {
            String string2 = string + (String)enumeration.nextElement();
            parserConfigurationSettings.addRecognizedFeatures(new String[]{string2});
            try {
                parserConfigurationSettings.setFeature(string2, xMLComponentManager.getFeature(string2));
            }
            catch (XMLConfigurationException xMLConfigurationException) {}
        }
    }

    private void copyFeatures1(Enumeration enumeration, String string, XMLComponentManager xMLComponentManager, XMLParserConfiguration xMLParserConfiguration) {
        while (enumeration.hasMoreElements()) {
            String string2 = string + (String)enumeration.nextElement();
            boolean bl = xMLComponentManager.getFeature(string2);
            try {
                xMLParserConfiguration.setFeature(string2, bl);
            }
            catch (XMLConfigurationException xMLConfigurationException) {}
        }
    }

    protected void saveBaseURI() {
        this.baseURIScope.push(this.fDepth);
        this.baseURI.push(this.fCurrentBaseURI.getBaseSystemId());
        this.literalSystemID.push(this.fCurrentBaseURI.getLiteralSystemId());
        this.expandedSystemID.push(this.fCurrentBaseURI.getExpandedSystemId());
    }

    protected void restoreBaseURI() {
        this.baseURI.pop();
        this.literalSystemID.pop();
        this.expandedSystemID.pop();
        this.baseURIScope.pop();
        this.fCurrentBaseURI.setBaseSystemId((String)this.baseURI.peek());
        this.fCurrentBaseURI.setLiteralSystemId((String)this.literalSystemID.peek());
        this.fCurrentBaseURI.setExpandedSystemId((String)this.expandedSystemID.peek());
    }

    public String getBaseURI(int n) {
        int n2 = this.scopeOf(n);
        return (String)this.expandedSystemID.elementAt(n2);
    }

    public String getRelativeURI(int n) throws URI.MalformedURIException {
        int n2 = this.scopeOf(n) + 1;
        if (n2 == this.baseURIScope.size()) {
            return "";
        }
        URI uRI = new URI("file", (String)this.literalSystemID.elementAt(n2));
        for (int i = n2 + 1; i < this.baseURIScope.size(); ++i) {
            uRI = new URI(uRI, (String)this.literalSystemID.elementAt(i));
        }
        return uRI.getPath();
    }

    private int scopeOf(int n) {
        for (int i = this.baseURIScope.size() - 1; i >= 0; --i) {
            if (this.baseURIScope.elementAt(i) > n) continue;
            return i;
        }
        return -1;
    }

    protected void processXMLBaseAttributes(XMLAttributes xMLAttributes) {
        String string = xMLAttributes.getValue(NamespaceContext.XML_URI, XINCLUDE_BASE);
        if (string != null) {
            try {
                String string2 = XMLEntityManager.expandSystemId(string, this.fCurrentBaseURI.getExpandedSystemId(), false);
                this.fCurrentBaseURI.setLiteralSystemId(string);
                this.fCurrentBaseURI.setBaseSystemId(this.fCurrentBaseURI.getExpandedSystemId());
                this.fCurrentBaseURI.setExpandedSystemId(string2);
                this.saveBaseURI();
            }
            catch (URI.MalformedURIException malformedURIException) {
                // empty catch block
            }
        }
    }

    protected XMLInputSource setHttpProperties(XMLInputSource xMLInputSource, XMLAttributes xMLAttributes) throws IOException {
        String string = xMLAttributes.getValue(HTTP_ACCEPT_LANGUAGE);
        String string2 = xMLAttributes.getValue(HTTP_ACCEPT);
        String string3 = xMLAttributes.getValue(HTTP_ACCEPT_CHARSET);
        if (xMLInputSource.getCharacterStream() == null && xMLInputSource.getByteStream() == null) {
            XIncludeInputSource xIncludeInputSource = new XIncludeInputSource(xMLInputSource.getPublicId(), xMLInputSource.getSystemId(), xMLInputSource.getBaseSystemId(), xMLInputSource.getByteStream(), xMLInputSource.getEncoding());
            xIncludeInputSource.setProperty(XINCLUDE_ATTR_ACCEPT, xMLAttributes.getValue(XINCLUDE_ATTR_ACCEPT));
            xIncludeInputSource.setProperty(XINCLUDE_ATTR_ACCEPT_CHARSET, xMLAttributes.getValue(XINCLUDE_ATTR_ACCEPT_CHARSET));
            xIncludeInputSource.setProperty(XINCLUDE_ATTR_ACCEPT_LANGUAGE, xMLAttributes.getValue(XINCLUDE_ATTR_ACCEPT_LANGUAGE));
        }
        return xMLInputSource;
    }

    public boolean processSchema(XPointerSchema xPointerSchema, XMLInputSource xMLInputSource) {
        try {
            this.fChildConfig = this.createXPointerParser();
            this.fChildConfig.setProperty("http://apache.org/xml/properties/internal/xinclude-handler", xPointerSchema);
            xPointerSchema.setParent(this);
            xPointerSchema.setDocumentHandler(this.getDocumentHandler());
            this.fChildConfig.parse(xMLInputSource);
        }
        catch (Exception exception) {
            this.reportResourceError("XMLResourceError", new Object[]{null, exception.getMessage()});
        }
        return xPointerSchema.isSubResourceIndentified();
    }

    private boolean isValidInHTTPHeader(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c >= ' ' && c <= '~') continue;
            return false;
        }
        return true;
    }

    protected XMLParserConfiguration createXPointerParser() {
        XMLParserConfiguration xMLParserConfiguration = (XMLParserConfiguration)ObjectFactory.newInstance(XPOINTER_DEFAULT_CONFIGURATION, ObjectFactory.findClassLoader(), true);
        xMLParserConfiguration.setProperty(ERROR_REPORTER, this.fErrorReporter);
        xMLParserConfiguration.setProperty("http://apache.org/xml/properties/internal/namespace-context", this.fNamespaceContext);
        this.copyFeatures((XMLComponentManager)this.fSettings, xMLParserConfiguration);
        return xMLParserConfiguration;
    }

    protected class UnparsedEntity {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public String notation;
        public Augmentations augmentations;

        protected UnparsedEntity() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof UnparsedEntity) {
                UnparsedEntity unparsedEntity = (UnparsedEntity)object;
                return this.name.equals(unparsedEntity.name);
            }
            return false;
        }

        public boolean isDuplicate(Object object) {
            if (object != null && object instanceof UnparsedEntity) {
                UnparsedEntity unparsedEntity = (UnparsedEntity)object;
                return this.name.equals(unparsedEntity.name) && (this.systemId == unparsedEntity.systemId || this.systemId != null && this.systemId.equals(unparsedEntity.systemId)) && (this.publicId == unparsedEntity.publicId || this.publicId != null && this.publicId.equals(unparsedEntity.publicId)) && (this.baseURI == unparsedEntity.baseURI || this.baseURI != null && this.baseURI.equals(unparsedEntity.baseURI)) && (this.notation == unparsedEntity.notation || this.notation != null && this.notation.equals(unparsedEntity.notation));
            }
            return false;
        }
    }

    protected class Notation {
        public String name;
        public String systemId;
        public String baseURI;
        public String publicId;
        public Augmentations augmentations;

        protected Notation() {
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Notation) {
                Notation notation = (Notation)object;
                return this.name.equals(notation.name);
            }
            return false;
        }

        public boolean isDuplicate(Object object) {
            if (object != null && object instanceof Notation) {
                Notation notation = (Notation)object;
                return this.name.equals(notation.name) && (this.systemId == notation.systemId || this.systemId != null && this.systemId.equals(notation.systemId)) && (this.publicId == notation.publicId || this.publicId != null && this.publicId.equals(notation.publicId)) && (this.baseURI == notation.baseURI || this.baseURI != null && this.baseURI.equals(notation.baseURI));
            }
            return false;
        }
    }
}

