/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbcx.base;

import com.microsoft.jdbc.base.BaseConnection;
import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.jdbc.extensions.ExtEmbeddedConnection;
import com.microsoft.jdbcx.base.BasePooledConnectionWrapper;
import com.microsoft.jdbcx.base.BaseResettableConnection;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class BasePooledConnection
implements PooledConnection,
BaseResettableConnection,
ExtEmbeddedConnection {
    private static String footprint = "$Revision:   1.5.1.0  $";
    protected BaseConnection realConnection;
    private Vector connectionEventListeners;
    protected boolean pooledConnectionBusy;
    protected BaseExceptions exceptions;

    public BasePooledConnection(BaseConnection baseConnection, BaseExceptions baseExceptions) {
        this.realConnection = baseConnection;
        this.connectionEventListeners = new Vector();
        this.pooledConnectionBusy = false;
        this.exceptions = baseExceptions;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            return;
        }
        if (this.connectionEventListeners.contains(connectionEventListener)) {
            return;
        }
        this.connectionEventListeners.addElement(connectionEventListener);
    }

    public void clearWarnings() throws SQLException {
        this.realConnection.clearWarnings();
    }

    public void close() throws SQLException {
        this.realConnection.close();
    }

    public void commit() throws SQLException {
        this.realConnection.commit();
    }

    void commonReset(List list, List list2) throws SQLException {
        AutoCloseable autoCloseable;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            autoCloseable = (Statement)iterator.next();
            autoCloseable.close();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            autoCloseable = (ResultSet)iterator.next();
            autoCloseable.close();
        }
    }

    void connectionClosed() throws SQLException {
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        int n = this.connectionEventListeners.size();
        int n2 = 0;
        while (n2 < n) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.elementAt(n2);
            connectionEventListener.connectionClosed(connectionEvent);
            ++n2;
        }
    }

    void connectionErrorOccurred(SQLException sQLException) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this, sQLException);
        int n = this.connectionEventListeners.size();
        int n2 = 0;
        while (n2 < n) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)this.connectionEventListeners.elementAt(n2);
            connectionEventListener.connectionErrorOccurred(connectionEvent);
            ++n2;
        }
    }

    public Statement createStatement() throws SQLException {
        return this.realConnection.createStatement();
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.realConnection.createStatement(n, n2);
    }

    public boolean getAutoCommit() throws SQLException {
        return this.realConnection.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        return this.realConnection.getCatalog();
    }

    public synchronized Connection getConnection() throws SQLException {
        if (this.pooledConnectionBusy) {
            throw this.exceptions.getException(6049);
        }
        BasePooledConnectionWrapper basePooledConnectionWrapper = new BasePooledConnectionWrapper(this, this.exceptions);
        this.pooledConnectionBusy = true;
        return basePooledConnectionWrapper;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.realConnection.getMetaData();
    }

    public int getTransactionIsolation() throws SQLException {
        return this.realConnection.getTransactionIsolation();
    }

    public Map getTypeMap() throws SQLException {
        return this.realConnection.getTypeMap();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.realConnection.getWarnings();
    }

    public boolean isClosed() throws SQLException {
        return this.realConnection.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        return this.realConnection.isReadOnly();
    }

    public String nativeSQL(String string) throws SQLException {
        return this.realConnection.nativeSQL(string);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.realConnection.prepareCall(string);
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.realConnection.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.realConnection.prepareStatement(string);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.realConnection.prepareStatement(string, n, n2);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (connectionEventListener == null) {
            return;
        }
        this.connectionEventListeners.removeElement(connectionEventListener);
    }

    public void reset(List list, List list2) {
        try {
            try {
                BaseConnection baseConnection = this.realConnection;
                synchronized (baseConnection) {
                    this.commonReset(list, list2);
                    this.realConnection.reset();
                }
                this.connectionClosed();
            }
            catch (SQLException sQLException) {
                this.connectionErrorOccurred(sQLException);
            }
            Object var4_5 = null;
            this.pooledConnectionBusy = false;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.pooledConnectionBusy = false;
            throw throwable;
        }
    }

    public void rollback() throws SQLException {
        this.realConnection.rollback();
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.realConnection.setAutoCommit(bl);
    }

    public void setCatalog(String string) throws SQLException {
        this.realConnection.setCatalog(string);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.realConnection.setReadOnly(bl);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.realConnection.setTransactionIsolation(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        this.realConnection.setTypeMap(map);
    }

    public boolean unlock(String string) throws SQLException {
        return this.realConnection.unlock(string);
    }
}

