/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Properties;
import javax.xml.datatype.SecuritySupport;

class FactoryFinder {
    private static final String CLASS_NAME = "javax.xml.datatype.FactoryFinder";
    private static boolean debug = false;
    private static Properties cacheProps = new Properties();
    private static boolean firstTime = true;
    private static SecuritySupport ss = new SecuritySupport();

    FactoryFinder() {
    }

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("javax.xml.datatype.FactoryFinder:" + msg);
        }
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader = ss.getContextClassLoader();
        FactoryFinder.debugPrintln("Using context class loader: " + classLoader);
        if (classLoader == null) {
            classLoader = FactoryFinder.class.getClassLoader();
            FactoryFinder.debugPrintln("Using the class loader of FactoryFinder: " + classLoader);
        }
        return classLoader;
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            if (debug) {
                FactoryFinder.debugPrintln("Loaded " + className + " from " + FactoryFinder.which(spiClass));
            }
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException x) {
            throw new ConfigurationError("Provider " + className + " not found", x);
        }
        catch (Exception x) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + x, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        Object provider;
        ClassLoader classLoader;
        block14: {
            classLoader = FactoryFinder.findClassLoader();
            try {
                String systemProp = ss.getSystemProperty(factoryId);
                if (systemProp != null) {
                    FactoryFinder.debugPrintln("found " + systemProp + " in the system property " + factoryId);
                    return FactoryFinder.newInstance(systemProp, classLoader);
                }
            }
            catch (SecurityException se) {
                // empty catch block
            }
            try {
                String javah = ss.getSystemProperty("java.home");
                String configFile = javah + File.separator + "lib" + File.separator + "jaxp.properties";
                String factoryClassName = null;
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (ss.doesFileExist(f)) {
                                FactoryFinder.debugPrintln("Read properties file " + f);
                                cacheProps.load(ss.getFileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(factoryId);
                FactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                if (factoryClassName != null) {
                    return FactoryFinder.newInstance(factoryClassName, classLoader);
                }
            }
            catch (Exception ex) {
                if (!debug) break block14;
                ex.printStackTrace();
            }
        }
        if ((provider = FactoryFinder.findJarServiceProvider(factoryId)) != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new ConfigurationError("Provider for " + factoryId + " cannot be found", null);
        }
        FactoryFinder.debugPrintln("loaded from fallback value: " + fallbackClassName);
        return FactoryFinder.newInstance(fallbackClassName, classLoader);
    }

    private static Object findJarServiceProvider(String factoryId) throws ConfigurationError {
        BufferedReader rd;
        String serviceId = "META-INF/services/" + factoryId;
        InputStream is = null;
        ClassLoader cl = ss.getContextClassLoader();
        if (cl != null) {
            is = ss.getResourceAsStream(cl, serviceId);
            if (is == null) {
                cl = FactoryFinder.class.getClassLoader();
                is = ss.getResourceAsStream(cl, serviceId);
            }
        } else {
            cl = FactoryFinder.class.getClassLoader();
            is = ss.getResourceAsStream(cl, serviceId);
        }
        if (is == null) {
            return null;
        }
        FactoryFinder.debugPrintln("found jar resource=" + serviceId + " using ClassLoader: " + cl);
        try {
            rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            rd = new BufferedReader(new InputStreamReader(is));
        }
        String factoryClassName = null;
        try {
            factoryClassName = rd.readLine();
            rd.close();
        }
        catch (IOException x) {
            return null;
        }
        if (factoryClassName != null && !"".equals(factoryClassName)) {
            FactoryFinder.debugPrintln("found in resource, value=" + factoryClassName);
            return FactoryFinder.newInstance(factoryClassName, cl);
        }
        return null;
    }

    private static String which(Class clazz) {
        block3: {
            try {
                String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
                ClassLoader loader = clazz.getClassLoader();
                URL it = loader != null ? loader.getResource(classnameAsResource) : ClassLoader.getSystemResource(classnameAsResource);
                if (it != null) {
                    return it.toString();
                }
            }
            catch (Throwable t) {
                if (!debug) break block3;
                t.printStackTrace();
            }
        }
        return "unknown location";
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class ClassLoaderFinderConcrete
    extends ClassLoaderFinder {
        ClassLoaderFinderConcrete() {
        }

        ClassLoader getContextClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    private static abstract class ClassLoaderFinder {
        private ClassLoaderFinder() {
        }

        abstract ClassLoader getContextClassLoader();
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

