/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.sqlserver.tds;

import com.microsoft.jdbc.base.BaseExceptions;
import com.microsoft.util.UtilDateAndTimeFunctions;
import java.sql.SQLException;
import java.sql.Timestamp;

public class TDSDateTime {
    private static String footprint = "$Revision:   1.4.1.0  $";
    public static final int NUM_300TH_SECONDS_IN_ONE_MINUTE = 18000;
    public static final int NUM_NANOSECONDS_IN_A_300TH_OF_A_SECOND = 3333333;
    private static int BASEYEAR = 1753;
    private static int MAXYEAR = 9999;
    private static int BASEBIAS = 53690;
    public int numDaysSince_1_1_1900;
    public int num300thSecondsSinceMidnight;
    public Timestamp timestamp;

    public TDSDateTime(int n, int n2) {
        int n3 = n2 / 18000;
        float f = n2 % 18000;
        int n4 = (int)(f / 300.0f);
        int n5 = (int)((f -= (float)(n4 * 300)) / 300.0f * 1.0E9f);
        int n6 = n5 % 1000000;
        if (n6 > 0) {
            n5 = n5 / 1000000 * 1000000;
            if (n6 > 500000) {
                n5 += 1000000;
            }
        }
        this.timestamp = new Timestamp(0, 0, ++n, 0, n3, n4, n5);
        this.numDaysSince_1_1_1900 = n;
        this.num300thSecondsSinceMidnight = n2;
    }

    public TDSDateTime(BaseExceptions baseExceptions, Timestamp timestamp) throws SQLException {
        int n = timestamp.getYear() + 1900;
        int n2 = timestamp.getDate();
        int n3 = timestamp.getMonth() + 1;
        int n4 = timestamp.getHours();
        int n5 = timestamp.getMinutes();
        int n6 = timestamp.getSeconds();
        int n7 = timestamp.getNanos();
        if (n < BASEYEAR || n > MAXYEAR) {
            String[] stringArray = new String[]{String.valueOf(n)};
            throw baseExceptions.getException(11014, stringArray);
        }
        int n8 = (n -= BASEYEAR) * 365 + UtilDateAndTimeFunctions.leapCount((int)n) + UtilDateAndTimeFunctions.JulianDays[n3] + n2;
        if (n3 > 2 && UtilDateAndTimeFunctions.isLeapYear((int)(n + BASEYEAR))) {
            ++n8;
        }
        this.numDaysSince_1_1_1900 = n8 - BASEBIAS - 1;
        this.num300thSecondsSinceMidnight = n4 * 60 * 18000 + n5 * 18000 + n6 * 300 + n7 / 3333333;
        int n9 = n7 % 3333333;
        if (n9 > 1666666) {
            ++this.num300thSecondsSinceMidnight;
        }
        this.timestamp = timestamp;
    }
}

