/*
FILE: 			ExampleMetaData.java

Demonstrates the UnityJDBC driver's support for the DatabaseMetaData interface. 		
*/

package Tests;

import java.sql.*;

public class ExampleMetaData
{	public static void main(String[] args)
	{	// Change this line to reference the location of your sources XML file
		String url="jdbc:Unity://Tests/xspec/UnityDemo.xml";
		
		try {	// Load driver class
			Class.forName("unity.jdbc.UnityDriver");
		}
		catch (java.lang.ClassNotFoundException e) {
			System.err.println("ClassNotFoundException: " +e);
		}

		Connection con = null;
		try {
			con = DriverManager.getConnection(url);

			String []tblTypes = {"TABLE"};				// What table types to retrieve

			DatabaseMetaData dmd = con.getMetaData();  	// Get metadata
			ResultSet rs1, rs5; 
			
			rs1 = dmd.getTables(null,null, "%",tblTypes);
			
			System.out.println("List all table metadata fields: ");
			ResultSetMetaData rsmd = rs1.getMetaData();
			for (int i=0; i < rsmd.getColumnCount(); i++)
				System.out.println(rsmd.getColumnName(i+1));

			System.out.println("\nList all tables in database: ");
			
			while (rs1.next()) {
				String tblName = rs1.getString(3);
				
				System.out.print("\nTable: "+tblName);
				rs5 = dmd.getColumns(null,null,tblName,"%");
				System.out.println("  Attributes: ");

				while (rs5.next()) {
					System.out.println(rs5.getString(4));
				}
			} // end outer while
		}
		catch (SQLException ex) {
			System.err.println("SQLException: " + ex); }
		finally
		{
			if (con != null)
				try
				{
					con.close();
				}
				catch (SQLException ex)
				{
					System.err.println("SQLException: " + ex);
				}
		}
	}
}
