<?php
	function getCustomTagContent($tag,$contents) {
		$start_tag = '<' . $tag . '>';
		$end_tag = '<\/' . $tag . '>';
		preg_match("/" . $start_tag . "(.+)" . $end_tag . "/i", $contents, $match);
		return $match[1];
	}
	
	function getFileContents($full_filename,$keep_newlines='0') {
		
		if ($fp = @fopen($full_filename,'r')) {
			if (filesize($full_filename) > 0) {
				$contents = fread($fp, filesize($full_filename));
			}
			fclose($fp);
			if ($keep_newlines == 0) {
				$contents = str_replace("\n",'',$contents);
			}
		} else {
			echo 'oops';
		}
		return $contents;
	}
	
	function formatBriefcase($styles_array) {
		$styles_i = 0;
		$count = count($styles_array);
		while ($styles_i < $count) {
			$style = trim($styles_array[$styles_i]['code']);
			$class_array = explode('{',$style);
			$class = trim($class_array[0]);
			$styles_code .= $styles_array[$styles_i]['code'];
			$formatted_code_array_1 = explode ('{',$styles_array[$styles_i]['code']);
			$formatted_code_array_2 = explode (';',$formatted_code_array_1[1]);
			$total_lines = count($formatted_code_array_2);
			$lines_i = 0;
			$formatted_code = '';
			while(($lines_i+1) < $total_lines) {
				$formatted_code .= '&nbsp;&nbsp;' . $formatted_code_array_2[$lines_i] . "<br />";
				$lines_i++;
			}
			$formatted_code = $formatted_code_array_1[0] . " { <br />" . $formatted_code . "}";
			$formatted_for_copy = $formatted_code;
			$formatted_for_copy = str_replace('<br />',"\n",$formatted_for_copy);
			$formatted_for_copy = str_replace('&nbsp;'," ",$formatted_for_copy);
			$formatted_for_copy_block .= $formatted_for_copy . "\n\n";
			if (strpos($class,' ')) {
				$div = 'This is a complex style, and cannot be displayed.';
			} elseif (substr($style,0,1) == '.') {
				$whole_class = $class;
				$class = str_replace('.','',$class);
				$div = '<div class="' . $class . '">This is some test content for the class <strong>' . $class . '</strong>.<br /> <a href="#">Hyperlink</a></div>';
				
			} elseif (substr($style,0,1) == '#') {
				$whole_class = $class;
				$class = str_replace('#','',$class);
				$div = '<div id="' . $class . '">This is some test content for the ID <strong>class ' . $class . '</strong>. <a href="#">Hyperlink</a></div>';
			} else {
				$whole_class = $class;
				$div = 'This is a style for a <' . $class . '> tag';
			}
			$styles_display .= '
				<tr>
					<td><input type="checkbox" name="' . ($styles_i) . '" value="1"></td>
					<td><strong>' . $styles_array[$styles_i]['name'] . '</strong></td>
					<td>' . $class . '</td>
					<td>' . createHelpBubble($div) . '</td>
					<td>' . createCodeBubble($formatted_code) . '</td>
					<td><a href="index.php?action=delete&id=' . $styles_i . '">Delete</a></td>
				</tr>';
				$styles_array[$styles_i]['name'] . ' ' . $styles_array[$styles_i]['code'] . '<br />';
			$styles_i++;
		}
		if ($styles_display != '') {
			$styles['display'] = '<form action="index.php" method="post"><input type="hidden" name="action" value="generate_briefcase" /><table class="briefcase-table">
				<tr>
					<th>Include</th>
					<th>Name</th>
					<th>Style Name</th>
					<th>Hover to<br />Preview</th>
					<th>Hover to<br />See Code</th>
					<th>Delete</th>
				</tr>' . $styles_display . '</table><br />
				<input type="submit" value="Generate Code  &gt;&gt;" />
			
			</form>';
			$styles['css'] = '<style>' . $styles_code . '</style>';
		} else {
			$styles['display'] = '<p><strong>There are currently no styles in your briefcase.</strong></p>';
		}
		return $styles;
	}
	
	function getStylesData($file) {
		$contents = getFileContents($file);
		$data_array = explode('</style>',$contents);
		$total = count($data_array );
		$style_i = 0;
		while (($style_i+1) < $total) {
			$styles[$style_i]['name'] = getCustomTagContent('name',$data_array[$style_i]);
			$styles[$style_i]['code'] = getCustomTagContent('style_code',$data_array[$style_i]);
			
			$style = trim($styles[$style_i]['code']);
			$class_array = explode('{',$style);
			$class = trim($class_array[0]);
			$styles[$style_i]['style_name'] = $class;
			$style_i++;
		}
		return $styles;
	}

	
	function clean_content($contents) {
		$contents = stripslashes($contents);
		$contents = str_replace("\t",'',$contents);
		$contents = str_replace("\r",'',$contents);
		$contents = str_replace("\n",'',$contents);
		while (strpos($contents,'  ')) {
			$contents = str_replace('  ',' ',$contents);
		}
		return $contents;
	}
	
	function createToolTip($content) {
		$content = str_replace('"','\'',$content);
		$content = str_replace('\'','\\\'',$content);
		return 'onmouseover="return escape(\'' . $content . '\')"';
	}
	
	function createHelpBubble($content) {
		global $settings;
		$content = createToolTip($content);
		return '<img class="help-pointer" src="qmark.gif" ' . $content . ' />';
	}
	
	function createCodeBubble($content) {
		global $settings;
		$content = createToolTip($content);
		return '<img class="help-pointer" src="code.gif" ' . $content . ' />';
	}
?>