/* This file is PTRACE.C
**
** contains :
**
**	- ptrace handler
**
** Copyright (c) Rainer Schnitker '92 '93
*/

#include <errno.h>
#include "DPMI.H"
#include "PROCESS.H"
#include "CDOSX32.H"
#include "ADOSX32.H"
#include "COPY32.H"
#include "PTRACE.H"

#define FLAG_MASK 0x00000dd9L
#define SINGLE_STEP 0x100

int do_ptrace(int request, int child_id, DWORD addr, DWORD data, DWORD * ret)
{
    NEWPROCESS *child;

    if (!(child = find_process(child_id)))
	return -ESRCH;

    if (child->pptr != npz || !(child->p_flags & PF_DEBUG))
	return ESRCH;

    if (child->p_status != PS_STOP)
	return -ESRCH;

    *ret = 0;

    switch (request) {
    case PTRACE_TRACEME:
    case PTRACE_SESSION:
	return 0;

    case PTRACE_PEEKTEXT:
    case PTRACE_PEEKDATA:
	if (verify_illegal(child, addr, 4))
	    return EIO;
	*ret = read32(child->data32sel, addr);
	return 0;

    case PTRACE_POKETEXT:
    case PTRACE_POKEDATA:
	if (verify_illegal(child, addr, 4))
	    return EIO;
	store32(child->data32sel, addr, data);
	*ret = data;
	return 0;

    case PTRACE_EXIT:
	/* to do : switch to child -> do_signal(); */
	child->p_flags |= PF_WAIT_WAIT;
	return 0;

    case PTRACE_PEEKUSER:
	if (addr == 0x30) {	/* u_ar0  */
	    *ret = 0xE0000000 + ((DWORD) (WORD) & (child->regs));
	    return 0;
	} else {		/* peek regs */
	    DWORD *peekat;
	    peekat = (DWORD *) (WORD) (addr);

	    if (peekat < &(child->regs.gs) || peekat > &(child->regs.ss))
		return EIO;

	    *ret = *peekat;
	    return 0;
	}

    case PTRACE_POKEUSER:
	{
	    /* poke regs */
	    DWORD *pokeat;

	    pokeat = (DWORD *) (WORD) addr;

	    if (pokeat < &(child->regs.gs) || pokeat > &(child->regs.ss))
		return EIO;

	    /* change data for critical regs */
	    if (pokeat == &(child->regs.eflags)) {
		data &= FLAG_MASK;
		data |= *pokeat & ~FLAG_MASK;
	    } else if (pokeat <= &(child->regs.ds)
		       || pokeat == &(child->regs.cs))
		data = *pokeat;
	    else if (pokeat == &(child->regs.esp)) {
		if (verify_illegal(child, data, 4))
		    return EIO;
		child->regs.esp = data ;
		child->regs.esporg = data + 12L ;
	    } else if (pokeat == &(child->regs.esporg)) {
		if (verify_illegal(child, data, 4))
		    return EIO;
		child->regs.esporg = data ;
		child->regs.esp = data - 12L ;
	    } else if (pokeat == &(child->regs.eip))
		if (verify_illegal(child, data, 4))
		    return EIO;

	    *pokeat = data;
	    *ret = data;

	    return 0;
	}

    case PTRACE_STEP:
	npz->p_status = PS_SYS_PTRACE;
	switch_to_process(child);
	npz->p_status = PS_RUN;
	npz->sig_raised = 0;
        npz->sig_ack = 0;
	if (data != 0 && data <= MAX_SIGNALS)
	    send_signal(npz, (WORD)data);
	EFLAGS |= SINGLE_STEP;
	if (ESP == ESPORG)
	    ESP -= 12;
	return 0;

    case PTRACE_RESUME:
	npz->p_status = PS_SYS_PTRACE;
	switch_to_process(child);
	npz->p_status = PS_RUN;
	npz->sig_raised = 0;
        npz->sig_ack = 0;
	if (data > 0 && data <= MAX_SIGNALS)
	    send_signal(npz, (WORD)data);
	if (ESP == ESPORG)
	    ESP -= 12;
	return 0;

    default:
	return EIO;
    }
}
