{*******************************************
 This is a another quick demo of how FRTE
 can be used.  This demo provides a LISTS
 object similar to PROLOG lists.  A variety
 of operators are provided.  FRTE is used
 to inidcate error conditions.
 ******************************************}
uses frte;
  var
    ListError : word;  { If Zero Then no error, if >0 then Error with code}
    ListErrorID : word;
  const
    TrapListErrors : boolean = false;
  type
    {************************************
     The following is an abstract object
     to manipulate Prolog typelists
     ************************************ }
    { Basic List Components }
    listelementPtr = ^listElement;
    listelement = record
      Next: listelementPtr;
      Value:pointer;
      end;

    { Abstract List Object }
    list = object {abstract}
       TheList : listElementptr;
       constructor init;
       { Initializes the List }
       destructor done;
       { Disposes of the list }
       function ListEmpty:boolean;
       { True if this is an empty list }
       procedure tail(var Value);
       { Returns the value of the tail }
       procedure Head(var Value);
       { Returns the value of the Head }
       procedure add(var Value);
       { Adds a value to the top of the List }
       procedure pophead(var Value);
       { Pops off the Head and returns its value }
       procedure poptail(var Value);
       { Pops off the Tail and returns the value }
       { These are the virtual methods that manipulate various list
         types. }
       procedure GetValue(Element:listElementPtr;var Value); virtual;
       procedure GetElement(Var Element:ListElementPtr;var Value); virtual;
       procedure FreeElement(var Element:ListElementPtr); virtual;
       end;

    { Here are the various list types }

    WordList = object (list)
       procedure GetValue(Element:listElementPtr;var Value); virtual;
       procedure GetElement(Var Element:ListElementPtr;var Value); virtual;
       procedure FreeElement(var Element:ListElementPtr); virtual;
       end;

    { Add your own here }


    { OK Here is the Code }
    { --------------------------------}
      procedure WordList.GetValue(Element:listElementPtr;var Value);
      begin
      word(Value) := word(Element^.value^);
      end;
    { --------------------------------}
       procedure WordList.GetElement(var Element:ListElementPtr;var Value);
         begin
         new(Element);
         getmem(Element^.Value,2);
         word(Element^.Value^) := word(value);
         end;
    { --------------------------------}
       procedure WordList.FreeElement(var Element:ListElementPtr);
         begin
         freemem(Element^.value,2);
         dispose(Element);
         end;

    { --------------------------------}
    constructor list.init;
      begin
      TheList := nil;
      end;
    { --------------------------------}
    destructor list.done;
      begin
      while TheList<>nil do
        begin
        FreeElement(TheList);
        TheList := TheList^.next;
        end;
      end;
    { --------------------------------}
    procedure List.GetValue(Element:listElementPtr;var Value);
    begin
    end;
    { --------------------------------}
    procedure List.Tail(var Value);
       var
         Temp:ListElementPtr;
       begin
      Temp := TheList;
      while Temp^.next<>nil do
        Temp := Temp^.next;
       getValue(Temp,Value);
       end;
    { --------------------------------}
    procedure List.Head(var Value);
       begin
       getValue(TheList,Value);
       end;
    { --------------------------------}
    procedure List.add(var Value);
       var
         Temp:ListElementPtr;
       begin
       GetElement(Temp,Value);
       Temp^.next := TheList;
       TheList := Temp;
       end;
    { --------------------------------}
    procedure List.GetElement(Var Element:ListElementPtr;var Value);
      begin
      new(Element);
      end;
    { --------------------------------}
    procedure List.FreeElement(var Element:ListElementPtr);
      begin
      dispose(Element);
      end;
    { --------------------------------}
    procedure List.pophead(var Value);
      var
        Temp:ListElementPtr;
      begin
      if TheList=nil then
        FRTError(Find_Far_Caller(1),204 or ListErrorID)
      else
        begin
        Temp := TheList;
        getValue(Temp,value);
        TheList := TheList^.next;
        FreeElement(Temp);
        end;
      end;
    { --------------------------------}
    procedure List.poptail(var Value);
      var
        tempN,TempL:ListElementPtr;
      begin
      if TheList=nil then
        FRTError(Find_Far_Caller(1),204 or ListErrorId)
      else
        begin
        TempN:=TheList;
        while TempN^.Next<>nil do
          begin
          TempL := TempN;
          TempN := TempN^.Next
          end;
        GetValue(TempN,Value);
        FreeElement(TempN);
        if TempN=TheList then
         TheList:=nil
        else
          TempL^.Next := nil;
        end;
      end;
    { --------------------------------}
      function List.ListEmpty:boolean;
        begin
        If TheList = nil then ListEmpty := true else ListEmpty := false;
        end;

  { THIS IS ALL THE EXTRA CODE THAT IS REALLY NEEDED }
	function TrapErrorHandler (ErrorAddress:pointer; ErrorCode:word):integer;
  far;
    begin
    If TrapListErrors then
      TrapErrorHandler := 1
    else
      begin
      ListError := ErrorCode;
      TrapErrorHandler := 0;
      end;
    end;

   procedure InitializeListSystem;
     begin
     ListErrorID := InstallFrte(TrapErrorHandler);
     end;
   { ------------------- MAIN CODE ----------------}

  var
    A:wordlist;
    WH,WT,W:word;
  begin
    InitializeListSystem;
    A.init;
    W := 1;
    A.add(W);
    A.head(WH);
    A.Tail(WT);
    writeln('The head is = ',WH:3,WT:3);
    W := 2;
    A.add(W);
    A.head(WH);
    A.Tail(WT);
    writeln('The head is = ',WH:3,WT:3);
    W := 3;
    A.Add(w);
    A.head(WH);
    A.Tail(WT);
    writeln('The head is = ',WH:3,WT:3);

    A.head(W);
    write('The head is = ',W);
    A.Tail(W);
    writeln('The Tail is = ',W);
    while not A.ListEmpty do
      begin
      A.pophead(W);
      writeln(W);
      end;
    trapListErrors := true;
    A.pophead(W);
    writeln(ListError);
    A.done
  end.


