VOID AddSysMenuItem ( HWND hwndFrame, MENUITEM *Item, PSZ Text )
{
 /***************************************************************************
  * Local Declarations                                                      *
  ***************************************************************************/

  HWND hwndSysMenu ;
  HWND hwndSysSubMenu ;
  USHORT idSysMenu ;
  MENUITEM miSysMenu ;

 /***************************************************************************
  * Obtain the system menu window handle.                                   *
  ***************************************************************************/

  hwndSysMenu = WinWindowFromID ( hwndFrame, FID_SYSMENU ) ;

 /***************************************************************************
  * Get the system menu's base item and its window handle.                  *
  ***************************************************************************/

  idSysMenu = SHORT1FROMMR ( WinSendMsg ( hwndSysMenu,
                                          MM_ITEMIDFROMPOSITION,
                                          NULL,
                                          NULL ) ) ;

  WinSendMsg ( hwndSysMenu,
               MM_QUERYITEM,
               MPFROM2SHORT(idSysMenu,FALSE),
               MPFROMP(&miSysMenu) ) ;

  hwndSysSubMenu = miSysMenu.hwndSubMenu ;

 /***************************************************************************
  * Add the new item to the system menu's submenu, which is what we see.    *
  ***************************************************************************/

  WinSendMsg ( hwndSysSubMenu, MM_INSERTITEM, MPFROMP(Item), MPFROMP(Text) ) ;
}
