#ifndef __QUEUEOBJ_H__
#define __QUEUEOBJ_H__


#ifndef OS2_INCLUDED
   #ifndef INCL_DOS
     #define INCL_DOS
   #endif
   #ifndef INCL_DOSQUEUES
      #define INCL_DOSQUEUES
   #endif
	#include <os2.h>
#endif


#ifndef _exp_
   #ifdef __DLL__
      #define _exp_ _Export
   #else
      #define _exp_
   #endif
#endif



#include "MemObj.h"


class EventSemaphore;


class QueueObj{

public:

enum _Action{None, Create,Open};

   _exp_ QueueObj(char *ShMemNm,unsigned long MemSize,
                  char *QueueNm,unsigned long flag=QUE_PRIORITY,
                  _Action Mem=None,_Action Queue=None);
   virtual _exp_ ~QueueObj();

   unsigned long GetError(){return Error;}

   void _exp_  OpenMem(char *ShareMemName,unsigned long MemSize);
   void _exp_  CreateMem(char *ShareMemName,unsigned long MemSize);

   void _exp_  SetQueueName(char *N);
   void _exp_  OpenQueue();
   void _exp_   CreateQueue(unsigned long flag=QUE_PRIORITY);

   PID         GetOwner(){return pidQueueOwner;}

   int _exp_   FreeMem(void *Ptr, ULONG Lenght);

protected:

typedef unsigned long HQUEUE;

   HQUEUE hqueue;
   char *QueueName;

   SharedMemoryObj *Memory;

   PID pidQueueOwner;
 
   unsigned long Error;


};





class ClientQueueObj:public QueueObj{

public:
   _exp_ ClientQueueObj(char *ShMemNm,unsigned long MemSize,
          char *QueueNm,unsigned long flag=QUE_PRIORITY,
          _Action Mem=Open,_Action Queue=Open);

   int _exp_ Write(ULONG Req, ULONG Priority=15);
   int _exp_ Write(ULONG Req,char *Buff,ULONG BuffSize, ULONG Priority=15);
 
   void * _exp_ RequestMemBlock(unsigned long BlSize);

protected:
   void * LastBlock;
   unsigned int CurrLenght;

};


class ServerQueueObj:public QueueObj{

public:
   _exp_ ServerQueueObj(char *ShMemNm,unsigned long MemSize,
           char *QueueNm,unsigned long flag=QUE_PRIORITY,
           EventSemaphore *RS=NULL,_Action Mem=Create,_Action Queue=Create);

   PID       GetPID(){return ReqDat.pid;}
   ULONG     UserData(){return ReqDat.ulData;}
   void _exp_ PostSem();
   void _exp_ ResetSem();
   void _exp_ WaitOnSem();

   void* _exp_ Read(ULONG ElCode=0, BOOL wait=0);
   void* _exp_ Peek(ULONG ElCode=0);

   ULONG       GetDataLen(){return DataLen;}
   BYTE        GetPriority(){return Priority;}

   int _exp_   FreeLastReadMem();

protected:

   EventSemaphore *ReadSem;
   REQUESTDATA    ReqDat;
   ULONG          DataLen;
   void           *Entry;
   BYTE           Priority;
};


#endif

