BOOL splitFilename(PCHAR pchFile,PCHAR pchDrive,PCHAR pchPath,PCHAR pchName)
//-------------------------------------------------------------------------
// This function splits a filename into the drive, path, and name components.
// This is the functional equivalent of the MSC 6.0 function _splitpath().
//
// Input:  pchFile - points to the filename to split
// Output:  pchDrive - if not NULL, points to the buffer which receives
//                     the drive portion of the filename
//          pchPath - if not NULL, points to the buffer which receives
//                    the path portion of the filename
//          pchName - if not NULL, points to the buffer which receives
//                    the name portion of the filename
// Returns:  TRUE if successful, FALSE otherwise
//-------------------------------------------------------------------------
{
   PCHAR pchBegin;
   PCHAR pchEnd;

   pchBegin=pchFile;
   pchEnd=strchr(pchBegin,':');

   if (pchDrive!=NULL) {
      *pchDrive=0;

      if (pchEnd!=NULL) {
         strncat(pchDrive,pchBegin,pchEnd-pchBegin+1);
      } /* endif */
   } /* endif */

   if (pchEnd!=NULL) {
      pchBegin=pchEnd+1;
   } /* endif */

   pchEnd=strrchr(pchBegin,'\\');

   if (pchPath!=NULL) {
      *pchPath=0;

      if (pchEnd!=NULL) {
         strncat(pchPath,pchBegin,pchEnd-pchBegin+1);
      } /* endif */
   } /* endif */

   if (pchEnd!=NULL) {
      pchBegin=pchEnd+1;
   } /* endif */

   if (pchName!=NULL) {
      strcpy(pchName,pchBegin);
   } /* endif */

   return TRUE;
}

BOOL isWindowOfClass(HWND hwndWnd,PCHAR pchClass)
//-------------------------------------------------------------------------
// This function determines whether or not the specified window is of
// the specified class.  This will work for either private classes
// (registered with WinRegisterClass) or the public classes (specified
// by a WC_* constant).
//
// Input:  hwndWnd - specifies the window handle.
//         pchClass - points to either the window class or specifies a
//                    WC_* constant to compare with.
// Returns:  TRUE if hwndWnd is of class pchClass, FALSE otherwise.
//-------------------------------------------------------------------------
{
   CHAR achClass[256];
   ATOM aAtom;

   //----------------------------------------------------------------------
   // For the WC_* classes, WinQueryClassName returns the string
   // representation of the integer atom as stored in the system atom
   // table.  The string representation of *any* integer atom is expressed
   // in the form "#ddddd", where 'ddddd' are the decimal digits specifying
   // the value of the atom.
   //
   // We can check the first character of the class name returned to see
   // if the window is of a predefined type.
   //----------------------------------------------------------------------
   WinQueryClassName(hwndWnd,sizeof(achClass),achClass);

   if (achClass[0]=='#') {
      //-------------------------------------------------------------------
      // We have a WC_* window, so check to see if pchClass is also a
      // predefined class.  If so, the high word is 0xFFFF.
      //-------------------------------------------------------------------
      if (HIUSHORT(pchClass)!=(USHORT)0xFFFF) {
         return FALSE;
      } /* endif */

      //-------------------------------------------------------------------
      // Get the integer representation of the atom and compare it
      // against the low word of pchClass, which is also the integer
      // representation of the class it represents.
      //-------------------------------------------------------------------
      aAtom=WinFindAtom(WinQuerySystemAtomTable(),achClass);
      if (aAtom==LOUSHORT(pchClass)) {
         return TRUE;
      } /* endif */
   } else {
      //-------------------------------------------------------------------
      // We don't have a WC_* window, so check to see if pchClass is not
      // also.  If it isn't, compare the classes using strcmp().
      //-------------------------------------------------------------------
      if (HIUSHORT(pchClass)==(USHORT)0xFFFF) {
         return FALSE;
      } /* endif */

      if (strcmp(achClass,pchClass)==0) {
         return TRUE;
      } /* endif */
   } /* endif */

   return FALSE;
}
