#define INCL_WININPUT
#define INCL_WINSTDCNR
#define INCL_WINSTDDRAG
#define INCL_WINSYS
#define INCL_WINWINDOWMGR
#include "defs.h"
#include <stdlib.h>
#include <string.h>

BOOL initContainer(PINSTDATA pidData)
//-------------------------------------------------------------------------
// This function initializes the container in detail view by allocating
// and inserting the FIELDINFO structures.
//
// Input:  pidData - points to the instance data of the application
// Returns:  TRUE/FALSE success indicator
//-------------------------------------------------------------------------
{
   PFIELDINFO pfiDetails;
   PFIELDINFO pfiCurrent;
   FIELDINFOINSERT fiiDetails;
   CNRINFO ciInfo;

   pfiDetails=(PFIELDINFO)PVOIDFROMMR(WinSendMsg(pidData->hwndCnr,
                                                 CM_ALLOCDETAILFIELDINFO,
                                                 MPFROMSHORT(MAX_DETAILFIELDS),
                                                 0));
   if (pfiDetails==NULL) {
      return FALSE;
   } /* endif */

   //----------------------------------------------------------------------
   // Initialize each FIELDINFO structure.  (Sigh) I wish there were a
   // way to condense this a bit.
   //----------------------------------------------------------------------
   pfiCurrent=pfiDetails;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlHwndItem;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchHwndItem);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlUlItemID;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchUlItemID);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlHstrType;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchHstrType);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlHstrRMF;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchHstrRMF);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlHstrContainerName;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchHstrContainerName);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlHstrSourceName;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchHstrSourceName);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlHstrTargetName;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchHstrTargetName);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlCxOffset;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchCxOffset);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlCyOffset;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchCyOffset);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlFsControl;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchFsControl);
   pfiCurrent->pUserData=NULL;

   pfiCurrent=pfiCurrent->pNextFieldInfo;

   pfiCurrent->cb=sizeof(FIELDINFO);
   pfiCurrent->flData=CFA_STRING|CFA_HORZSEPARATOR|CFA_SEPARATOR;
   pfiCurrent->flTitle=CFA_LEFT|CFA_VCENTER;
   pfiCurrent->pTitleData=pidData->achTtlFsSupportedOps;
   pfiCurrent->offStruct=FIELDOFFSET(CNRRECORD,iiInfo.pchFsSupportedOps);
   pfiCurrent->pUserData=NULL;

   //----------------------------------------------------------------------
   // Insert the FIELDINFO structures and change to detail view
   //----------------------------------------------------------------------
   fiiDetails.cb=sizeof(FIELDINFOINSERT);
   fiiDetails.pFieldInfoOrder=(PFIELDINFO)CMA_FIRST;
   fiiDetails.fInvalidateFieldInfo=TRUE;
   fiiDetails.cFieldInfoInsert=MAX_DETAILFIELDS;

   WinSendMsg(pidData->hwndCnr,
              CM_INSERTDETAILFIELDINFO,
              MPFROMP(pfiDetails),
              MPFROMP(&fiiDetails));

   ciInfo.flWindowAttr=CV_DETAIL|CA_DETAILSVIEWTITLES;

   WinSendMsg(pidData->hwndCnr,
              CM_SETCNRINFO,
              MPFROMP(&ciInfo),
              MPFROMLONG(CMA_FLWINDOWATTR));

   return TRUE;
}

BOOL displayDragitems(PDRAGINFO pdiInfo,HWND hwndCnr)
//-------------------------------------------------------------------------
// This function adds the contents of the linked list to the container.
// 'Tis rather trivial.
//
// Input:  pdiInfo - points to the DRAGINFO structure of the items being
//                   dragged
//         hwndCnr - handle of the container window
// Returns:  TRUE/FALSE success indicator
//-------------------------------------------------------------------------
{
   PCNRRECORD pcrRecords;
   PCNRRECORD pcrCurrent;
   USHORT usIndex;
   DRAGITEM diItem;
   CHAR achField[256];
   RECORDINSERT riInsert;

   //----------------------------------------------------------------------
   // Get the number of records to insert and allocate them from the
   // container.
   //----------------------------------------------------------------------
   pcrRecords=(PCNRRECORD)PVOIDFROMMR(WinSendMsg(hwndCnr,
                                                 CM_ALLOCRECORD,
                                                 MPFROMLONG(sizeof(CNRRECORD)-sizeof(MINIRECORDCORE)),
                                                 MPFROMSHORT(pdiInfo->cditem)));
   if (pcrRecords==NULL) {
      return FALSE;
   } /* endif */

   //----------------------------------------------------------------------
   // Loop and initialize each record.
   //----------------------------------------------------------------------
   pcrCurrent=pcrRecords;

   for (usIndex=0; usIndex<pdiInfo->cditem; usIndex++) {
      DrgQueryDragitem(pdiInfo,sizeof(diItem),&diItem,usIndex);

      pcrCurrent->mrcCore.pszIcon=(PSZ)&pcrCurrent->iiInfo;
      pcrCurrent->mrcCore.hptrIcon=NULLHANDLE;
      memset(&pcrCurrent->iiInfo,0,sizeof(ITEMINFO));

      sprintf(pcrCurrent->iiInfo.achHwndItem,"0x%08lX",diItem.hwndItem);
      sprintf(pcrCurrent->iiInfo.achUlItemID,"%ld",diItem.ulItemID);

      DrgQueryStrName(diItem.hstrType,sizeof(achField),achField);
      sprintf(pcrCurrent->iiInfo.achHstrType,"\"%s\"",achField);

      DrgQueryStrName(diItem.hstrRMF,sizeof(achField),achField);
      sprintf(pcrCurrent->iiInfo.achHstrRMF,"\"%s\"",achField);

      DrgQueryStrName(diItem.hstrContainerName,sizeof(achField),achField);
      sprintf(pcrCurrent->iiInfo.achHstrContainerName,"\"%s\"",achField);

      DrgQueryStrName(diItem.hstrSourceName,sizeof(achField),achField);
      sprintf(pcrCurrent->iiInfo.achHstrSourceName,"\"%s\"",achField);

      DrgQueryStrName(diItem.hstrTargetName,sizeof(achField),achField);
      sprintf(pcrCurrent->iiInfo.achHstrTargetName,"\"%s\"",achField);

      sprintf(pcrCurrent->iiInfo.achCxOffset,"%d",diItem.cxOffset);
      sprintf(pcrCurrent->iiInfo.achCyOffset,"%d",diItem.cyOffset);
      sprintf(pcrCurrent->iiInfo.achFsControl,"0x%04X",diItem.fsControl);
      sprintf(pcrCurrent->iiInfo.achFsSupportedOps,
              "0x%04X",
              diItem.fsSupportedOps);

      pcrCurrent->iiInfo.pchHwndItem=
         pcrCurrent->iiInfo.achHwndItem;
      pcrCurrent->iiInfo.pchUlItemID=
         pcrCurrent->iiInfo.achUlItemID;
      pcrCurrent->iiInfo.pchHstrType=
         pcrCurrent->iiInfo.achHstrType;
      pcrCurrent->iiInfo.pchHstrRMF=
         pcrCurrent->iiInfo.achHstrRMF;
      pcrCurrent->iiInfo.pchHstrContainerName=
         pcrCurrent->iiInfo.achHstrContainerName;
      pcrCurrent->iiInfo.pchHstrSourceName=
         pcrCurrent->iiInfo.achHstrSourceName;
      pcrCurrent->iiInfo.pchHstrTargetName=
         pcrCurrent->iiInfo.achHstrTargetName;
      pcrCurrent->iiInfo.pchCxOffset=
         pcrCurrent->iiInfo.achCxOffset;
      pcrCurrent->iiInfo.pchCyOffset=
         pcrCurrent->iiInfo.achCyOffset;
      pcrCurrent->iiInfo.pchFsControl=
         pcrCurrent->iiInfo.achFsControl;
      pcrCurrent->iiInfo.pchFsSupportedOps=
         pcrCurrent->iiInfo.achFsSupportedOps;

      pcrCurrent=(PCNRRECORD)pcrCurrent->mrcCore.preccNextRecord;
   } /* endfor */

   //----------------------------------------------------------------------
   // Delete the current records and insert the new records.
   //----------------------------------------------------------------------
   WinSendMsg(hwndCnr,CM_REMOVERECORD,MPFROMP(NULL),MPFROM2SHORT(0,CMA_FREE));

   riInsert.cb=sizeof(RECORDINSERT);
   riInsert.pRecordOrder=(PRECORDCORE)CMA_END;
   riInsert.pRecordParent=NULL;
   riInsert.fInvalidateRecord=TRUE;
   riInsert.zOrder=CMA_TOP;
   riInsert.cRecordsInsert=pdiInfo->cditem;

   WinSendMsg(hwndCnr,
              CM_INSERTRECORD,
              MPFROMP(pcrRecords),
              MPFROMP(&riInsert));
   return TRUE;
}

MRESULT EXPENTRY wndProc(HWND hwndWnd,
                         ULONG ulMsg,
                         MPARAM mpParm1,
                         MPARAM mpParm2)
{
   PINSTDATA pidData;

   pidData=(PINSTDATA)WinQueryWindowPtr(hwndWnd,0);

   switch (ulMsg) {
   case WM_CREATE:
      {
         CHAR achFont[32];

         pidData=calloc(1,sizeof(INSTDATA));
         if (pidData==NULL) {
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            return MRFROMSHORT(TRUE);
         } /* endif */

         WinSetWindowPtr(hwndWnd,0,pidData);

         pidData->ulSzStruct=sizeof(INSTDATA);
         pidData->habAnchor=WinQueryAnchorBlock(hwndWnd);
         pidData->hwndFrame=WinQueryWindow(hwndWnd,QW_PARENT);
         pidData->bEndDrag=TRUE;

         pidData->hwndCnr=WinCreateWindow(hwndWnd,
                                          WC_CONTAINER,
                                          "",
                                          CCS_EXTENDSEL | CCS_MINIRECORDCORE,
                                          0,
                                          0,
                                          0,
                                          0,
                                          hwndWnd,
                                          HWND_TOP,
                                          WND_CNR,
                                          NULL,
                                          NULL);
         if (pidData->hwndCnr==NULLHANDLE) {
            WinAlarm(HWND_DESKTOP,WA_ERROR);
            free(pidData);
            return MRFROMSHORT(TRUE);
         } /* endif */

         strcpy(achFont,"8.Helv");
         WinSetPresParam(pidData->hwndCnr,
                         PP_FONTNAMESIZE,
                         strlen(achFont)+1,
                         achFont);

         //----------------------------------------------------------------
         // Since the container does not copy detail view titles into its
         // own global space, we must keep them in our instance data, so
         // initialize the strings from the STRINGTABLE.
         //----------------------------------------------------------------
         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLHWNDITEM,
                       sizeof(pidData->achTtlHwndItem),
                       pidData->achTtlHwndItem);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLULITEMID,
                       sizeof(pidData->achTtlUlItemID),
                       pidData->achTtlUlItemID);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLHSTRTYPE,
                       sizeof(pidData->achTtlHstrType),
                       pidData->achTtlHstrType);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLHSTRRMF,
                       sizeof(pidData->achTtlHstrRMF),
                       pidData->achTtlHstrRMF);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLHSTRCONTAINERNAME,
                       sizeof(pidData->achTtlHstrContainerName),
                       pidData->achTtlHstrContainerName);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLHSTRSOURCENAME,
                       sizeof(pidData->achTtlHstrSourceName),
                       pidData->achTtlHstrSourceName);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLHSTRTARGETNAME,
                       sizeof(pidData->achTtlHstrTargetName),
                       pidData->achTtlHstrTargetName);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLCXOFFSET,
                       sizeof(pidData->achTtlCxOffset),
                       pidData->achTtlCxOffset);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLCYOFFSET,
                       sizeof(pidData->achTtlCyOffset),
                       pidData->achTtlCyOffset);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLFSCONTROL,
                       sizeof(pidData->achTtlFsControl),
                       pidData->achTtlFsControl);

         WinLoadString(pidData->habAnchor,
                       NULLHANDLE,
                       STR_TTLFSSUPPORTEDOPS,
                       sizeof(pidData->achTtlFsSupportedOps),
                       pidData->achTtlFsSupportedOps);

         initContainer(pidData);
      }
      break;
   case WM_DESTROY:
      WinDestroyWindow(pidData->hwndCnr);
      free(pidData);
      break;
   case WM_SIZE:
      WinSetWindowPos(pidData->hwndCnr,
                      NULLHANDLE,
                      0,
                      0,
                      SHORT1FROMMP(mpParm2),
                      SHORT2FROMMP(mpParm2),
                      SWP_MOVE|SWP_SIZE|SWP_SHOW);
      break;
   case WM_CONTROL:
      if (SHORT1FROMMP(mpParm1)==WND_CNR) {
         switch (SHORT2FROMMP(mpParm1)) {
         case CN_DRAGOVER:
            {
               PCNRDRAGINFO pcdiDrag;

               //----------------------------------------------------------
               // If the drag operation is still in progress, don't
               // reinitialize
               //----------------------------------------------------------
               if (pidData->bEndDrag) {
                  pidData->bEndDrag=FALSE;
                  pcdiDrag=(PCNRDRAGINFO)PVOIDFROMMP(mpParm2);
                  displayDragitems(pcdiDrag->pDragInfo,pidData->hwndCnr);
               } /* endif */

               return MRFROM2SHORT(DOR_NODROP,DO_DEFAULT);
            }
            break;
         case CN_DRAGLEAVE:
            //-------------------------------------------------------------
            // We will receive this whenever a) the mouse moves outside
            // of the container, b) the mouse button was released, or c)
            // the user presses ESC.  Flag the drag operation as completed.
            //-------------------------------------------------------------
            if (!pidData->bEndDrag) {
               pidData->bEndDrag=TRUE;
            } /* endif */
            break;
         default:
            return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endswitch */
      } else {
         return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } /* endif */
      break;
   case WM_PAINT:
      {
         HPS hpsPaint;
         RECTL rclPaint;

         hpsPaint=WinBeginPaint(hwndWnd,NULLHANDLE,&rclPaint);
         WinFillRect(hpsPaint,&rclPaint,SYSCLR_WINDOW);
         WinEndPaint(hpsPaint);
      }
      break;
   default:
      return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMSHORT(FALSE);
}

INT main(VOID)
//-------------------------------------------------------------------------
// Typical PM main() function.
//-------------------------------------------------------------------------
{
   HAB habAnchor;
   HMQ hmqQueue;
   CHAR achTitle[64];
   ULONG ulCreate;
   HWND hwndFrame;
   HWND hwndClient;
   BOOL bLoop;
   QMSG qmMsg;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   WinRegisterClass(habAnchor,CLS_CLIENT,wndProc,0,sizeof(PVOID));

   WinLoadString(habAnchor,NULLHANDLE,STR_TITLE,sizeof(achTitle),achTitle);

   ulCreate=FCF_SYSMENU | FCF_TITLEBAR | FCF_MINMAX | FCF_SIZEBORDER |
               FCF_SHELLPOSITION | FCF_TASKLIST;

   hwndFrame=WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &ulCreate,
                                CLS_CLIENT,
                                achTitle,
                                0,
                                NULLHANDLE,
                                RES_CLIENT,
                                &hwndClient);
   if (hwndFrame!=NULLHANDLE) {
      bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      while (bLoop) {
         WinDispatchMsg(habAnchor,&qmMsg);
         bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      } /* endwhile */

      WinDestroyWindow(hwndFrame);
   } /* endif */

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
