/*------------------------------------------------------------------
 * roxprof.cmd :
 *------------------------------------------------------------------
 * 04-12-94 originally by Patrick J. Mueller
 *------------------------------------------------------------------*/

numeric digits 15

parse arg iFile kind .
if (iFile = "") | (iFile = "?") then
   Usage()

kind = translate(kind)

if (kind = "") then kind = "TIME"

if (kind = "TIME") then signal TimeStats

if (kind = "FLOW") then signal FlowStats

/*------------------------------------------------------------------
 * execution time stats
 *------------------------------------------------------------------*/
TimeStats:

table.  = ""
table.0 = 0

stack   = 0
stack.0 = 0

/*------------------------------------------------------------------
 * collect info
 *------------------------------------------------------------------*/
do while (lines(iFile) <> 0)
   line = linein(iFile)
   if (word(line,1) <> "stat:") then
      iterate

   parse var line . which method time

   if (which = "entry") then
      do
      push method time
      stack = stack + 1
      stack.stack = 0
      iterate
      end

   parse pull bMethod bTime

   if (method <> bMethod) then
      do
      say "invalid stat sequence!"
      exit
      end

   elapsed = time - bTime

   if (table.method = "") then
      do
      o = table.0 + 1
      table.0 = o
      table.o = method
      table.method = o

      table.o.!count = 0
      table.o.!total = 0
      table.o.!atime = 0
      table.o.!max   = 0
      table.o.!min   = 0
      end

    index = table.method

    table.index.!count = table.index.!count + 1
    table.index.!total = table.index.!total + elapsed

    if (table.index.!max = 0) | (table.index.!max < elapsed) then
       table.index.!max = elapsed

    if (table.index.!min = 0) | (table.index.!min > elapsed) then
       table.index.!min = elapsed

    prevStack = stack - 1
    stack.prevStack = stack.prevStack + elapsed

    table.index.!atime = table.index.!atime + elapsed - stack.stack

    stack = stack - 1
end

rc = stream(iFile,"C","CLOSE")

/*------------------------------------------------------------------
 * print info
 *------------------------------------------------------------------*/

say "   calls tot.time act.time      avg      max      min  method "
say "-------- -------- -------- --------  ------- --------  ------------------"
do i = 1 to table.0
   count = right(table.i.!count,8)
   total = r8(table.i.!total)
   atime = r8(table.i.!atime)
   max   = r8(table.i.!max)
   min   = r8(table.i.!min)
   avg   = r8(total / count)

   say count total atime avg max min " "table.i
end

exit

/*------------------------------------------------------------------
 *
 *------------------------------------------------------------------*/
FlowStats:

indent = 0

/*------------------------------------------------------------------
 * collect info
 *------------------------------------------------------------------*/
do while (lines(iFile) <> 0)
   line = linein(iFile)
   if (word(line,1) <> "stat:") then
      iterate

   parse var line . which method time

   if (which = "entry") then
      do
      say copies(" ",indent) || method
      indent = indent + 1
      end

   else
      indent = indent - 1
end

rc = stream(iFile,"C","CLOSE")

exit

/*------------------------------------------------------------------
 * lrl
 *------------------------------------------------------------------*/
r8:
   return format(arg(1),4,3)

/*------------------------------------------------------------------
 * some simple help
 *------------------------------------------------------------------*/
Usage: procedure
   parse source os . me .
   if (os = "OS/2") then parse value filespec("name",me) with me "." .

   say "usage:"
   say "   " me "<inputFile> [TIME | FLOW]"
   say "is used to print ROX profile information collected by turning"
   say "on the RoxStats() function.  Timing information or flow information"
   say "will be printed depending on the second parameter (default=TIME)"

   exit
