/* user interface */
#define APP_CLASS		"GPlot"	/* for resource specification */
#define DEFAULT_FONT		"6x13"	/* default font for graphics */
#define DEFAULT_WIDTH		512	/* default window width */
#define DEFAULT_HEIGHT		512	/* default window height */

/* data structure sizes */
#define DEFAULT_MARKER_SIZE	10	/* in pixels; gplot recalculates */
#define MAX_POINTS		128	/* for lines, markers, & polygons */
#define MAX_SEGMENTS		48	/* must be a multiple of 2 and of 3 */

/* --------------------------------------------------------------------------
 * ==>	 You must take responsibility for any problems which may occur
 * as a result of changing anything below this point.
 */

#define DEVICE_COLOR_TABLE_SIZE	256    /* the size of your device color table */
					/* Gplot Default Color Table */	
#define GDCT_MAX_INDEX		255			/* max index */
#define GDCT_SIZE	((GDCT_MAX_INDEX + 1) * 3)	/* element count */

#ifndef MIN
#define MIN(a,b) ((a) < (b)) ? (a) : (b)
#endif
#ifndef MAX
#define MAX(a,b) ((a) > (b)) ? (a) : (b)
#endif

/* symbolic constants for last parameter of xws_get_pixel() */
#define BACK_IDX	0		/* default color index - background */
#define FORE_IDX	1		/* default color index - foreground */

/* gplot interface describes these return values for driver functions */
#define	GPLOT_FATAL		0 /* fatal error */
#define GPLOT_SUCCESS		1 /* success */
#define GPLOT_DRIVER_ERROR	2 /* survivable error made by driver */
#define GPLOT_INVALID_PARAMETER	4 /* survivable error made by gplot parser */
#define GPLOT_DRIVER_INCAPABLE	8 /* device incapable of request */

/* X variables, intended to be global to the X driver routines ONLY.
 * Requires prior inclusion of <X11/Intrinsic.h>
 */
/* The redefinition of Dpy, Win, and Topwin are for compatibility
 * with the GPlot X user interface modules, written after this code.
 */
#define Dpy display_ptr
#define Win window_id
#define Topwin top_window_id
extern Widget	Toplevel;		/* toolkit */
extern Display	*Dpy;			/* Xlib */
extern int	Scr;			/* Xlib */
extern Window	Win;			/* Xlib */
extern Window	Topwin;			/* Xlib */
extern XWindowAttributes window_attributes; /* attributes of Win */
extern GC	LineGC;			/* graphic contexts */
extern GC	MarkerGC;
extern GC	PolygonGC;
extern GC	EdgeGC;
extern GC	CellArrayGC;
extern GC	TextGC;
extern XFontStruct *Xfs;		/* X font information */	
extern XPoint	Points[MAX_POINTS];	/* polylines, points, & markers */
extern XSegment Segments[MAX_SEGMENTS];	/* disjoint polylines & markers */
extern Cursor	WaitCursor;		/* mouse cursor */
extern Cursor	ReadyCursor;		/* another mouse cursor */
extern XImage	*sample_image;		/* sample image for this device */

/* Other variables, intended to be global to the X driver routines ONLY.
 * Requires prior inclusion of "defs.h"
 */
extern char			*ProgramName;	/* copy of argv[0] pointer */
extern struct mf_d_struct	*CGMClass1;
extern struct pic_d_struct	*CGMClass2;
extern struct control_struct	*CGMClass3;
extern struct attrib_struct	*CGMClass5;
extern struct info_struct       *pDev_xws;
extern short			MaxY;		/* max y coordinate in window */
extern short			MaxX;		/* max x coordinate in window */
extern short	Metafile_Defaults;	/* metafile default color flag */
extern int	my_bit_order,		/* bit order for this machine */
		my_byte_order;		/* byte order for this machine */
extern int      manage_own_window;      /* flag to indicate if driver needs to
					 * open and manage its window */

typedef unsigned long Pixeltype;	/* type is the same as GC pixel type */

typedef struct RGBtuple {float r,g,b; } RGBtuple;

/* 
X driver functions, callable by gplot and by other X driver routines.
xws_ctab may be NULL, indicating that there is no need to call the 
associated routine.
*/
extern void	xws_setup();
extern int	xws_begin(),
		xws_bpage(),
                xws_bpic(),
		xws_carray(),
		(*xws_ctab)(),
		xws_dpline(),
		xws_end(),
		xws_epage(), 
		xws_e_colour(),
		xws_e_type(),
		xws_e_width(),
		xws_fl_colour(),
		xws_fl_style(),
		xws_l_colour(),
		xws_l_type(),
		xws_l_width(),
		xws_mk_colour(),
		xws_mk_size(),
		xws_mk_type(),
		xws_pgon(),
		xws_pline(),
		xws_pmarker(),
		xws_text(),
		xws_t_align(),
		xws_t_colour();

/* 
X driver functions, to be called only by other X driver routines.
xws_get_pixel and xws_get row are guaranteed to be valid function pointers.
(They are initialized by xws_color_init()).  xws_bp_color may be NULL,
indicating that there is no need to make a begin-page color setting call.
*/

extern Pixeltype (*xws_get_pixel)(),	/* returns pixel value */
		*(*xws_get_row)();	/* returns row of pixel values */
extern void	(*xws_bp_color)(),	/* does color handling at begin page */
		xws_color_init(),	/* initializes color handling */
		(*xws_cmapin)(),	/* swaps in device color map */
		(*xws_cmapout)(),	/* swaps out device color map */
		xws_edge();		/* draws polygon edge */
