/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  b_queue.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/





#ifndef BQUEUEH
#define BQUEUEH

//------------------------------------------------------------------------------
// bounded queues
//------------------------------------------------------------------------------

#include <LEDA/basic.h>


#define b_queue_body(type) {\
        type* v;\
        int n;\
        int start;\
        int end;\
public:										\
_b_queue(type)(int s) \
{ if (s<1) error_handler(88,"_b_queue: bad size");\
  n = s+1; \
  v = new type[n];\
  if (v==0) error_handler(88,"_b_queue: out of memory");\
  start = end = 0; \
}\
\
~_b_queue(type)() {}\
\
int empty() const { return (size()==0) ? true : false; }\
\
int size() const \
{ int s = end-start;\
  return (s<0) ?  (n+s) : s;\
}\
\
void append(type& a)\
{ v[end++] = a;\
  end %= n;\
  if (start==end) error_handler(88, "_b_queue overflow");\
}\
\
type pop()\
{ if (start==end) error_handler(88, "_b_queue underflow");\
  type x = v[start];\
  start = (start+1) % n;\
  return x;\
}\
\
type top() const\
{ if (start==end) error_handler(88, "_b_queue empty");\
  return v[start];\
}\
\
void clear() { start = end = 0; }\
};


#ifdef __TEMPLATES__
#define _b_queue(T) b_queue
template<class T> class b_queue b_queue_body(T)

#else
#define _b_queue(T) name2(T,b_queue)
#define b_queue(T) name2(T,b_queue)
#define b_queuedeclare(T) class b_queue(T) b_queue_body(T)

#endif

#endif
