/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  h_array.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


//------------------------------------------------------------------------------
// _h_array  
//------------------------------------------------------------------------------ 
#ifndef HARRAYH
#define HARRAYH

#include <LEDA/basic.h> 
#include <LEDA/slist.h> 
#include <LEDA/dp_hashing.h> 

#define h_array_body(itype,etype) : public dphash {\
\
itype name2(itype,X1);\
etype name2(etype,X2);\
\
void clear_key(GenPtr& x)   const { Clear(ACCESS1(itype,x)); }\
void clear_inf(GenPtr& x)   const { Clear(ACCESS2(etype,x)); }\
void copy_key(GenPtr& x)    const { x=Copy(ACCESS1(itype,x));  }\
void copy_inf(GenPtr& x)    const { x=Copy(ACCESS2(etype,x));  }\
\
etype init;\
SLIST def_list;\
\
public:\
\
etype& operator[](itype y) { stp i=lookup(Convert(y));\
                             if (i==nil) { i=insert(Convert(y),Convert(init));\
                                           def_list.append(Convert(y));  }\
                             return ACCESS2(etype,info(i)); }\
/*\
etype  operator[](itype y) const\
                           { stp i=lookup(Convert(y));\
                             if (i==nil) return init;\
                             else return ACCESS2(etype,info(i)); }\
*/\
bool defined(itype y)    { return member(Convert(y)); }\
\
void init_iterator()     { def_list.init_iterator(); }\
bool next_index(itype& y){ GenPtr p; bool b=def_list.next_element(p);\
                           y = ACCESS1(itype,p); return b; }\
\
_h_array(itype,etype)() { }\
_h_array(itype,etype)(int n,itype* I,etype* E): dphash(n,(GenPtr*)I,(GenPtr*)E) { }\
_h_array(itype,etype)(etype i) { init=i; }\
_h_array(itype,etype)(_h_array(itype,etype)& A): dphash((dphash&)A)\
{ init = A.init; }\
~_h_array(itype,etype)() { def_list.clear(); };\
};


#ifdef __TEMPLATES__
#define _h_array(I,E) h_array
template<class I, class E> class h_array h_array_body(I,E)

#else
#define _h_array(I,E) name3(I,E,h_array)
#define h_array(I,E) name3(I,E,h_array)
#define h_arraydeclare2(I,E) class h_array(I,E) h_array_body(I,E)

#endif

#define forall_defined(i,A)  for ((A).init_iterator(); (A).next_index(i); )


#endif
