/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  k_heap.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef KHEAP_H
#define KHEAP_H

//------------------------------------------------------------------------------
// K-nary Heaps
//------------------------------------------------------------------------------


#include <LEDA/basic.h>
#include <LEDA/slist.h>


typedef int k_heap_item;


class K_HEAP  {

virtual int  cmp(GenPtr x, GenPtr y) const { return int(x)-int(y); }
virtual void print_key(GenPtr& x) const { Print(x); }
virtual void print_inf(GenPtr& x) const { Print(x); }

int  K;
GenPtr* Key;
GenPtr* Inf;
int*       Pos;
int*       Item;

SLIST free_items;

int count;
int max_count;

void rise(int&,GenPtr,GenPtr);
void sink(int&,GenPtr,GenPtr);


public:

 K_HEAP(int,int=2);
~K_HEAP();

int insert(GenPtr k, GenPtr i);
int insert0(GenPtr k, GenPtr i);

void decrease_inf(k_heap_item, GenPtr);

void change_key(k_heap_item it, GenPtr k) { Key[Pos[it]] = k; }

GenPtr del_item(k_heap_item);

GenPtr del_min()   { return del_item(Item[0]); }

GenPtr  key(int it) const { return Key[Pos[it]]; }
GenPtr  inf(int it) const { return Inf[Pos[it]]; }

k_heap_item  find_min()  const { return (count>0) ? Item[0] : 0;  }

int  size()    const   { return count;    }
bool empty()   const  { return count==0; }
void clear();

void print();

};

class k_heap : public K_HEAP {

virtual int  cmp(GenPtr x, GenPtr y) const { return int(x)-int(y); }
virtual void print_key(GenPtr& x) const { Print(x); }
virtual void print_inf(GenPtr& x) const { Print(x); }

public:

 k_heap(int N,int k=2) : K_HEAP(N,k) {};
~k_heap() {};

k_heap_item insert(GenPtr k, int i) { return K_HEAP::insert(k,Convert(i)); };

void decrease_inf(k_heap_item it, int x) { K_HEAP::decrease_inf(it,Convert(x)); };

int  inf(k_heap_item it) const { return (int)K_HEAP::key(it); }

};


#endif
