/*
 * File: main_loop.M.c
 *   By: Dave Hiebeler
 *       July 1989
 *
 * Generate a transition-table for Margolus neighborhood
 */

#include <stdio.h>
#include <math.h>
#include "nborhood.h"

#define add_index(k)	index <<= L;  index |= k

func_ptr update_function;

main()
{
    char    *ta;			/* t-table array       */
    FILE   *fopen(), *fp;
    int L, N, TSIZE, index, AMASK;
    int     c, ccw, opp, cw, phase;
    margolus_nbors nbors;


    L = (short) (log((double) NSTATES) / log((double) 2.0));
    N = 5;
    TSIZE = 1 << (L*N);
    AMASK = NSTATES-1;
    if ((ta=(char *)malloc(TSIZE))==NULL) {
	fprintf(stderr,"Couldn't malloc memory for table\n");
	exit(1);
    }
    printf("NSTATES = %d\n",NSTATES);
    init_function();
    for (c = 0; c < NSTATES; c++)
	for (ccw = 0; ccw < NSTATES; ccw++)
	    for (opp = 0; opp < NSTATES; opp++)
		for (cw = 0; cw < NSTATES; cw++)
		    for (phase = 0; phase < NSTATES; phase++) {

		    index = 0;
		    add_index(c);
		    add_index(ccw);
		    add_index(opp);
		    add_index(cw);
		    add_index(phase);

		    nbors.c = c;
		    nbors.cw = cw;
		    nbors.ccw = ccw;
		    nbors.opp = opp;
		    nbors.phase = phase;
		    ta[index] = (update_function(&nbors) & AMASK);

		}


    fp = fopen(OUTPUT, "w");
    fwrite(ta, sizeof(*ta), TSIZE, fp);
    fclose(fp);

}
